/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.mongodb.atlas;

import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;

public class MongoDBAtlasFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    protected void doExpression(Filter.Expression expression, StringBuilder context) {
        if (Filter.ExpressionType.AND.equals((Object)expression.type()) || Filter.ExpressionType.OR.equals((Object)expression.type())) {
            this.doCompoundExpressionType(expression, context);
        } else {
            this.doSingleExpressionType(expression, context);
        }
    }

    private void doCompoundExpressionType(Filter.Expression expression, StringBuilder context) {
        context.append("{");
        context.append(this.getOperationSymbol(expression));
        context.append(":[");
        this.convertOperand(expression.left(), context);
        context.append(",");
        this.convertOperand(expression.right(), context);
        context.append("]}");
    }

    private void doSingleExpressionType(Filter.Expression expression, StringBuilder context) {
        context.append("{");
        this.convertOperand(expression.left(), context);
        context.append(":{");
        context.append(this.getOperationSymbol(expression));
        context.append(":");
        this.convertOperand(expression.right(), context);
        context.append("}}");
    }

    private String getOperationSymbol(Filter.Expression exp) {
        switch (exp.type()) {
            case AND: {
                return "$and";
            }
            case OR: {
                return "$or";
            }
            case EQ: {
                return "$eq";
            }
            case NE: {
                return "$ne";
            }
            case LT: {
                return "$lt";
            }
            case LTE: {
                return "$lte";
            }
            case GT: {
                return "$gt";
            }
            case GTE: {
                return "$gte";
            }
            case IN: {
                return "$in";
            }
            case NIN: {
                return "$nin";
            }
        }
        throw new RuntimeException("Not supported expression type:" + String.valueOf(exp.type()));
    }

    protected void doKey(Filter.Key filterKey, StringBuilder context) {
        String identifier = this.hasOuterQuotes(filterKey.key()) ? this.removeOuterQuotes(filterKey.key()) : filterKey.key();
        context.append("\"metadata." + identifier + "\"");
    }
}

