/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.util.json.schema;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigPart;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.tool.annotation.ToolParam;
import org.springframework.core.Nullness;
import org.springframework.util.StringUtils;

public final class SpringAiSchemaModule
implements Module {
    private final boolean requiredByDefault;

    public SpringAiSchemaModule(Option ... options) {
        this.requiredByDefault = Stream.of(options).noneMatch(option -> option == Option.PROPERTY_REQUIRED_FALSE_BY_DEFAULT);
    }

    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        this.applyToConfigBuilder((SchemaGeneratorConfigPart<FieldScope>)builder.forFields());
    }

    private void applyToConfigBuilder(SchemaGeneratorConfigPart<FieldScope> configPart) {
        configPart.withDescriptionResolver(this::resolveDescription);
        configPart.withRequiredCheck(this::checkRequired);
    }

    private @Nullable String resolveDescription(MemberScope<?, ?> member) {
        ToolParam toolParamAnnotation = (ToolParam)member.getAnnotationConsideringFieldAndGetter(ToolParam.class);
        if (toolParamAnnotation != null && StringUtils.hasText((String)toolParamAnnotation.description())) {
            return toolParamAnnotation.description();
        }
        return null;
    }

    private boolean checkRequired(MemberScope<?, ?> member) {
        Nullness nullness;
        ToolParam toolParamAnnotation = (ToolParam)member.getAnnotationConsideringFieldAndGetter(ToolParam.class);
        if (toolParamAnnotation != null) {
            return toolParamAnnotation.required();
        }
        JsonProperty propertyAnnotation = (JsonProperty)member.getAnnotationConsideringFieldAndGetter(JsonProperty.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.required();
        }
        Schema schemaAnnotation = (Schema)member.getAnnotationConsideringFieldAndGetter(Schema.class);
        if (schemaAnnotation != null) {
            return schemaAnnotation.requiredMode() == Schema.RequiredMode.REQUIRED || schemaAnnotation.requiredMode() == Schema.RequiredMode.AUTO || schemaAnnotation.required();
        }
        if (member instanceof FieldScope) {
            FieldScope fs = (FieldScope)member;
            nullness = Nullness.forField((Field)((Field)fs.getRawMember()));
        } else if (member instanceof MethodScope) {
            MethodScope ms = (MethodScope)member;
            nullness = Nullness.forMethodReturnType((Method)((Method)ms.getRawMember()));
        } else {
            throw new IllegalStateException("Unsupported member type: " + String.valueOf(member));
        }
        if (nullness == Nullness.NULLABLE) {
            return false;
        }
        return this.requiredByDefault;
    }

    public static enum Option {
        PROPERTY_REQUIRED_FALSE_BY_DEFAULT;

    }
}

