/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.tool.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import org.springframework.ai.observation.conventions.SpringAiKind;
import org.springframework.ai.tool.observation.ToolCallingObservationContext;
import org.springframework.ai.tool.observation.ToolCallingObservationConvention;
import org.springframework.ai.tool.observation.ToolCallingObservationDocumentation;
import org.springframework.util.Assert;

public class DefaultToolCallingObservationConvention
implements ToolCallingObservationConvention {
    public static final String DEFAULT_NAME = "spring.ai.tool";
    private final String name;

    public DefaultToolCallingObservationConvention() {
        this(DEFAULT_NAME);
    }

    public DefaultToolCallingObservationConvention(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getContextualName(ToolCallingObservationContext context) {
        Assert.notNull((Object)((Object)context), (String)"context cannot be null");
        String toolName = context.getToolDefinition().name();
        return "%s %s".formatted(SpringAiKind.TOOL_CALL.value(), toolName);
    }

    public KeyValues getLowCardinalityKeyValues(ToolCallingObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.aiOperationType(context), this.aiProvider(context), this.springAiKind(context), this.toolDefinitionName(context)});
    }

    protected KeyValue aiOperationType(ToolCallingObservationContext context) {
        return KeyValue.of((KeyName)ToolCallingObservationDocumentation.LowCardinalityKeyNames.AI_OPERATION_TYPE, (String)context.getOperationMetadata().operationType());
    }

    protected KeyValue aiProvider(ToolCallingObservationContext context) {
        return KeyValue.of((KeyName)ToolCallingObservationDocumentation.LowCardinalityKeyNames.AI_PROVIDER, (String)context.getOperationMetadata().provider());
    }

    protected KeyValue springAiKind(ToolCallingObservationContext context) {
        return KeyValue.of((KeyName)ToolCallingObservationDocumentation.LowCardinalityKeyNames.SPRING_AI_KIND, (String)SpringAiKind.TOOL_CALL.value());
    }

    protected KeyValue toolDefinitionName(ToolCallingObservationContext context) {
        String toolName = context.getToolDefinition().name();
        return KeyValue.of((KeyName)ToolCallingObservationDocumentation.LowCardinalityKeyNames.TOOL_DEFINITION_NAME, (String)toolName);
    }

    public KeyValues getHighCardinalityKeyValues(ToolCallingObservationContext context) {
        KeyValues keyValues = KeyValues.empty();
        keyValues = this.toolDefinitionDescription(keyValues, context);
        keyValues = this.toolDefinitionSchema(keyValues, context);
        return keyValues;
    }

    protected KeyValues toolDefinitionDescription(KeyValues keyValues, ToolCallingObservationContext context) {
        String toolDescription = context.getToolDefinition().description();
        return keyValues.and(ToolCallingObservationDocumentation.HighCardinalityKeyNames.TOOL_DEFINITION_DESCRIPTION.asString(), toolDescription);
    }

    protected KeyValues toolDefinitionSchema(KeyValues keyValues, ToolCallingObservationContext context) {
        String toolSchema = context.getToolDefinition().inputSchema();
        return keyValues.and(ToolCallingObservationDocumentation.HighCardinalityKeyNames.TOOL_DEFINITION_SCHEMA.asString(), toolSchema);
    }
}

