/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.tool.augment;

import java.util.Arrays;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.augment.AugmentedArgumentEvent;
import org.springframework.ai.tool.augment.AugmentedToolCallback;
import org.springframework.ai.tool.method.MethodToolCallbackProvider;

public class AugmentedToolCallbackProvider<T extends Record>
implements ToolCallbackProvider {
    private final ToolCallbackProvider delegate;
    private final boolean removeExtraArgumentsAfterProcessing;
    private final Consumer<AugmentedArgumentEvent<T>> argumentConsumer;
    private final Class<T> argumentType;

    public AugmentedToolCallbackProvider(Object toolObject, Class<T> argumentType, Consumer<AugmentedArgumentEvent<T>> argumentConsumer, boolean removeExtraArgumentsAfterProcessing) {
        this(MethodToolCallbackProvider.builder().toolObjects(toolObject).build(), argumentType, argumentConsumer, removeExtraArgumentsAfterProcessing);
    }

    public AugmentedToolCallbackProvider(ToolCallbackProvider delegate, Class<T> argumentType, Consumer<AugmentedArgumentEvent<T>> argumentConsumer, boolean removeExtraArgumentsAfterProcessing) {
        this.delegate = delegate;
        this.argumentType = argumentType;
        this.argumentConsumer = argumentConsumer;
        this.removeExtraArgumentsAfterProcessing = removeExtraArgumentsAfterProcessing;
    }

    @Override
    public ToolCallback[] getToolCallbacks() {
        return (ToolCallback[])Arrays.stream(this.delegate.getToolCallbacks()).map(toolCallback -> new AugmentedToolCallback<T>((ToolCallback)toolCallback, this.argumentType, this.argumentConsumer, this.removeExtraArgumentsAfterProcessing)).toArray(ToolCallback[]::new);
    }

    public static <T extends Record> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T extends Record> {
        private @Nullable ToolCallbackProvider delegate;
        private boolean removeExtraArgumentsAfterProcessing = true;
        private @Nullable Consumer<AugmentedArgumentEvent<T>> argumentConsumer;
        private @Nullable Class<T> argumentType;
        private @Nullable Object toolObject;

        public Builder<T> delegate(ToolCallbackProvider delegate) {
            this.delegate = delegate;
            return this;
        }

        public Builder<T> toolObject(Object toolObject) {
            this.toolObject = toolObject;
            return this;
        }

        public Builder<T> argumentType(Class<T> argumentType) {
            this.argumentType = argumentType;
            return this;
        }

        public Builder<T> argumentConsumer(Consumer<AugmentedArgumentEvent<T>> argumentConsumer) {
            this.argumentConsumer = argumentConsumer;
            return this;
        }

        public Builder<T> removeExtraArgumentsAfterProcessing(boolean removeExtraArgumentsAfterProcessing) {
            this.removeExtraArgumentsAfterProcessing = removeExtraArgumentsAfterProcessing;
            return this;
        }

        public AugmentedToolCallbackProvider<T> build() {
            if (this.argumentType == null) {
                throw new IllegalStateException("argumentType is required");
            }
            if (this.argumentConsumer == null) {
                throw new IllegalStateException("argumentConsumer is required");
            }
            if (this.delegate != null && this.toolObject != null) {
                throw new IllegalStateException("Cannot set both delegate and toolObject");
            }
            if (this.delegate == null && this.toolObject == null) {
                throw new IllegalStateException("Either delegate or toolObject must be set");
            }
            if (this.toolObject != null) {
                return new AugmentedToolCallbackProvider<T>(this.toolObject, this.argumentType, this.argumentConsumer, this.removeExtraArgumentsAfterProcessing);
            }
            if (this.delegate != null) {
                return new AugmentedToolCallbackProvider<T>(this.delegate, this.argumentType, this.argumentConsumer, this.removeExtraArgumentsAfterProcessing);
            }
            throw new IllegalStateException();
        }
    }
}

