/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.tool;

import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.tool.metadata.ToolMetadata;

public interface ToolCallback {
    public static final Logger logger = LoggerFactory.getLogger(ToolCallback.class);

    public ToolDefinition getToolDefinition();

    default public ToolMetadata getToolMetadata() {
        return ToolMetadata.builder().build();
    }

    public String call(String var1);

    default public String call(String toolInput, @Nullable ToolContext toolContext) {
        if (toolContext != null && !toolContext.getContext().isEmpty()) {
            logger.info("By default the tool context is not used,  override the method 'call(String toolInput, ToolContext toolcontext)' to support the use of tool context.Review the ToolCallback implementation for {}", (Object)this.getToolDefinition().name());
        }
        return this.call(toolInput);
    }
}

