/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.moderation;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.model.ModelResponse;
import org.springframework.ai.moderation.Generation;
import org.springframework.ai.moderation.ModerationResponseMetadata;

public class ModerationResponse
implements ModelResponse<Generation> {
    private final ModerationResponseMetadata moderationResponseMetadata;
    private final @Nullable Generation generation;

    public ModerationResponse(@Nullable Generation generation) {
        this(generation, new ModerationResponseMetadata());
    }

    public ModerationResponse(@Nullable Generation generation, ModerationResponseMetadata moderationResponseMetadata) {
        this.moderationResponseMetadata = moderationResponseMetadata;
        this.generation = generation;
    }

    @Override
    public @Nullable Generation getResult() {
        return this.generation;
    }

    @Override
    public List<Generation> getResults() {
        if (this.generation == null) {
            return Collections.emptyList();
        }
        return List.of(this.generation);
    }

    @Override
    public ModerationResponseMetadata getMetadata() {
        return this.moderationResponseMetadata;
    }

    public String toString() {
        return "ModerationResponse{moderationResponseMetadata=" + String.valueOf(this.moderationResponseMetadata) + ", generations=" + String.valueOf(this.generation) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModerationResponse)) {
            return false;
        }
        ModerationResponse that = (ModerationResponse)o;
        return Objects.equals(this.moderationResponseMetadata, that.moderationResponseMetadata) && Objects.equals(this.generation, that.generation);
    }

    public int hashCode() {
        return Objects.hash(this.moderationResponseMetadata, this.generation);
    }
}

