/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.transformer;

import java.util.HashMap;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentTransformer;
import org.springframework.util.Assert;

public class KeywordMetadataEnricher
implements DocumentTransformer {
    private static final Logger logger = LoggerFactory.getLogger(KeywordMetadataEnricher.class);
    public static final String CONTEXT_STR_PLACEHOLDER = "context_str";
    public static final String KEYWORDS_TEMPLATE = "{context_str}. Give %s unique keywords for this\ndocument. Format as comma separated. Keywords:";
    public static final String EXCERPT_KEYWORDS_METADATA_KEY = "excerpt_keywords";
    private final ChatModel chatModel;
    private final PromptTemplate keywordsTemplate;

    public KeywordMetadataEnricher(ChatModel chatModel, int keywordCount) {
        Assert.notNull((Object)chatModel, (String)"chatModel must not be null");
        Assert.isTrue((keywordCount >= 1 ? 1 : 0) != 0, (String)"keywordCount must be >= 1");
        this.chatModel = chatModel;
        this.keywordsTemplate = new PromptTemplate(String.format(KEYWORDS_TEMPLATE, keywordCount));
    }

    public KeywordMetadataEnricher(ChatModel chatModel, PromptTemplate keywordsTemplate) {
        Assert.notNull((Object)chatModel, (String)"chatModel must not be null");
        Assert.notNull((Object)keywordsTemplate, (String)"keywordsTemplate must not be null");
        this.chatModel = chatModel;
        this.keywordsTemplate = keywordsTemplate;
    }

    public List<Document> apply(List<Document> documents) {
        for (Document document : documents) {
            String keywords;
            Prompt prompt;
            Generation generation;
            String text = document.getText();
            HashMap<String, Object> vars = new HashMap<String, Object>();
            if (text != null) {
                vars.put(CONTEXT_STR_PLACEHOLDER, text);
            }
            if ((generation = this.chatModel.call(prompt = this.keywordsTemplate.create(vars)).getResult()) == null || (keywords = generation.getOutput().getText()) == null) continue;
            document.getMetadata().put(EXCERPT_KEYWORDS_METADATA_KEY, keywords);
        }
        return documents;
    }

    PromptTemplate getKeywordsTemplate() {
        return this.keywordsTemplate;
    }

    public static Builder builder(ChatModel chatModel) {
        return new Builder(chatModel);
    }

    public static final class Builder {
        private final ChatModel chatModel;
        private int keywordCount;
        private @Nullable PromptTemplate keywordsTemplate;

        public Builder(ChatModel chatModel) {
            Assert.notNull((Object)chatModel, (String)"The chatModel must not be null");
            this.chatModel = chatModel;
        }

        public Builder keywordCount(int keywordCount) {
            Assert.isTrue((keywordCount >= 1 ? 1 : 0) != 0, (String)"The keywordCount must be >= 1");
            this.keywordCount = keywordCount;
            return this;
        }

        public Builder keywordsTemplate(PromptTemplate keywordsTemplate) {
            Assert.notNull((Object)keywordsTemplate, (String)"The keywordsTemplate must not be null");
            this.keywordsTemplate = keywordsTemplate;
            return this;
        }

        public KeywordMetadataEnricher build() {
            if (this.keywordsTemplate != null) {
                if (this.keywordCount != 0) {
                    logger.warn("keywordCount will be ignored as keywordsTemplate is set.");
                }
                return new KeywordMetadataEnricher(this.chatModel, this.keywordsTemplate);
            }
            return new KeywordMetadataEnricher(this.chatModel, this.keywordCount);
        }
    }
}

