/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.converter.ResponseTextCleaner;
import org.springframework.util.Assert;

public class ThinkingTagCleaner
implements ResponseTextCleaner {
    private static final List<Pattern> DEFAULT_PATTERNS = Arrays.asList(Pattern.compile("(?s)<thinking>.*?</thinking>\\s*", 2), Pattern.compile("(?s)<think>.*?</think>\\s*", 2), Pattern.compile("(?s)<reasoning>.*?</reasoning>\\s*", 2), Pattern.compile("(?s)```thinking.*?```\\s*", 2), Pattern.compile("(?s)<!--\\s*thinking:.*?-->\\s*", 2));
    private final List<Pattern> patterns;

    public ThinkingTagCleaner() {
        this(DEFAULT_PATTERNS);
    }

    public ThinkingTagCleaner(List<Pattern> patterns) {
        Assert.notNull(patterns, (String)"patterns cannot be null");
        Assert.notEmpty(patterns, (String)"patterns cannot be empty");
        this.patterns = new ArrayList<Pattern>(patterns);
    }

    public ThinkingTagCleaner(String ... patternStrings) {
        Assert.notNull((Object)patternStrings, (String)"patternStrings cannot be null");
        Assert.notEmpty((Object[])patternStrings, (String)"patternStrings cannot be empty");
        this.patterns = new ArrayList<Pattern>();
        for (String patternString : patternStrings) {
            this.patterns.add(Pattern.compile(patternString, 2));
        }
    }

    @Override
    public @Nullable String clean(@Nullable String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (!text.contains("<") && !text.contains("`")) {
            return text;
        }
        String result = text;
        for (Pattern pattern : this.patterns) {
            String afterReplacement = pattern.matcher(result).replaceAll("");
            if (afterReplacement.equals(result)) continue;
            result = afterReplacement;
        }
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<Pattern> patterns = new ArrayList<Pattern>(DEFAULT_PATTERNS);
        private boolean useDefaultPatterns = true;

        private Builder() {
        }

        public Builder withoutDefaultPatterns() {
            this.useDefaultPatterns = false;
            return this;
        }

        public Builder addPattern(String patternString) {
            Assert.hasText((String)patternString, (String)"patternString cannot be empty");
            if (!this.useDefaultPatterns) {
                this.patterns.clear();
                this.useDefaultPatterns = true;
            }
            this.patterns.add(Pattern.compile(patternString, 2));
            return this;
        }

        public Builder addPattern(Pattern pattern) {
            Assert.notNull((Object)pattern, (String)"pattern cannot be null");
            if (!this.useDefaultPatterns) {
                this.patterns.clear();
                this.useDefaultPatterns = true;
            }
            this.patterns.add(pattern);
            return this;
        }

        public ThinkingTagCleaner build() {
            return new ThinkingTagCleaner(this.patterns);
        }
    }
}

