/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.prompt;

import java.util.Map;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.ai.template.TemplateRenderer;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class SystemPromptTemplate
extends PromptTemplate {
    public SystemPromptTemplate(String template) {
        super(template);
    }

    public SystemPromptTemplate(Resource resource) {
        super(resource);
    }

    private SystemPromptTemplate(String template, Map<String, Object> variables, TemplateRenderer renderer) {
        super(template, variables, renderer);
    }

    private SystemPromptTemplate(Resource resource, Map<String, Object> variables, TemplateRenderer renderer) {
        super(resource, variables, renderer);
    }

    @Override
    public Message createMessage() {
        return new SystemMessage(this.render());
    }

    @Override
    public Message createMessage(Map<String, Object> model) {
        return new SystemMessage(this.render(model));
    }

    @Override
    public Prompt create() {
        return new Prompt((Message)new SystemMessage(this.render()));
    }

    @Override
    public Prompt create(Map<String, Object> model) {
        return new Prompt((Message)new SystemMessage(this.render(model)));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends PromptTemplate.Builder {
        @Override
        public Builder template(String template) {
            Assert.hasText((String)template, (String)"template cannot be null or empty");
            this.template = template;
            return this;
        }

        @Override
        public Builder resource(Resource resource) {
            Assert.notNull((Object)resource, (String)"resource cannot be null");
            this.resource = resource;
            return this;
        }

        @Override
        public Builder variables(Map<String, Object> variables) {
            Assert.notNull(variables, (String)"variables cannot be null");
            Assert.noNullElements(variables.keySet(), (String)"variables keys cannot be null");
            this.variables = variables;
            return this;
        }

        @Override
        public Builder renderer(TemplateRenderer renderer) {
            Assert.notNull((Object)renderer, (String)"renderer cannot be null");
            this.renderer = renderer;
            return this;
        }

        @Override
        public SystemPromptTemplate build() {
            if (this.template != null && this.resource != null) {
                throw new IllegalArgumentException("Only one of template or resource can be set");
            }
            if (this.resource != null) {
                return new SystemPromptTemplate(this.resource, (Map<String, Object>)this.variables, this.renderer);
            }
            if (this.template != null) {
                return new SystemPromptTemplate(this.template, (Map<String, Object>)this.variables, this.renderer);
            }
            throw new IllegalStateException("Neither template nor resource is set");
        }
    }
}

