/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.prompt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.chat.prompt.PromptTemplateActions;
import org.springframework.ai.chat.prompt.PromptTemplateMessageActions;
import org.springframework.ai.content.Media;
import org.springframework.ai.template.TemplateRenderer;
import org.springframework.ai.template.st.StTemplateRenderer;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class PromptTemplate
implements PromptTemplateActions,
PromptTemplateMessageActions {
    private static final Logger log = LoggerFactory.getLogger(PromptTemplate.class);
    private static final TemplateRenderer DEFAULT_TEMPLATE_RENDERER = StTemplateRenderer.builder().build();
    private final String template;
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private final TemplateRenderer renderer;

    public PromptTemplate(Resource resource) {
        this(resource, new HashMap<String, Object>(), DEFAULT_TEMPLATE_RENDERER);
    }

    public PromptTemplate(String template) {
        this(template, new HashMap<String, Object>(), DEFAULT_TEMPLATE_RENDERER);
    }

    PromptTemplate(String template, Map<String, Object> variables, TemplateRenderer renderer) {
        Assert.hasText((String)template, (String)"template cannot be null or empty");
        Assert.notNull(variables, (String)"variables cannot be null");
        Assert.noNullElements(variables.keySet(), (String)"variables keys cannot be null");
        Assert.notNull((Object)renderer, (String)"renderer cannot be null");
        this.template = template;
        this.variables.putAll(variables);
        this.renderer = renderer;
    }

    PromptTemplate(Resource resource, Map<String, Object> variables, TemplateRenderer renderer) {
        Assert.notNull((Object)resource, (String)"resource cannot be null");
        Assert.notNull(variables, (String)"variables cannot be null");
        Assert.noNullElements(variables.keySet(), (String)"variables keys cannot be null");
        Assert.notNull((Object)renderer, (String)"renderer cannot be null");
        try (InputStream inputStream = resource.getInputStream();){
            this.template = StreamUtils.copyToString((InputStream)inputStream, (Charset)Charset.defaultCharset());
            Assert.hasText((String)this.template, (String)"template cannot be null or empty");
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read resource", ex);
        }
        this.variables.putAll(variables);
        this.renderer = renderer;
    }

    public void add(String name, Object value) {
        this.variables.put(name, value);
    }

    public String getTemplate() {
        return this.template;
    }

    @Override
    public String render() {
        HashMap<String, @Nullable Object> processedVariables = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.variables.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof Resource) {
                Resource resource = (Resource)object;
                processedVariables.put(entry.getKey(), this.renderResource(resource));
                continue;
            }
            processedVariables.put(entry.getKey(), entry.getValue());
        }
        return this.renderer.apply(this.template, processedVariables);
    }

    @Override
    public String render(Map<String, Object> additionalVariables) {
        HashMap<String, @Nullable String> combinedVariables = new HashMap<String, String>();
        HashMap<String, Object> mergedVariables = new HashMap<String, Object>(this.variables);
        if (additionalVariables != null && !additionalVariables.isEmpty()) {
            mergedVariables.putAll(additionalVariables);
        }
        for (Map.Entry entry : mergedVariables.entrySet()) {
            Object v = entry.getValue();
            if (v instanceof Resource) {
                Resource resource = (Resource)v;
                combinedVariables.put((String)entry.getKey(), this.renderResource(resource));
                continue;
            }
            combinedVariables.put((String)entry.getKey(), (String)entry.getValue());
        }
        return this.renderer.apply(this.template, combinedVariables);
    }

    private String renderResource(Resource resource) {
        if (resource == null) {
            return "";
        }
        try {
            if (resource instanceof ByteArrayResource) {
                ByteArrayResource byteArrayResource = (ByteArrayResource)resource;
                return new String(byteArrayResource.getByteArray(), StandardCharsets.UTF_8);
            }
            if (!resource.exists() || resource.contentLength() == 0L) {
                return "";
            }
            return resource.getContentAsString(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.warn("Failed to render resource: {}", (Object)resource.getDescription(), (Object)e);
            return "[Unable to render resource: " + resource.getDescription() + "]";
        }
    }

    @Override
    public Message createMessage() {
        return new UserMessage(this.render());
    }

    @Override
    public Message createMessage(List<Media> mediaList) {
        return UserMessage.builder().text(this.render()).media(mediaList).build();
    }

    @Override
    public Message createMessage(Map<String, Object> additionalVariables) {
        return new UserMessage(this.render(additionalVariables));
    }

    @Override
    public Prompt create() {
        return new Prompt(this.render(new HashMap<String, Object>()));
    }

    @Override
    public Prompt create(ChatOptions modelOptions) {
        return Prompt.builder().content(this.render(new HashMap<String, Object>())).chatOptions(modelOptions).build();
    }

    @Override
    public Prompt create(Map<String, Object> additionalVariables) {
        return new Prompt(this.render(additionalVariables));
    }

    @Override
    public Prompt create(Map<String, Object> additionalVariables, ChatOptions modelOptions) {
        return Prompt.builder().content(this.render(additionalVariables)).chatOptions(modelOptions).build();
    }

    public Builder mutate() {
        return new Builder().template(this.template).variables(this.variables).renderer(this.renderer);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected @Nullable String template;
        protected @Nullable Resource resource;
        protected Map<String, Object> variables = new HashMap<String, Object>();
        protected TemplateRenderer renderer = DEFAULT_TEMPLATE_RENDERER;

        protected Builder() {
        }

        public Builder template(String template) {
            Assert.hasText((String)template, (String)"template cannot be null or empty");
            this.template = template;
            return this;
        }

        public Builder resource(Resource resource) {
            Assert.notNull((Object)resource, (String)"resource cannot be null");
            this.resource = resource;
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            Assert.notNull(variables, (String)"variables cannot be null");
            Assert.noNullElements(variables.keySet(), (String)"variables keys cannot be null");
            this.variables = variables;
            return this;
        }

        public Builder renderer(TemplateRenderer renderer) {
            Assert.notNull((Object)renderer, (String)"renderer cannot be null");
            this.renderer = renderer;
            return this;
        }

        public PromptTemplate build() {
            if (this.template != null && this.resource != null) {
                throw new IllegalArgumentException("Only one of template or resource can be set");
            }
            if (this.resource != null) {
                return new PromptTemplate(this.resource, this.variables, this.renderer);
            }
            if (this.template != null) {
                return new PromptTemplate(this.template, this.variables, this.renderer);
            }
            throw new IllegalStateException("Neither template nor resource is set");
        }
    }
}

