/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.prompt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.chat.prompt.ChatOptions;

public class DefaultChatOptions
implements ChatOptions {
    private @Nullable String model;
    private @Nullable Double frequencyPenalty;
    private @Nullable Integer maxTokens;
    private @Nullable Double presencePenalty;
    private @Nullable List<String> stopSequences;
    private @Nullable Double temperature;
    private @Nullable Integer topK;
    private @Nullable Double topP;

    @Override
    public @Nullable String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    @Override
    public @Nullable Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @Override
    public @Nullable Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @Override
    public @Nullable Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @Override
    public @Nullable List<String> getStopSequences() {
        return this.stopSequences != null ? Collections.unmodifiableList(this.stopSequences) : null;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    @Override
    public @Nullable Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    @Override
    public @Nullable Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    @Override
    public @Nullable Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    @Override
    public <T extends ChatOptions> T copy() {
        DefaultChatOptions copy = new DefaultChatOptions();
        if (this.model != null) {
            copy.setModel(this.model);
        }
        if (this.frequencyPenalty != null) {
            copy.setFrequencyPenalty(this.frequencyPenalty);
        }
        if (this.maxTokens != null) {
            copy.setMaxTokens(this.maxTokens);
        }
        if (this.presencePenalty != null) {
            copy.setPresencePenalty(this.presencePenalty);
        }
        if (this.stopSequences != null) {
            copy.setStopSequences(new ArrayList<String>(this.stopSequences));
        }
        if (this.temperature != null) {
            copy.setTemperature(this.temperature);
        }
        if (this.topK != null) {
            copy.setTopK(this.topK);
        }
        if (this.topP != null) {
            copy.setTopP(this.topP);
        }
        return (T)copy;
    }
}

