/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.messages;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.chat.messages.AbstractMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.MessageUtils;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class SystemMessage
extends AbstractMessage {
    public SystemMessage(@Nullable String textContent) {
        this(textContent, Map.of());
    }

    public SystemMessage(Resource resource) {
        this(MessageUtils.readResource(resource), Map.of());
    }

    private SystemMessage(@Nullable String textContent, Map<String, Object> metadata) {
        super(MessageType.SYSTEM, textContent, metadata);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SystemMessage)) {
            return false;
        }
        SystemMessage that = (SystemMessage)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.textContent, that.textContent);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.textContent);
    }

    public String toString() {
        return "SystemMessage{textContent='" + this.textContent + "', messageType=" + String.valueOf((Object)this.messageType) + ", metadata=" + String.valueOf(this.metadata) + "}";
    }

    public SystemMessage copy() {
        return new SystemMessage(this.getText(), Map.copyOf(this.metadata));
    }

    public Builder mutate() {
        Builder builder = new Builder();
        if (this.textContent != null) {
            builder.text(this.textContent);
        }
        builder.metadata(this.metadata);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private @Nullable String textContent;
        private @Nullable Resource resource;
        private Map<String, Object> metadata = new HashMap<String, Object>();

        public Builder text(String textContent) {
            this.textContent = textContent;
            return this;
        }

        public Builder text(Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public SystemMessage build() {
            if (StringUtils.hasText((String)this.textContent) && this.resource != null) {
                throw new IllegalArgumentException("textContent and resource cannot be set at the same time");
            }
            if (this.resource != null) {
                this.textContent = MessageUtils.readResource(this.resource);
            }
            return new SystemMessage(this.textContent, this.metadata);
        }
    }
}

