/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.aot;

import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOP_FallbackServiceProvider;
import org.slf4j.helpers.SubstituteServiceProvider;
import org.springframework.ai.aot.AiRuntimeHints;
import org.springframework.ai.chat.messages.AbstractMessage;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.content.Content;
import org.springframework.ai.content.MediaContent;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SpringAiCoreRuntimeHints
implements RuntimeHintsRegistrar {
    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        Set<Class> chatTypes = Set.of(AbstractMessage.class, AssistantMessage.class, ToolResponseMessage.class, Message.class, ToolCallback.class, ToolDefinition.class, AssistantMessage.ToolCall.class, MessageType.class, UserMessage.class, SystemMessage.class, Content.class, MediaContent.class);
        MemberCategory[] memberCategories = MemberCategory.values();
        for (Class c : chatTypes) {
            hints.reflection().registerType(c, memberCategories);
            Set<TypeReference> innerClassesFor = AiRuntimeHints.findInnerClassesFor(c);
            for (TypeReference cc : innerClassesFor) {
                hints.reflection().registerType(cc, memberCategories);
            }
        }
        for (String r : Set.of("embedding/embedding-model-dimensions.properties")) {
            hints.resources().registerResource((Resource)new ClassPathResource(r));
        }
        Set<Class<LoggerFactory>> slf4jTypes = Set.of(NOP_FallbackServiceProvider.class, SubstituteServiceProvider.class, LoggerFactory.class);
        for (Class<LoggerFactory> c : slf4jTypes) {
            hints.reflection().registerType(TypeReference.of(c), new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.DECLARED_FIELDS});
        }
    }
}

