/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Deprecated
public class DefaultFunctionCallingOptions
implements FunctionCallingOptions {
    private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
    private Set<String> functions = new HashSet<String>();
    private Boolean proxyToolCalls = false;
    private Map<String, Object> context = new HashMap<String, Object>();
    private String model;
    private Double frequencyPenalty;
    private Integer maxTokens;
    private Double presencePenalty;
    private List<String> stopSequences;
    private Double temperature;
    private Integer topK;
    private Double topP;

    @Override
    public List<FunctionCallback> getFunctionCallbacks() {
        return Collections.unmodifiableList(this.functionCallbacks);
    }

    @Override
    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        Assert.notNull(functionCallbacks, (String)"FunctionCallbacks must not be null");
        this.functionCallbacks = new ArrayList<FunctionCallback>(functionCallbacks);
    }

    @Override
    public Set<String> getFunctions() {
        return Collections.unmodifiableSet(this.functions);
    }

    @Override
    public void setFunctions(Set<String> functions) {
        Assert.notNull(functions, (String)"Functions must not be null");
        this.functions = new HashSet<String>(functions);
    }

    @Override
    public Boolean getProxyToolCalls() {
        return this.proxyToolCalls;
    }

    @Override
    public void setProxyToolCalls(Boolean proxyToolCalls) {
        this.proxyToolCalls = proxyToolCalls;
    }

    @Override
    public Map<String, Object> getToolContext() {
        return Collections.unmodifiableMap(this.context);
    }

    @Override
    public void setToolContext(Map<String, Object> context) {
        Assert.notNull(context, (String)"Context must not be null");
        this.context = new HashMap<String, Object>(context);
    }

    @Override
    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    @Override
    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @Override
    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @Override
    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @Override
    public List<String> getStopSequences() {
        return this.stopSequences != null ? Collections.unmodifiableList(this.stopSequences) : null;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    @Override
    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    @Override
    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    @Override
    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    @Override
    public <T extends ChatOptions> T copy() {
        DefaultFunctionCallingOptions copy = new DefaultFunctionCallingOptions();
        copy.setModel(this.getModel());
        copy.setFrequencyPenalty(this.getFrequencyPenalty());
        copy.setMaxTokens(this.getMaxTokens());
        copy.setPresencePenalty(this.getPresencePenalty());
        copy.setStopSequences((List<String>)(this.getStopSequences() != null ? new ArrayList<String>(this.getStopSequences()) : null));
        copy.setTemperature(this.getTemperature());
        copy.setTopK(this.getTopK());
        copy.setTopP(this.getTopP());
        copy.setFunctions(new HashSet<String>(this.functions));
        copy.setFunctionCallbacks(new ArrayList<FunctionCallback>(this.functionCallbacks));
        copy.setProxyToolCalls(this.proxyToolCalls);
        copy.setToolContext(new HashMap<String, Object>(this.getToolContext()));
        return (T)copy;
    }

    public FunctionCallingOptions merge(ChatOptions options) {
        FunctionCallingOptions.Builder builder = FunctionCallingOptions.builder();
        builder.model(StringUtils.hasText((String)options.getModel()) ? options.getModel() : this.getModel()).frequencyPenalty(options.getFrequencyPenalty() != null ? options.getFrequencyPenalty() : this.getFrequencyPenalty()).maxTokens(options.getMaxTokens() != null ? options.getMaxTokens() : this.getMaxTokens()).presencePenalty(options.getPresencePenalty() != null ? options.getPresencePenalty() : this.getPresencePenalty()).stopSequences((List)(options.getStopSequences() != null ? options.getStopSequences() : this.getStopSequences())).temperature(options.getTemperature() != null ? options.getTemperature() : this.getTemperature()).topK(options.getTopK() != null ? options.getTopK() : this.getTopK()).topP(options.getTopP() != null ? options.getTopP() : this.getTopP());
        if (options instanceof FunctionCallingOptions) {
            FunctionCallingOptions functionOptions = (FunctionCallingOptions)options;
            builder.proxyToolCalls(functionOptions.getProxyToolCalls() != null ? functionOptions.getProxyToolCalls() : this.proxyToolCalls);
            HashSet<String> functions = new HashSet<String>();
            if (!CollectionUtils.isEmpty(this.functions)) {
                functions.addAll(this.functions);
            }
            if (!CollectionUtils.isEmpty(functionOptions.getFunctions())) {
                functions.addAll(functionOptions.getFunctions());
            }
            builder.functions(functions);
            ArrayList<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
            if (!CollectionUtils.isEmpty(this.functionCallbacks)) {
                functionCallbacks.addAll(this.functionCallbacks);
            }
            if (!CollectionUtils.isEmpty(functionOptions.getFunctionCallbacks())) {
                functionCallbacks.addAll(functionOptions.getFunctionCallbacks());
            }
            builder.functionCallbacks(functionCallbacks);
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (!CollectionUtils.isEmpty(this.context)) {
                context.putAll(this.context);
            }
            if (!CollectionUtils.isEmpty(functionOptions.getToolContext())) {
                context.putAll(functionOptions.getToolContext());
            }
            builder.toolContext(context);
        } else {
            builder.proxyToolCalls(this.proxyToolCalls);
            builder.functions(new HashSet<String>(this.functions));
            builder.functionCallbacks(new ArrayList<FunctionCallback>(this.functionCallbacks));
            builder.toolContext(new HashMap<String, Object>(this.context));
        }
        return builder.build();
    }
}

