/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mistralai;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.mistralai.api.MistralAiApi;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MistralAiChatOptions
implements FunctionCallingOptions,
ChatOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="temperature")
    private Float temperature;
    @JsonProperty(value="top_p")
    private Float topP;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="safe_prompt")
    private Boolean safePrompt;
    @JsonProperty(value="random_seed")
    private Integer randomSeed;
    @JsonProperty(value="response_format")
    private MistralAiApi.ChatCompletionRequest.ResponseFormat responseFormat;
    @NestedConfigurationProperty
    @JsonProperty(value="stop")
    private List<String> stop;
    @NestedConfigurationProperty
    @JsonProperty(value="tools")
    private List<MistralAiApi.FunctionTool> tools;
    @NestedConfigurationProperty
    @JsonProperty(value="tool_choice")
    private MistralAiApi.ChatCompletionRequest.ToolChoice toolChoice;
    @NestedConfigurationProperty
    @JsonIgnore
    private List<FunctionCallback> functionCallbacks = new ArrayList<FunctionCallback>();
    @NestedConfigurationProperty
    @JsonIgnore
    private Set<String> functions = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Boolean getSafePrompt() {
        return this.safePrompt;
    }

    public void setSafePrompt(Boolean safePrompt) {
        this.safePrompt = safePrompt;
    }

    public Integer getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(Integer randomSeed) {
        this.randomSeed = randomSeed;
    }

    public MistralAiApi.ChatCompletionRequest.ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(MistralAiApi.ChatCompletionRequest.ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public void setTools(List<MistralAiApi.FunctionTool> tools) {
        this.tools = tools;
    }

    public List<MistralAiApi.FunctionTool> getTools() {
        return this.tools;
    }

    public void setToolChoice(MistralAiApi.ChatCompletionRequest.ToolChoice toolChoice) {
        this.toolChoice = toolChoice;
    }

    public MistralAiApi.ChatCompletionRequest.ToolChoice getToolChoice() {
        return this.toolChoice;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public Float getTopP() {
        return this.topP;
    }

    public void setTopP(Float topP) {
        this.topP = topP;
    }

    public List<FunctionCallback> getFunctionCallbacks() {
        return this.functionCallbacks;
    }

    public void setFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
        Assert.notNull(functionCallbacks, (String)"FunctionCallbacks must not be null");
        this.functionCallbacks = functionCallbacks;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set<String> functions) {
        Assert.notNull(functions, (String)"Function must not be null");
        this.functions = functions;
    }

    @JsonIgnore
    public Float getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Float getPresencePenalty() {
        return null;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    public MistralAiChatOptions copy() {
        return MistralAiChatOptions.fromOptions(this);
    }

    public static MistralAiChatOptions fromOptions(MistralAiChatOptions fromOptions) {
        return MistralAiChatOptions.builder().withModel(fromOptions.getModel()).withMaxTokens(fromOptions.getMaxTokens()).withSafePrompt(fromOptions.getSafePrompt()).withRandomSeed(fromOptions.getRandomSeed()).withTemperature(fromOptions.getTemperature()).withTopP(fromOptions.getTopP()).withResponseFormat(fromOptions.getResponseFormat()).withStop(fromOptions.getStop()).withTools(fromOptions.getTools()).withToolChoice(fromOptions.getToolChoice()).withFunctionCallbacks(fromOptions.getFunctionCallbacks()).withFunctions(fromOptions.getFunctions()).build();
    }

    public static class Builder {
        private final MistralAiChatOptions options = new MistralAiChatOptions();

        public Builder withModel(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder withModel(MistralAiApi.ChatModel chatModel) {
            this.options.setModel(chatModel.getName());
            return this;
        }

        public Builder withMaxTokens(Integer maxTokens) {
            this.options.setMaxTokens(maxTokens);
            return this;
        }

        public Builder withSafePrompt(Boolean safePrompt) {
            this.options.setSafePrompt(safePrompt);
            return this;
        }

        public Builder withRandomSeed(Integer randomSeed) {
            this.options.setRandomSeed(randomSeed);
            return this;
        }

        public Builder withStop(List<String> stop) {
            this.options.setStop(stop);
            return this;
        }

        public Builder withTemperature(Float temperature) {
            this.options.setTemperature(temperature);
            return this;
        }

        public Builder withTopP(Float topP) {
            this.options.setTopP(topP);
            return this;
        }

        public Builder withResponseFormat(MistralAiApi.ChatCompletionRequest.ResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder withTools(List<MistralAiApi.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        public Builder withToolChoice(MistralAiApi.ChatCompletionRequest.ToolChoice toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public Builder withFunctionCallbacks(List<FunctionCallback> functionCallbacks) {
            this.options.functionCallbacks = functionCallbacks;
            return this;
        }

        public Builder withFunctions(Set<String> functionNames) {
            Assert.notNull(functionNames, (String)"Function names must not be null");
            this.options.functions = functionNames;
            return this;
        }

        public Builder withFunction(String functionName) {
            Assert.hasText((String)functionName, (String)"Function name must not be empty");
            this.options.functions.add(functionName);
            return this;
        }

        public MistralAiChatOptions build() {
            return this.options;
        }
    }
}

