/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mistralai;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.AbstractToolCallSupport;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.ChatOptionsBuilder;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.mistralai.MistralAiChatOptions;
import org.springframework.ai.mistralai.api.MistralAiApi;
import org.springframework.ai.mistralai.metadata.MistralAiUsage;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackContext;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MistralAiChatModel
extends AbstractToolCallSupport
implements ChatModel {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    private final MistralAiChatOptions defaultOptions;
    private final MistralAiApi mistralAiApi;
    private final RetryTemplate retryTemplate;
    private final ObservationRegistry observationRegistry;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public MistralAiChatModel(MistralAiApi mistralAiApi) {
        this(mistralAiApi, MistralAiChatOptions.builder().withTemperature(Float.valueOf(0.7f)).withTopP(Float.valueOf(1.0f)).withSafePrompt(false).withModel(MistralAiApi.ChatModel.OPEN_MISTRAL_7B.getValue()).build());
    }

    public MistralAiChatModel(MistralAiApi mistralAiApi, MistralAiChatOptions options) {
        this(mistralAiApi, options, null, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public MistralAiChatModel(MistralAiApi mistralAiApi, MistralAiChatOptions options, FunctionCallbackContext functionCallbackContext, RetryTemplate retryTemplate) {
        this(mistralAiApi, options, functionCallbackContext, List.of(), retryTemplate);
    }

    public MistralAiChatModel(MistralAiApi mistralAiApi, MistralAiChatOptions options, FunctionCallbackContext functionCallbackContext, List<FunctionCallback> toolFunctionCallbacks, RetryTemplate retryTemplate) {
        this(mistralAiApi, options, functionCallbackContext, toolFunctionCallbacks, retryTemplate, ObservationRegistry.NOOP);
    }

    public MistralAiChatModel(MistralAiApi mistralAiApi, MistralAiChatOptions options, FunctionCallbackContext functionCallbackContext, List<FunctionCallback> toolFunctionCallbacks, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        super(functionCallbackContext, (FunctionCallingOptions)options, toolFunctionCallbacks);
        Assert.notNull((Object)mistralAiApi, (String)"mistralAiApi must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry must not be null");
        this.mistralAiApi = mistralAiApi;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    public ChatResponse call(Prompt prompt) {
        MistralAiApi.ChatCompletionRequest request = this.createRequest(prompt, false);
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(MistralAiApi.PROVIDER_NAME).requestOptions(this.buildRequestOptions(request)).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ResponseEntity completionEntity = (ResponseEntity)this.retryTemplate.execute(ctx -> this.mistralAiApi.chatCompletionEntity(request));
            MistralAiApi.ChatCompletion chatCompletion = (MistralAiApi.ChatCompletion)completionEntity.getBody();
            if (chatCompletion == null) {
                this.logger.warn("No chat completion returned for prompt: {}", (Object)prompt);
                return new ChatResponse(List.of());
            }
            List<Generation> generations = chatCompletion.choices().stream().map(choice -> {
                Map<String, Object> metadata = Map.of("id", chatCompletion.id() != null ? chatCompletion.id() : "", "index", choice.index(), "role", choice.message().role() != null ? choice.message().role().name() : "", "finishReason", choice.finishReason() != null ? choice.finishReason().name() : "");
                return this.buildGeneration((MistralAiApi.ChatCompletion.Choice)choice, metadata);
            }).toList();
            ChatResponse chatResponse = new ChatResponse(generations, MistralAiChatModel.from((MistralAiApi.ChatCompletion)completionEntity.getBody()));
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        });
        if (response != null && this.isToolCall(response, Set.of(MistralAiApi.ChatCompletionFinishReason.TOOL_CALLS.name(), MistralAiApi.ChatCompletionFinishReason.STOP.name()))) {
            List toolCallConversation = this.handleToolCalls(prompt, response);
            return this.call(new Prompt(toolCallConversation, prompt.getOptions()));
        }
        return response;
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        return Flux.deferContextual(contextView -> {
            MistralAiApi.ChatCompletionRequest request = this.createRequest(prompt, true);
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(MistralAiApi.PROVIDER_NAME).requestOptions(this.buildRequestOptions(request)).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            Flux completionChunks = (Flux)this.retryTemplate.execute(ctx -> this.mistralAiApi.chatCompletionStream(request));
            ConcurrentHashMap roleMap = new ConcurrentHashMap();
            Flux chatResponse = completionChunks.map(this::toChatCompletion).switchMap(chatCompletion -> Mono.just((Object)chatCompletion).map(chatCompletion2 -> {
                try {
                    String id = chatCompletion2.id();
                    List<Generation> generations = chatCompletion2.choices().stream().map(choice -> {
                        if (choice.message().role() != null) {
                            roleMap.putIfAbsent(id, choice.message().role().name());
                        }
                        Map<String, Object> metadata = Map.of("id", chatCompletion2.id(), "role", roleMap.getOrDefault(id, ""), "index", choice.index(), "finishReason", choice.finishReason() != null ? choice.finishReason().name() : "");
                        return this.buildGeneration((MistralAiApi.ChatCompletion.Choice)choice, metadata);
                    }).toList();
                    if (chatCompletion2.usage() != null) {
                        return new ChatResponse(generations, MistralAiChatModel.from(chatCompletion2));
                    }
                    return new ChatResponse(generations);
                }
                catch (Exception e) {
                    this.logger.error("Error processing chat completion", (Throwable)e);
                    return new ChatResponse(List.of());
                }
            }));
            Flux chatResponseFlux = chatResponse.flatMap(response -> {
                if (this.isToolCall((ChatResponse)response, Set.of(MistralAiApi.ChatCompletionFinishReason.TOOL_CALLS.name()))) {
                    List toolCallConversation = this.handleToolCalls(prompt, (ChatResponse)response);
                    return this.stream(new Prompt(toolCallConversation, prompt.getOptions()));
                }
                return Flux.just((Object)response);
            }).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            return new MessageAggregator().aggregate(chatResponseFlux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
        });
    }

    private Generation buildGeneration(MistralAiApi.ChatCompletion.Choice choice, Map<String, Object> metadata) {
        List toolCalls = choice.message().toolCalls() == null ? List.of() : choice.message().toolCalls().stream().map(toolCall -> new AssistantMessage.ToolCall(toolCall.id(), "function", toolCall.function().name(), toolCall.function().arguments())).toList();
        AssistantMessage assistantMessage = new AssistantMessage(choice.message().content(), metadata, toolCalls);
        String finishReason = choice.finishReason() != null ? choice.finishReason().name() : "";
        ChatGenerationMetadata generationMetadata = ChatGenerationMetadata.from((String)finishReason, null);
        return new Generation(assistantMessage, generationMetadata);
    }

    public static ChatResponseMetadata from(MistralAiApi.ChatCompletion result) {
        Assert.notNull((Object)result, (String)"Mistral AI ChatCompletion must not be null");
        MistralAiUsage usage = MistralAiUsage.from(result.usage());
        return ChatResponseMetadata.builder().withId(result.id()).withModel(result.model()).withUsage((Usage)usage).withKeyValue("created", (Object)result.created()).build();
    }

    private MistralAiApi.ChatCompletion toChatCompletion(MistralAiApi.ChatCompletionChunk chunk) {
        List<MistralAiApi.ChatCompletion.Choice> choices = chunk.choices().stream().map(cc -> new MistralAiApi.ChatCompletion.Choice(cc.index(), cc.delta(), cc.finishReason(), cc.logprobs())).toList();
        return new MistralAiApi.ChatCompletion(chunk.id(), "chat.completion", chunk.created(), chunk.model(), choices, null);
    }

    MistralAiApi.ChatCompletionRequest createRequest(Prompt prompt, boolean stream) {
        HashSet<String> functionsForThisRequest = new HashSet<String>();
        List<MistralAiApi.ChatCompletionMessage> chatCompletionMessages = prompt.getInstructions().stream().map(message -> {
            if (message instanceof UserMessage) {
                UserMessage userMessage = (UserMessage)message;
                return List.of(new MistralAiApi.ChatCompletionMessage(userMessage.getContent(), MistralAiApi.ChatCompletionMessage.Role.USER));
            }
            if (message instanceof SystemMessage) {
                SystemMessage systemMessage = (SystemMessage)message;
                return List.of(new MistralAiApi.ChatCompletionMessage(systemMessage.getContent(), MistralAiApi.ChatCompletionMessage.Role.SYSTEM));
            }
            if (message instanceof AssistantMessage) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                List<MistralAiApi.ChatCompletionMessage.ToolCall> toolCalls = null;
                if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                    toolCalls = assistantMessage.getToolCalls().stream().map(toolCall -> {
                        MistralAiApi.ChatCompletionMessage.ChatCompletionFunction function = new MistralAiApi.ChatCompletionMessage.ChatCompletionFunction(toolCall.name(), toolCall.arguments());
                        return new MistralAiApi.ChatCompletionMessage.ToolCall(toolCall.id(), toolCall.type(), function);
                    }).toList();
                }
                return List.of(new MistralAiApi.ChatCompletionMessage(assistantMessage.getContent(), MistralAiApi.ChatCompletionMessage.Role.ASSISTANT, null, toolCalls, null));
            }
            if (message instanceof ToolResponseMessage) {
                ToolResponseMessage toolResponseMessage = (ToolResponseMessage)message;
                toolResponseMessage.getResponses().forEach(response -> {
                    Assert.isTrue((response.id() != null ? 1 : 0) != 0, (String)"ToolResponseMessage must have an id");
                    Assert.isTrue((response.name() != null ? 1 : 0) != 0, (String)"ToolResponseMessage must have a name");
                });
                return toolResponseMessage.getResponses().stream().map(toolResponse -> new MistralAiApi.ChatCompletionMessage(toolResponse.responseData(), MistralAiApi.ChatCompletionMessage.Role.TOOL, toolResponse.name(), null, toolResponse.id())).toList();
            }
            throw new IllegalStateException("Unexpected message type: " + message);
        }).flatMap(Collection::stream).toList();
        MistralAiApi.ChatCompletionRequest request = new MistralAiApi.ChatCompletionRequest(chatCompletionMessages, stream);
        if (!CollectionUtils.isEmpty(this.defaultOptions.getFunctions())) {
            functionsForThisRequest.addAll(this.defaultOptions.getFunctions());
        }
        request = (MistralAiApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)request, (Object)this.defaultOptions, MistralAiApi.ChatCompletionRequest.class);
        if (prompt.getOptions() != null) {
            MistralAiChatOptions updatedRuntimeOptions = (MistralAiChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, MistralAiChatOptions.class);
            functionsForThisRequest.addAll(this.runtimeFunctionCallbackConfigurations(updatedRuntimeOptions));
            request = (MistralAiApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)request, MistralAiApi.ChatCompletionRequest.class);
        }
        if (!CollectionUtils.isEmpty(functionsForThisRequest)) {
            request = (MistralAiApi.ChatCompletionRequest)ModelOptionsUtils.merge((Object)MistralAiChatOptions.builder().withTools(this.getFunctionTools(functionsForThisRequest)).build(), (Object)request, MistralAiApi.ChatCompletionRequest.class);
        }
        return request;
    }

    private List<MistralAiApi.FunctionTool> getFunctionTools(Set<String> functionNames) {
        return this.resolveFunctionCallbacks(functionNames).stream().map(functionCallback -> {
            MistralAiApi.FunctionTool.Function function = new MistralAiApi.FunctionTool.Function(functionCallback.getDescription(), functionCallback.getName(), functionCallback.getInputTypeSchema());
            return new MistralAiApi.FunctionTool(function);
        }).toList();
    }

    private ChatOptions buildRequestOptions(MistralAiApi.ChatCompletionRequest request) {
        return ChatOptionsBuilder.builder().withModel(request.model()).withMaxTokens(request.maxTokens()).withStopSequences(request.stop()).withTemperature(request.temperature()).withTopP(request.topP()).build();
    }

    public ChatOptions getDefaultOptions() {
        return MistralAiChatOptions.fromOptions(this.defaultOptions);
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }
}

