/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.minimax.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.ai.minimax.api.MiniMaxStreamFunctionCallingHelper;
import org.springframework.ai.model.ChatModelDescription;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MiniMaxApi {
    public static final String DEFAULT_CHAT_MODEL = ChatModel.ABAB_6_5_G_Chat.getValue();
    public static final String DEFAULT_EMBEDDING_MODEL = EmbeddingModel.Embo_01.getValue();
    private static final Predicate<String> SSE_DONE_PREDICATE = "[DONE]"::equals;
    private final RestClient restClient;
    private final WebClient webClient;
    private final MiniMaxStreamFunctionCallingHelper chunkMerger = new MiniMaxStreamFunctionCallingHelper();

    public MiniMaxApi(String miniMaxToken) {
        this("https://api.minimax.chat", miniMaxToken);
    }

    public MiniMaxApi(String baseUrl, String miniMaxToken) {
        this(baseUrl, miniMaxToken, RestClient.builder());
    }

    public MiniMaxApi(String baseUrl, String miniMaxToken, RestClient.Builder restClientBuilder) {
        this(baseUrl, miniMaxToken, restClientBuilder, RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public MiniMaxApi(String baseUrl, String miniMaxToken, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        Consumer<HttpHeaders> authHeaders = headers -> {
            headers.setBearerAuth(miniMaxToken);
            headers.setContentType(MediaType.APPLICATION_JSON);
        };
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(authHeaders).defaultStatusHandler(responseErrorHandler).build();
        this.webClient = WebClient.builder().baseUrl(baseUrl).defaultHeaders(authHeaders).build();
    }

    public static String getTextContent(List<ChatCompletionMessage.MediaContent> content) {
        return content.stream().filter(c -> "text".equals(c.type())).map(ChatCompletionMessage.MediaContent::text).reduce("", (a, b) -> a + b);
    }

    public ResponseEntity<ChatCompletion> chatCompletionEntity(ChatCompletionRequest chatRequest) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((chatRequest.stream() == false ? 1 : 0) != 0, (String)"Request must set the stream property to false.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/v1/text/chatcompletion_v2", new Object[0])).body((Object)chatRequest).retrieve().toEntity(ChatCompletion.class);
    }

    public Flux<ChatCompletionChunk> chatCompletionStream(ChatCompletionRequest chatRequest) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((boolean)chatRequest.stream(), (String)"Request must set the stream property to true.");
        AtomicBoolean isInsideTool = new AtomicBoolean(false);
        return ((WebClient.RequestBodySpec)this.webClient.post().uri("/v1/text/chatcompletion_v2", new Object[0])).body((Publisher)Mono.just((Object)chatRequest), ChatCompletionRequest.class).retrieve().bodyToFlux(String.class).takeUntil(SSE_DONE_PREDICATE).filter(SSE_DONE_PREDICATE.negate()).map(content -> (ChatCompletionChunk)ModelOptionsUtils.jsonToObject((String)content, ChatCompletionChunk.class)).map(chunk -> {
            if (this.chunkMerger.isStreamingToolFunctionCall((ChatCompletionChunk)chunk)) {
                isInsideTool.set(true);
            }
            return chunk;
        }).windowUntil(chunk -> {
            if (isInsideTool.get() && this.chunkMerger.isStreamingToolFunctionCallFinish((ChatCompletionChunk)chunk)) {
                isInsideTool.set(false);
                return true;
            }
            return !isInsideTool.get();
        }).concatMapIterable(window -> {
            Mono monoChunk = window.reduce((Object)new ChatCompletionChunk(null, null, null, null, null, null), (previous, current) -> this.chunkMerger.merge((ChatCompletionChunk)previous, (ChatCompletionChunk)current));
            return List.of(monoChunk);
        }).flatMap(mono -> mono);
    }

    public ResponseEntity<EmbeddingList> embeddings(EmbeddingRequest embeddingRequest) {
        Assert.notNull((Object)embeddingRequest, (String)"The request body can not be null.");
        Assert.notNull(embeddingRequest.texts(), (String)"The input can not be null.");
        Assert.isTrue((!CollectionUtils.isEmpty(embeddingRequest.texts()) ? 1 : 0) != 0, (String)"The input list can not be empty.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/v1/embeddings", new Object[0])).body((Object)embeddingRequest).retrieve().toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<EmbeddingList>(){});
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionRequest(@JsonProperty(value="messages") List<ChatCompletionMessage> messages, @JsonProperty(value="model") String model, @JsonProperty(value="frequency_penalty") Double frequencyPenalty, @JsonProperty(value="max_tokens") Integer maxTokens, @JsonProperty(value="n") Integer n, @JsonProperty(value="presence_penalty") Double presencePenalty, @JsonProperty(value="response_format") ResponseFormat responseFormat, @JsonProperty(value="seed") Integer seed, @JsonProperty(value="stop") List<String> stop, @JsonProperty(value="stream") Boolean stream, @JsonProperty(value="temperature") Double temperature, @JsonProperty(value="top_p") Double topP, @JsonProperty(value="mask_sensitive_info") Boolean maskSensitiveInfo, @JsonProperty(value="tools") List<FunctionTool> tools, @JsonProperty(value="tool_choice") Object toolChoice) {
        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, Double temperature) {
            this(messages, model, null, null, null, null, null, null, null, false, temperature, null, null, null, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, Double temperature, boolean stream) {
            this(messages, model, null, null, null, null, null, null, null, stream, temperature, null, null, null, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, List<FunctionTool> tools, Object toolChoice) {
            this(messages, model, null, null, null, null, null, null, null, false, 0.8, null, null, tools, toolChoice);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, Boolean stream) {
            this(messages, null, null, null, null, null, null, null, null, stream, null, null, null, null, null);
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ResponseFormat(@JsonProperty(value="type") String type) {
        }

        public static class ToolChoiceBuilder {
            public static final String AUTO = "auto";
            public static final String NONE = "none";

            public static Object function(String functionName) {
                return Map.of("type", "function", "function", Map.of("name", functionName));
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ChatCompletion(@JsonProperty(value="id") String id, @JsonProperty(value="choices") List<Choice> choices, @JsonProperty(value="created") Long created, @JsonProperty(value="model") String model, @JsonProperty(value="system_fingerprint") String systemFingerprint, @JsonProperty(value="object") String object, @JsonProperty(value="base_resp") BaseResponse baseResponse, @JsonProperty(value="usage") Usage usage) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record BaseResponse(@JsonProperty(value="status_code") Long statusCode, @JsonProperty(value="status_msg") String message) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record Choice(@JsonProperty(value="finish_reason") ChatCompletionFinishReason finishReason, @JsonProperty(value="index") Integer index, @JsonProperty(value="message") ChatCompletionMessage message, @JsonProperty(value="messages") List<ChatCompletionMessage> messages, @JsonProperty(value="logprobs") LogProbs logprobs) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingRequest(@JsonProperty(value="texts") List<String> texts, @JsonProperty(value="model") String model, @JsonProperty(value="type") String type) {
        public EmbeddingRequest(String text) {
            this(List.of(text), DEFAULT_EMBEDDING_MODEL, EmbeddingType.DB.value);
        }

        public EmbeddingRequest(String text, String model) {
            this(List.of(text), model, "db");
        }

        public EmbeddingRequest(String text, EmbeddingType type) {
            this(List.of(text), DEFAULT_EMBEDDING_MODEL, type.value);
        }

        public EmbeddingRequest(List<String> texts) {
            this(texts, DEFAULT_EMBEDDING_MODEL, EmbeddingType.DB.value);
        }

        public EmbeddingRequest(List<String> texts, String model) {
            this(texts, model, "db");
        }

        public EmbeddingRequest(List<String> texts, EmbeddingType type) {
            this(texts, DEFAULT_EMBEDDING_MODEL, type.value);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ChatCompletionChunk(@JsonProperty(value="id") String id, @JsonProperty(value="choices") List<ChunkChoice> choices, @JsonProperty(value="created") Long created, @JsonProperty(value="model") String model, @JsonProperty(value="system_fingerprint") String systemFingerprint, @JsonProperty(value="object") String object) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record ChunkChoice(@JsonProperty(value="finish_reason") ChatCompletionFinishReason finishReason, @JsonProperty(value="index") Integer index, @JsonProperty(value="delta") ChatCompletionMessage delta, @JsonProperty(value="logprobs") LogProbs logprobs) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record ChatCompletionMessage(@JsonProperty(value="content") Object rawContent, @JsonProperty(value="role") Role role, @JsonProperty(value="name") String name, @JsonProperty(value="tool_call_id") String toolCallId, @JsonProperty(value="tool_calls") List<ToolCall> toolCalls) {
        public ChatCompletionMessage(Object content, Role role) {
            this(content, role, null, null, null);
        }

        public String content() {
            if (this.rawContent == null) {
                return null;
            }
            Object object = this.rawContent;
            if (object instanceof String) {
                String text = (String)object;
                return text;
            }
            throw new IllegalStateException("The content is not a string!");
        }

        public static enum Role {
            SYSTEM,
            USER,
            ASSISTANT,
            TOOL;

        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record ChatCompletionFunction(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") String arguments) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record ToolCall(@JsonProperty(value="id") String id, @JsonProperty(value="type") String type, @JsonProperty(value="function") ChatCompletionFunction function) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record MediaContent(@JsonProperty(value="type") String type, @JsonProperty(value="text") String text, @JsonProperty(value="image_url") ImageUrl imageUrl) {
            public MediaContent(String text) {
                this("text", text, null);
            }

            public MediaContent(ImageUrl imageUrl) {
                this("image_url", null, imageUrl);
            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            @JsonIgnoreProperties(ignoreUnknown=true)
            public record ImageUrl(@JsonProperty(value="url") String url, @JsonProperty(value="detail") String detail) {
                public ImageUrl(String url) {
                    this(url, null);
                }
            }
        }
    }

    public static enum ChatModel implements ChatModelDescription
    {
        MINIMAX_TEXT_01("minimax-text-01"),
        ABAB_7_Chat_Preview("abab7-chat-preview"),
        ABAB_6_5_Chat("abab6.5-chat"),
        ABAB_6_5_S_Chat("abab6.5s-chat"),
        ABAB_6_5_T_Chat("abab6.5t-chat"),
        ABAB_6_5_G_Chat("abab6.5g-chat"),
        ABAB_5_5_Chat("abab5.5-chat"),
        ABAB_5_5_S_Chat("abab5.5s-chat");

        public final String value;

        private ChatModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.value;
        }
    }

    public static enum EmbeddingModel {
        Embo_01("embo-01");

        public final String value;

        private EmbeddingModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record EmbeddingList(@JsonProperty(value="vectors") List<float[]> vectors, @JsonProperty(value="model") String model, @JsonProperty(value="total_tokens") Integer totalTokens) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record Usage(@JsonProperty(value="completion_tokens") Integer completionTokens, @JsonProperty(value="prompt_tokens") Integer promptTokens, @JsonProperty(value="total_tokens") Integer totalTokens) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record LogProbs(@JsonProperty(value="content") List<Content> content) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record Content(@JsonProperty(value="token") String token, @JsonProperty(value="logprob") Float logprob, @JsonProperty(value="bytes") List<Integer> probBytes, @JsonProperty(value="top_logprobs") List<TopLogProbs> topLogprobs) {

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            @JsonIgnoreProperties(ignoreUnknown=true)
            public record TopLogProbs(@JsonProperty(value="token") String token, @JsonProperty(value="logprob") Float logprob, @JsonProperty(value="bytes") List<Integer> probBytes) {
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class FunctionTool {
        private Type type = Type.FUNCTION;
        private Function function;

        public FunctionTool() {
        }

        public FunctionTool(@JsonProperty(value="type") Type type, @JsonProperty(value="function") Function function) {
            this.type = type;
            this.function = function;
        }

        public FunctionTool(Function function) {
            this(Type.FUNCTION, function);
        }

        @JsonProperty(value="type")
        public Type getType() {
            return this.type;
        }

        @JsonProperty(value="function")
        public Function getFunction() {
            return this.function;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void setFunction(Function function) {
            this.function = function;
        }

        public static FunctionTool webSearchFunctionTool() {
            return new FunctionTool(Type.WEB_SEARCH, null);
        }

        public static enum Type {
            FUNCTION,
            WEB_SEARCH;

        }

        public static class Function {
            @JsonProperty(value="description")
            private String description;
            @JsonProperty(value="name")
            private String name;
            @JsonProperty(value="parameters")
            private Map<String, Object> parameters;
            @JsonIgnore
            private String jsonSchema;

            private Function() {
            }

            public Function(String description, String name, Map<String, Object> parameters) {
                this.description = description;
                this.name = name;
                this.parameters = parameters;
            }

            public Function(String description, String name, String jsonSchema) {
                this(description, name, ModelOptionsUtils.jsonToMap((String)jsonSchema));
            }

            @JsonProperty(value="description")
            public String getDescription() {
                return this.description;
            }

            @JsonProperty(value="name")
            public String getName() {
                return this.name;
            }

            @JsonProperty(value="parameters")
            public Map<String, Object> getParameters() {
                return this.parameters;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setParameters(Map<String, Object> parameters) {
                this.parameters = parameters;
            }

            public String getJsonSchema() {
                return this.jsonSchema;
            }

            public void setJsonSchema(String jsonSchema) {
                this.jsonSchema = jsonSchema;
                if (jsonSchema != null) {
                    this.parameters = ModelOptionsUtils.jsonToMap((String)jsonSchema);
                }
            }
        }
    }

    public static enum EmbeddingType {
        DB("db"),
        Query("query");

        @JsonValue
        public final String value;

        private EmbeddingType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ChatCompletionFinishReason {
        STOP,
        LENGTH,
        CONTENT_FILTER,
        TOOL_CALLS,
        TOOL_CALL;

    }
}

