/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.minimax;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.ai.minimax.api.MiniMaxApi;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MiniMaxChatOptions
implements ToolCallingChatOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="n")
    private Integer n;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="response_format")
    private MiniMaxApi.ChatCompletionRequest.ResponseFormat responseFormat;
    @JsonProperty(value="seed")
    private Integer seed;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="mask_sensitive_info")
    private Boolean maskSensitiveInfo;
    @JsonProperty(value="tools")
    private List<MiniMaxApi.FunctionTool> tools;
    @JsonProperty(value="tool_choice")
    private String toolChoice;
    @JsonIgnore
    private List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
    @JsonIgnore
    private Set<String> toolNames = new HashSet<String>();
    @JsonIgnore
    private Map<String, Object> toolContext = new HashMap<String, Object>();
    @JsonIgnore
    private Boolean internalToolExecutionEnabled;

    public static Builder builder() {
        return new Builder();
    }

    public static MiniMaxChatOptions fromOptions(MiniMaxChatOptions fromOptions) {
        return MiniMaxChatOptions.builder().model(fromOptions.getModel()).frequencyPenalty(fromOptions.getFrequencyPenalty()).maxTokens(fromOptions.getMaxTokens()).N(fromOptions.getN()).presencePenalty(fromOptions.getPresencePenalty()).responseFormat(fromOptions.getResponseFormat()).seed(fromOptions.getSeed()).stop(fromOptions.getStop()).temperature(fromOptions.getTemperature()).topP(fromOptions.getTopP()).maskSensitiveInfo(fromOptions.getMaskSensitiveInfo()).tools(fromOptions.getTools()).toolChoice(fromOptions.getToolChoice()).toolCallbacks(fromOptions.getToolCallbacks()).toolNames(fromOptions.getToolNames()).internalToolExecutionEnabled(fromOptions.getInternalToolExecutionEnabled()).toolContext(fromOptions.getToolContext()).build();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public MiniMaxApi.ChatCompletionRequest.ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(MiniMaxApi.ChatCompletionRequest.ResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public void setSeed(Integer seed) {
        this.seed = seed;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return this.getStop();
    }

    @JsonIgnore
    public void setStopSequences(List<String> stopSequences) {
        this.setStop(stopSequences);
    }

    public List<String> getStop() {
        return this.stop;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Boolean getMaskSensitiveInfo() {
        return this.maskSensitiveInfo;
    }

    public void setMaskSensitiveInfo(Boolean maskSensitiveInfo) {
        this.maskSensitiveInfo = maskSensitiveInfo;
    }

    public List<MiniMaxApi.FunctionTool> getTools() {
        return this.tools;
    }

    public void setTools(List<MiniMaxApi.FunctionTool> tools) {
        this.tools = tools;
    }

    public String getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(String toolChoice) {
        this.toolChoice = toolChoice;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    @JsonIgnore
    public List<ToolCallback> getToolCallbacks() {
        return this.toolCallbacks;
    }

    @JsonIgnore
    public void setToolCallbacks(List<ToolCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        this.toolCallbacks = toolCallbacks;
    }

    @JsonIgnore
    public Set<String> getToolNames() {
        return this.toolNames;
    }

    @JsonIgnore
    public void setToolNames(Set<String> toolNames) {
        Assert.notNull(toolNames, (String)"toolNames cannot be null");
        Assert.noNullElements(toolNames, (String)"toolNames cannot contain null elements");
        toolNames.forEach(tool -> Assert.hasText((String)tool, (String)"toolNames cannot contain empty elements"));
        this.toolNames = toolNames;
    }

    @Nullable
    @JsonIgnore
    public Boolean getInternalToolExecutionEnabled() {
        return this.internalToolExecutionEnabled;
    }

    @JsonIgnore
    public void setInternalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
        this.internalToolExecutionEnabled = internalToolExecutionEnabled;
    }

    public Map<String, Object> getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(Map<String, Object> toolContext) {
        this.toolContext = toolContext;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.frequencyPenalty == null ? 0 : this.frequencyPenalty.hashCode());
        result = 31 * result + (this.maxTokens == null ? 0 : this.maxTokens.hashCode());
        result = 31 * result + (this.n == null ? 0 : this.n.hashCode());
        result = 31 * result + (this.presencePenalty == null ? 0 : this.presencePenalty.hashCode());
        result = 31 * result + (this.responseFormat == null ? 0 : this.responseFormat.hashCode());
        result = 31 * result + (this.seed == null ? 0 : this.seed.hashCode());
        result = 31 * result + (this.stop == null ? 0 : this.stop.hashCode());
        result = 31 * result + (this.temperature == null ? 0 : this.temperature.hashCode());
        result = 31 * result + (this.topP == null ? 0 : this.topP.hashCode());
        result = 31 * result + (this.maskSensitiveInfo == null ? 0 : this.maskSensitiveInfo.hashCode());
        result = 31 * result + (this.tools == null ? 0 : this.tools.hashCode());
        result = 31 * result + (this.toolChoice == null ? 0 : this.toolChoice.hashCode());
        result = 31 * result + (this.toolCallbacks == null ? 0 : this.toolCallbacks.hashCode());
        result = 31 * result + (this.toolNames == null ? 0 : this.toolNames.hashCode());
        result = 31 * result + (this.internalToolExecutionEnabled == null ? 0 : this.internalToolExecutionEnabled.hashCode());
        result = 31 * result + (this.toolContext == null ? 0 : this.toolContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MiniMaxChatOptions other = (MiniMaxChatOptions)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.frequencyPenalty == null ? other.frequencyPenalty != null : !this.frequencyPenalty.equals(other.frequencyPenalty)) {
            return false;
        }
        if (this.maxTokens == null ? other.maxTokens != null : !this.maxTokens.equals(other.maxTokens)) {
            return false;
        }
        if (this.n == null ? other.n != null : !this.n.equals(other.n)) {
            return false;
        }
        if (this.presencePenalty == null ? other.presencePenalty != null : !this.presencePenalty.equals(other.presencePenalty)) {
            return false;
        }
        if (this.responseFormat == null ? other.responseFormat != null : !this.responseFormat.equals(other.responseFormat)) {
            return false;
        }
        if (this.seed == null ? other.seed != null : !this.seed.equals(other.seed)) {
            return false;
        }
        if (this.stop == null ? other.stop != null : !this.stop.equals(other.stop)) {
            return false;
        }
        if (this.temperature == null ? other.temperature != null : !this.temperature.equals(other.temperature)) {
            return false;
        }
        if (this.topP == null ? other.topP != null : !this.topP.equals(other.topP)) {
            return false;
        }
        if (this.maskSensitiveInfo == null ? other.maskSensitiveInfo != null : !this.maskSensitiveInfo.equals(other.maskSensitiveInfo)) {
            return false;
        }
        if (this.tools == null ? other.tools != null : !this.tools.equals(other.tools)) {
            return false;
        }
        if (this.toolChoice == null ? other.toolChoice != null : !this.toolChoice.equals(other.toolChoice)) {
            return false;
        }
        if (this.internalToolExecutionEnabled == null ? other.internalToolExecutionEnabled != null : !this.internalToolExecutionEnabled.equals(other.internalToolExecutionEnabled)) {
            return false;
        }
        if (this.toolNames == null ? other.toolNames != null : !this.toolNames.equals(other.toolNames)) {
            return false;
        }
        if (this.toolCallbacks == null ? other.toolCallbacks != null : !this.toolCallbacks.equals(other.toolCallbacks)) {
            return false;
        }
        return !(this.toolContext == null ? other.toolContext != null : !this.toolContext.equals(other.toolContext));
    }

    public MiniMaxChatOptions copy() {
        return MiniMaxChatOptions.fromOptions(this);
    }

    public static class Builder {
        protected MiniMaxChatOptions options;

        public Builder() {
            this.options = new MiniMaxChatOptions();
        }

        public Builder(MiniMaxChatOptions options) {
            this.options = options;
        }

        public Builder model(String model) {
            this.options.model = model;
            return this;
        }

        public Builder frequencyPenalty(Double frequencyPenalty) {
            this.options.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public Builder maxTokens(Integer maxTokens) {
            this.options.maxTokens = maxTokens;
            return this;
        }

        public Builder N(Integer n) {
            this.options.n = n;
            return this;
        }

        public Builder presencePenalty(Double presencePenalty) {
            this.options.presencePenalty = presencePenalty;
            return this;
        }

        public Builder responseFormat(MiniMaxApi.ChatCompletionRequest.ResponseFormat responseFormat) {
            this.options.responseFormat = responseFormat;
            return this;
        }

        public Builder seed(Integer seed) {
            this.options.seed = seed;
            return this;
        }

        public Builder stop(List<String> stop) {
            this.options.stop = stop;
            return this;
        }

        public Builder temperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder topP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder maskSensitiveInfo(Boolean maskSensitiveInfo) {
            this.options.maskSensitiveInfo = maskSensitiveInfo;
            return this;
        }

        public Builder tools(List<MiniMaxApi.FunctionTool> tools) {
            this.options.tools = tools;
            return this;
        }

        public Builder toolChoice(String toolChoice) {
            this.options.toolChoice = toolChoice;
            return this;
        }

        public Builder toolCallbacks(List<ToolCallback> toolCallbacks) {
            this.options.setToolCallbacks(toolCallbacks);
            return this;
        }

        public Builder toolCallbacks(ToolCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            this.options.toolCallbacks.addAll(Arrays.asList(toolCallbacks));
            return this;
        }

        public Builder toolNames(Set<String> toolNames) {
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            this.options.setToolNames(toolNames);
            return this;
        }

        public Builder toolNames(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            this.options.toolNames.addAll(Set.of(toolNames));
            return this;
        }

        public Builder internalToolExecutionEnabled(@Nullable Boolean internalToolExecutionEnabled) {
            this.options.setInternalToolExecutionEnabled(internalToolExecutionEnabled);
            return this;
        }

        public Builder toolContext(Map<String, Object> toolContext) {
            if (this.options.toolContext == null) {
                this.options.toolContext = toolContext;
            } else {
                this.options.toolContext.putAll(toolContext);
            }
            return this;
        }

        public MiniMaxChatOptions build() {
            return this.options;
        }
    }
}

