/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp;

import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.ai.mcp.AsyncMcpToolCallback;
import org.springframework.ai.mcp.DefaultMcpToolNamePrefixGenerator;
import org.springframework.ai.mcp.McpConnectionInfo;
import org.springframework.ai.mcp.McpToolFilter;
import org.springframework.ai.mcp.McpToolNamePrefixGenerator;
import org.springframework.ai.mcp.McpToolsChangedEvent;
import org.springframework.ai.mcp.ToolContextToMcpMetaConverter;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.ai.tool.support.ToolUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

public class AsyncMcpToolCallbackProvider
implements ToolCallbackProvider,
ApplicationListener<McpToolsChangedEvent> {
    private final McpToolFilter toolFilter;
    private final List<McpAsyncClient> mcpClients;
    private final McpToolNamePrefixGenerator toolNamePrefixGenerator;
    private final ToolContextToMcpMetaConverter toolContextToMcpMetaConverter;
    private volatile boolean invalidateCache = true;
    private volatile List<ToolCallback> cachedToolCallbacks = List.of();
    private final Lock lock = new ReentrantLock();

    @Deprecated
    public AsyncMcpToolCallbackProvider(McpToolFilter toolFilter, List<McpAsyncClient> mcpClients) {
        this(toolFilter, McpToolNamePrefixGenerator.noPrefix(), ToolContextToMcpMetaConverter.defaultConverter(), mcpClients);
    }

    private AsyncMcpToolCallbackProvider(McpToolFilter toolFilter, McpToolNamePrefixGenerator toolNamePrefixGenerator, ToolContextToMcpMetaConverter toolContextToMcpMetaConverter, List<McpAsyncClient> mcpClients) {
        Assert.notNull(mcpClients, (String)"MCP clients must not be null");
        Assert.notNull((Object)toolFilter, (String)"Tool filter must not be null");
        Assert.notNull((Object)toolNamePrefixGenerator, (String)"Tool name prefix generator must not be null");
        Assert.notNull((Object)toolContextToMcpMetaConverter, (String)"Tool context to MCP meta converter must not be null");
        this.toolFilter = toolFilter;
        this.mcpClients = mcpClients;
        this.toolNamePrefixGenerator = toolNamePrefixGenerator;
        this.toolContextToMcpMetaConverter = toolContextToMcpMetaConverter;
    }

    @Deprecated
    public AsyncMcpToolCallbackProvider(List<McpAsyncClient> mcpClients) {
        this((mcpClient, tool) -> true, mcpClients);
    }

    @Deprecated
    public AsyncMcpToolCallbackProvider(McpToolFilter toolFilter, McpAsyncClient ... mcpClients) {
        this(toolFilter, List.of(mcpClients));
    }

    @Deprecated
    public AsyncMcpToolCallbackProvider(McpAsyncClient ... mcpClients) {
        this(List.of(mcpClients));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ToolCallback[] getToolCallbacks() {
        if (this.invalidateCache) {
            this.lock.lock();
            try {
                if (this.invalidateCache) {
                    ArrayList<ToolCallback> toolCallbackList = new ArrayList<ToolCallback>();
                    for (McpAsyncClient mcpClient : this.mcpClients) {
                        ToolCallback[] toolCallbacks = (ToolCallback[])mcpClient.listTools().map(response -> (ToolCallback[])response.tools().stream().filter(tool -> this.toolFilter.test(AsyncMcpToolCallbackProvider.connectionInfo(mcpClient), tool)).map(tool -> AsyncMcpToolCallback.builder().mcpClient(mcpClient).tool((McpSchema.Tool)tool).prefixedToolName(this.toolNamePrefixGenerator.prefixedToolName(AsyncMcpToolCallbackProvider.connectionInfo(mcpClient), (McpSchema.Tool)tool)).toolContextToMcpMetaConverter(this.toolContextToMcpMetaConverter).build()).toArray(ToolCallback[]::new)).block();
                        toolCallbackList.addAll(List.of(toolCallbacks));
                    }
                    this.cachedToolCallbacks = toolCallbackList;
                    this.validateToolCallbacks(this.cachedToolCallbacks);
                    this.invalidateCache = false;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.cachedToolCallbacks.toArray(new ToolCallback[0]);
    }

    public void invalidateCache() {
        this.invalidateCache = true;
    }

    public void onApplicationEvent(McpToolsChangedEvent event) {
        this.invalidateCache();
    }

    private static McpConnectionInfo connectionInfo(McpAsyncClient mcpClient) {
        return McpConnectionInfo.builder().clientCapabilities(mcpClient.getClientCapabilities()).clientInfo(mcpClient.getClientInfo()).initializeResult(mcpClient.getCurrentInitializationResult()).build();
    }

    private void validateToolCallbacks(List<ToolCallback> toolCallbacks) {
        List duplicateToolNames = ToolUtils.getDuplicateToolNames(toolCallbacks);
        if (!duplicateToolNames.isEmpty()) {
            throw new IllegalStateException("Multiple tools with the same name (%s)".formatted(String.join((CharSequence)", ", duplicateToolNames)));
        }
    }

    public static Flux<ToolCallback> asyncToolCallbacks(List<McpAsyncClient> mcpClients) {
        if (CollectionUtils.isEmpty(mcpClients)) {
            return Flux.empty();
        }
        return Flux.fromArray((Object[])new AsyncMcpToolCallbackProvider(mcpClients).getToolCallbacks());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private McpToolFilter toolFilter = (mcpClient, tool) -> true;
        private List<McpAsyncClient> mcpClients = List.of();
        private McpToolNamePrefixGenerator toolNamePrefixGenerator = new DefaultMcpToolNamePrefixGenerator();
        private ToolContextToMcpMetaConverter toolContextToMcpMetaConverter = ToolContextToMcpMetaConverter.defaultConverter();

        private Builder() {
        }

        public Builder toolFilter(McpToolFilter toolFilter) {
            Assert.notNull((Object)toolFilter, (String)"Tool filter must not be null");
            this.toolFilter = toolFilter;
            return this;
        }

        public Builder mcpClients(List<McpAsyncClient> mcpClients) {
            Assert.notNull(mcpClients, (String)"MCP clients list must not be null");
            this.mcpClients = mcpClients;
            return this;
        }

        public Builder mcpClients(McpAsyncClient ... mcpClients) {
            Assert.notNull((Object)mcpClients, (String)"MCP clients must not be null");
            this.mcpClients = List.of(mcpClients);
            return this;
        }

        public Builder toolNamePrefixGenerator(McpToolNamePrefixGenerator toolNamePrefixGenerator) {
            Assert.notNull((Object)toolNamePrefixGenerator, (String)"Tool name prefix generator must not be null");
            this.toolNamePrefixGenerator = toolNamePrefixGenerator;
            return this;
        }

        public Builder toolContextToMcpMetaConverter(ToolContextToMcpMetaConverter toolContextToMcpMetaConverter) {
            Assert.notNull((Object)toolContextToMcpMetaConverter, (String)"Tool context to MCP meta converter must not be null");
            this.toolContextToMcpMetaConverter = toolContextToMcpMetaConverter;
            return this;
        }

        public AsyncMcpToolCallbackProvider build() {
            return new AsyncMcpToolCallbackProvider(this.toolFilter, this.toolNamePrefixGenerator, this.toolContextToMcpMetaConverter, this.mcpClients);
        }
    }
}

