/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.google.genai.metadata;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.genai.types.TrafficType;

public enum GoogleGenAiTrafficType {
    ON_DEMAND("ON_DEMAND"),
    PROVISIONED_THROUGHPUT("PROVISIONED_THROUGHPUT"),
    UNKNOWN("UNKNOWN");

    private final String value;

    private GoogleGenAiTrafficType(String value) {
        this.value = value;
    }

    public static GoogleGenAiTrafficType from(TrafficType trafficType) {
        String typeStr;
        if (trafficType == null) {
            return UNKNOWN;
        }
        switch (typeStr = trafficType.toString().toUpperCase()) {
            case "ON_DEMAND": {
                return ON_DEMAND;
            }
            case "PROVISIONED_THROUGHPUT": {
                return PROVISIONED_THROUGHPUT;
            }
            case "TRAFFIC_TYPE_UNSPECIFIED": {
                return UNKNOWN;
            }
        }
        for (GoogleGenAiTrafficType type : GoogleGenAiTrafficType.values()) {
            if (!type.value.equals(typeStr)) continue;
            return type;
        }
        return UNKNOWN;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

