/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.google.genai.text;

import com.google.genai.Client;
import com.google.genai.types.ContentEmbedding;
import com.google.genai.types.ContentEmbeddingStatistics;
import com.google.genai.types.EmbedContentConfig;
import com.google.genai.types.EmbedContentResponse;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.embedding.observation.DefaultEmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationContext;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationDocumentation;
import org.springframework.ai.google.genai.GoogleGenAiEmbeddingConnectionDetails;
import org.springframework.ai.google.genai.text.GoogleGenAiTextEmbeddingModelName;
import org.springframework.ai.google.genai.text.GoogleGenAiTextEmbeddingOptions;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.observation.conventions.AiProvider;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.core.retry.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GoogleGenAiTextEmbeddingModel
extends AbstractEmbeddingModel {
    private static final EmbeddingModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultEmbeddingModelObservationConvention();
    private static final Map<String, Integer> KNOWN_EMBEDDING_DIMENSIONS = Stream.of(GoogleGenAiTextEmbeddingModelName.values()).collect(Collectors.toMap(GoogleGenAiTextEmbeddingModelName::getName, GoogleGenAiTextEmbeddingModelName::getDimensions));
    public final GoogleGenAiTextEmbeddingOptions defaultOptions;
    private final GoogleGenAiEmbeddingConnectionDetails connectionDetails;
    private final RetryTemplate retryTemplate;
    private final ObservationRegistry observationRegistry;
    private EmbeddingModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;
    private final Client genAiClient;

    public GoogleGenAiTextEmbeddingModel(GoogleGenAiEmbeddingConnectionDetails connectionDetails, GoogleGenAiTextEmbeddingOptions defaultEmbeddingOptions) {
        this(connectionDetails, defaultEmbeddingOptions, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public GoogleGenAiTextEmbeddingModel(GoogleGenAiEmbeddingConnectionDetails connectionDetails, GoogleGenAiTextEmbeddingOptions defaultEmbeddingOptions, RetryTemplate retryTemplate) {
        this(connectionDetails, defaultEmbeddingOptions, retryTemplate, ObservationRegistry.NOOP);
    }

    public GoogleGenAiTextEmbeddingModel(GoogleGenAiEmbeddingConnectionDetails connectionDetails, GoogleGenAiTextEmbeddingOptions defaultEmbeddingOptions, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)connectionDetails, (String)"GoogleGenAiEmbeddingConnectionDetails must not be null");
        Assert.notNull((Object)defaultEmbeddingOptions, (String)"GoogleGenAiTextEmbeddingOptions must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry must not be null");
        this.defaultOptions = defaultEmbeddingOptions.initializeDefaults();
        this.connectionDetails = connectionDetails;
        this.genAiClient = connectionDetails.getGenAiClient();
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    public float[] embed(Document document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        return this.embed(document.getFormattedContent());
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        EmbeddingRequest embeddingRequest = this.buildEmbeddingRequest(request);
        EmbeddingModelObservationContext observationContext = EmbeddingModelObservationContext.builder().embeddingRequest(embeddingRequest).provider(AiProvider.GOOGLE_GENAI_AI.value()).build();
        return (EmbeddingResponse)EmbeddingModelObservationDocumentation.EMBEDDING_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            GoogleGenAiTextEmbeddingOptions options = (GoogleGenAiTextEmbeddingOptions)embeddingRequest.getOptions();
            String modelName = this.connectionDetails.getModelEndpointName(options.getModel());
            EmbedContentConfig.Builder configBuilder = EmbedContentConfig.builder();
            if (options.getDimensions() != null) {
                configBuilder.outputDimensionality(options.getDimensions());
            }
            EmbedContentConfig config = configBuilder.build();
            List texts = embeddingRequest.getInstructions();
            if (texts == null || texts.isEmpty()) {
                throw new IllegalArgumentException("No embedding input is provided - instructions list is empty");
            }
            List<String> validTexts = texts.stream().filter(StringUtils::hasText).toList();
            if (validTexts.isEmpty()) {
                throw new IllegalArgumentException("No embedding input is provided - all texts are null or empty");
            }
            EmbedContentResponse embeddingResponse = (EmbedContentResponse)RetryUtils.execute((RetryTemplate)this.retryTemplate, () -> this.genAiClient.models.embedContent(modelName, validTexts, config));
            int totalTokenCount = 0;
            ArrayList<Embedding> embeddingList = new ArrayList<Embedding>();
            int originalIndex = 0;
            int validIndex = 0;
            if (embeddingResponse.embeddings().isPresent()) {
                for (String originalText : texts) {
                    if (StringUtils.hasText((String)originalText) && validIndex < ((List)embeddingResponse.embeddings().get()).size()) {
                        ContentEmbeddingStatistics stats;
                        ContentEmbedding contentEmbedding = (ContentEmbedding)((List)embeddingResponse.embeddings().get()).get(validIndex);
                        if (contentEmbedding.values().isPresent()) {
                            List floatList = (List)contentEmbedding.values().get();
                            float[] vectorValues = new float[floatList.size()];
                            for (int i = 0; i < floatList.size(); ++i) {
                                vectorValues[i] = ((Float)floatList.get(i)).floatValue();
                            }
                            embeddingList.add(new Embedding(vectorValues, Integer.valueOf(originalIndex)));
                        }
                        if (contentEmbedding.statistics().isPresent() && (stats = (ContentEmbeddingStatistics)contentEmbedding.statistics().get()).tokenCount().isPresent()) {
                            totalTokenCount += ((Float)stats.tokenCount().get()).intValue();
                        }
                        ++validIndex;
                    } else if (!StringUtils.hasText((String)originalText)) {
                        embeddingList.add(new Embedding(new float[0], Integer.valueOf(originalIndex)));
                    }
                    ++originalIndex;
                }
            }
            EmbeddingResponse response = new EmbeddingResponse(embeddingList, this.generateResponseMetadata(options.getModel(), totalTokenCount));
            observationContext.setResponse((Object)response);
            return response;
        });
    }

    EmbeddingRequest buildEmbeddingRequest(EmbeddingRequest embeddingRequest) {
        GoogleGenAiTextEmbeddingOptions requestOptions;
        GoogleGenAiTextEmbeddingOptions runtimeOptions = null;
        if (embeddingRequest.getOptions() != null) {
            runtimeOptions = (GoogleGenAiTextEmbeddingOptions)ModelOptionsUtils.copyToTarget((Object)embeddingRequest.getOptions(), EmbeddingOptions.class, GoogleGenAiTextEmbeddingOptions.class);
        }
        if (!StringUtils.hasText((String)(requestOptions = (GoogleGenAiTextEmbeddingOptions)ModelOptionsUtils.merge(runtimeOptions, (Object)this.defaultOptions, GoogleGenAiTextEmbeddingOptions.class)).getModel())) {
            throw new IllegalArgumentException("model cannot be null or empty");
        }
        return new EmbeddingRequest(embeddingRequest.getInstructions(), (EmbeddingOptions)requestOptions);
    }

    private EmbeddingResponseMetadata generateResponseMetadata(String model, Integer totalTokens) {
        EmbeddingResponseMetadata metadata = new EmbeddingResponseMetadata();
        metadata.setModel(model);
        DefaultUsage usage = this.getDefaultUsage(totalTokens);
        metadata.setUsage((Usage)usage);
        return metadata;
    }

    private DefaultUsage getDefaultUsage(Integer totalTokens) {
        return new DefaultUsage(Integer.valueOf(0), Integer.valueOf(0), totalTokens);
    }

    public int dimensions() {
        return KNOWN_EMBEDDING_DIMENSIONS.computeIfAbsent(this.defaultOptions.getModel(), model -> super.dimensions());
    }

    public void setObservationConvention(EmbeddingModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }
}

