/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.elevenlabs.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.NoopApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class ElevenLabsVoicesApi {
    private static final String DEFAULT_BASE_URL = "https://api.elevenlabs.io";
    private final RestClient restClient;

    public ElevenLabsVoicesApi(String baseUrl, ApiKey apiKey, MultiValueMap<String, String> headers, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        Consumer<HttpHeaders> jsonContentHeaders = h -> {
            if (!(apiKey instanceof NoopApiKey)) {
                h.set("xi-api-key", apiKey.getValue());
            }
            h.addAll(headers);
            h.setContentType(MediaType.APPLICATION_JSON);
        };
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(jsonContentHeaders).defaultStatusHandler(responseErrorHandler).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public ResponseEntity<Voices> getVoices() {
        return this.restClient.get().uri("/v1/voices", new Object[0]).retrieve().toEntity(Voices.class);
    }

    public ResponseEntity<VoiceSettings> getDefaultVoiceSettings() {
        return this.restClient.get().uri("/v1/voices/settings/default", new Object[0]).retrieve().toEntity(VoiceSettings.class);
    }

    public ResponseEntity<VoiceSettings> getVoiceSettings(String voiceId) {
        Assert.hasText((String)voiceId, (String)"voiceId cannot be null or empty");
        return this.restClient.get().uri("/v1/voices/{voiceId}/settings", new Object[]{voiceId}).retrieve().toEntity(VoiceSettings.class);
    }

    public ResponseEntity<Voice> getVoice(String voiceId) {
        Assert.hasText((String)voiceId, (String)"voiceId cannot be null or empty");
        return this.restClient.get().uri("/v1/voices/{voiceId}", new Object[]{voiceId}).retrieve().toEntity(Voice.class);
    }

    public static class Builder {
        private String baseUrl = "https://api.elevenlabs.io";
        private ApiKey apiKey;
        private MultiValueMap<String, String> headers = new LinkedMultiValueMap();
        private RestClient.Builder restClientBuilder = RestClient.builder();
        private ResponseErrorHandler responseErrorHandler = RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER;

        public Builder baseUrl(String baseUrl) {
            Assert.hasText((String)baseUrl, (String)"baseUrl cannot be null or empty");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiKey(ApiKey apiKey) {
            Assert.notNull((Object)apiKey, (String)"apiKey cannot be null");
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiKey(String simpleApiKey) {
            Assert.notNull((Object)simpleApiKey, (String)"simpleApiKey cannot be null");
            this.apiKey = new SimpleApiKey(simpleApiKey);
            return this;
        }

        public Builder headers(MultiValueMap<String, String> headers) {
            Assert.notNull(headers, (String)"headers cannot be null");
            this.headers = headers;
            return this;
        }

        public Builder restClientBuilder(RestClient.Builder restClientBuilder) {
            Assert.notNull((Object)restClientBuilder, (String)"restClientBuilder cannot be null");
            this.restClientBuilder = restClientBuilder;
            return this;
        }

        public Builder responseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            Assert.notNull((Object)responseErrorHandler, (String)"responseErrorHandler cannot be null");
            this.responseErrorHandler = responseErrorHandler;
            return this;
        }

        public ElevenLabsVoicesApi build() {
            Assert.notNull((Object)this.apiKey, (String)"apiKey must be set");
            return new ElevenLabsVoicesApi(this.baseUrl, this.apiKey, this.headers, this.restClientBuilder, this.responseErrorHandler);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Voices(@JsonProperty(value="voices") List<Voice> voices) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record VoiceSettings(@JsonProperty(value="stability") Double stability, @JsonProperty(value="similarity_boost") Double similarityBoost, @JsonProperty(value="style") Double style, @JsonProperty(value="use_speaker_boost") Boolean useSpeakerBoost, @JsonProperty(value="speed") Double speed) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Voice(@JsonProperty(value="voice_id") String voiceId, @JsonProperty(value="name") String name, @JsonProperty(value="samples") List<Sample> samples, @JsonProperty(value="category") CategoryEnum category, @JsonProperty(value="fine_tuning") FineTuning fineTuning, @JsonProperty(value="labels") Map<String, String> labels, @JsonProperty(value="description") String description, @JsonProperty(value="preview_url") String previewUrl, @JsonProperty(value="available_for_tiers") List<String> availableForTiers, @JsonProperty(value="settings") VoiceSettings settings, @JsonProperty(value="sharing") VoiceSharing sharing, @JsonProperty(value="high_quality_base_model_ids") List<String> highQualityBaseModelIds, @JsonProperty(value="verified_languages") List<VerifiedVoiceLanguage> verifiedLanguages, @JsonProperty(value="safety_control") SafetyControlEnum safetyControl, @JsonProperty(value="voice_verification") VoiceVerification voiceVerification, @JsonProperty(value="permission_on_resource") String permissionOnResource, @JsonProperty(value="is_owner") Boolean isOwner, @JsonProperty(value="is_legacy") Boolean isLegacy, @JsonProperty(value="is_mixed") Boolean isMixed, @JsonProperty(value="created_at_unix") Integer createdAtUnix) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record VerifiedVoiceLanguage(@JsonProperty(value="language") String language, @JsonProperty(value="model_id") String modelId, @JsonProperty(value="accent") String accent) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ReaderResource(@JsonProperty(value="resource_type") ResourceTypeEnum resourceType, @JsonProperty(value="resource_id") String resourceId) {

        public static enum ResourceTypeEnum {
            READ("read"),
            COLLECTION("collection");

            public final String value;

            private ResourceTypeEnum(String value) {
                this.value = value;
            }

            @JsonValue
            public String getValue() {
                return this.value;
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record VoiceSharingModerationCheck(@JsonProperty(value="date_checked_unix") Integer dateCheckedUnix, @JsonProperty(value="name_value") String nameValue, @JsonProperty(value="name_check") Boolean nameCheck, @JsonProperty(value="description_value") String descriptionValue, @JsonProperty(value="description_check") Boolean descriptionCheck, @JsonProperty(value="sample_ids") List<String> sampleIds, @JsonProperty(value="sample_checks") List<Double> sampleChecks, @JsonProperty(value="captcha_ids") List<String> captchaIds, @JsonProperty(value="captcha_checks") List<Double> captchaChecks) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record VoiceSharing(@JsonProperty(value="status") StatusEnum status, @JsonProperty(value="history_item_sample_id") String historyItemSampleId, @JsonProperty(value="date_unix") Integer dateUnix, @JsonProperty(value="whitelisted_emails") List<String> whitelistedEmails, @JsonProperty(value="public_owner_id") String publicOwnerId, @JsonProperty(value="original_voice_id") String originalVoiceId, @JsonProperty(value="financial_rewards_enabled") Boolean financialRewardsEnabled, @JsonProperty(value="free_users_allowed") Boolean freeUsersAllowed, @JsonProperty(value="live_moderation_enabled") Boolean liveModerationEnabled, @JsonProperty(value="rate") Double rate, @JsonProperty(value="notice_period") Integer noticePeriod, @JsonProperty(value="disable_at_unix") Integer disableAtUnix, @JsonProperty(value="voice_mixing_allowed") Boolean voiceMixingAllowed, @JsonProperty(value="featured") Boolean featured, @JsonProperty(value="category") CategoryEnum category, @JsonProperty(value="reader_app_enabled") Boolean readerAppEnabled, @JsonProperty(value="image_url") String imageUrl, @JsonProperty(value="ban_reason") String banReason, @JsonProperty(value="liked_by_count") Integer likedByCount, @JsonProperty(value="cloned_by_count") Integer clonedByCount, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="labels") Map<String, String> labels, @JsonProperty(value="review_status") ReviewStatusEnum reviewStatus, @JsonProperty(value="review_message") String reviewMessage, @JsonProperty(value="enabled_in_library") Boolean enabledInLibrary, @JsonProperty(value="instagram_username") String instagramUsername, @JsonProperty(value="twitter_username") String twitterUsername, @JsonProperty(value="youtube_username") String youtubeUsername, @JsonProperty(value="tiktok_username") String tiktokUsername, @JsonProperty(value="moderation_check") VoiceSharingModerationCheck moderationCheck, @JsonProperty(value="reader_restricted_on") List<ReaderResource> readerRestrictedOn) {

        public static enum StatusEnum {
            ENABLED("enabled"),
            DISABLED("disabled"),
            COPIED("copied"),
            COPIED_DISABLED("copied_disabled");

            public final String value;

            private StatusEnum(String value) {
                this.value = value;
            }

            @JsonValue
            public String getValue() {
                return this.value;
            }
        }

        public static enum CategoryEnum {
            GENERATED("generated"),
            PROFESSIONAL("professional"),
            HIGH_QUALITY("high_quality"),
            FAMOUS("famous");

            public final String value;

            private CategoryEnum(String value) {
                this.value = value;
            }

            @JsonValue
            public String getValue() {
                return this.value;
            }
        }

        public static enum ReviewStatusEnum {
            NOT_REQUESTED("not_requested"),
            PENDING("pending"),
            DECLINED("declined"),
            ALLOWED("allowed"),
            ALLOWED_WITH_CHANGES("allowed_with_changes");

            public final String value;

            private ReviewStatusEnum(String value) {
                this.value = value;
            }

            @JsonValue
            public String getValue() {
                return this.value;
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ManualVerificationFile(@JsonProperty(value="file_id") String fileId, @JsonProperty(value="file_name") String fileName, @JsonProperty(value="mime_type") String mimeType, @JsonProperty(value="size_bytes") Integer sizeBytes, @JsonProperty(value="upload_date_unix") Integer uploadDateUnix) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ManualVerification(@JsonProperty(value="extra_text") String extraText, @JsonProperty(value="request_time_unix") Integer requestTimeUnix, @JsonProperty(value="files") List<ManualVerificationFile> files) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Recording(@JsonProperty(value="recording_id") String recordingId, @JsonProperty(value="mime_type") String mimeType, @JsonProperty(value="size_bytes") Integer sizeBytes, @JsonProperty(value="upload_date_unix") Integer uploadDateUnix, @JsonProperty(value="transcription") String transcription) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record VerificationAttempt(@JsonProperty(value="text") String text, @JsonProperty(value="date_unix") Integer dateUnix, @JsonProperty(value="accepted") Boolean accepted, @JsonProperty(value="similarity") Double similarity, @JsonProperty(value="levenshtein_distance") Double levenshteinDistance, @JsonProperty(value="recording") Recording recording) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record VoiceVerification(@JsonProperty(value="requires_verification") Boolean requiresVerification, @JsonProperty(value="is_verified") Boolean isVerified, @JsonProperty(value="verification_failures") List<String> verificationFailures, @JsonProperty(value="verification_attempts_count") Integer verificationAttemptsCount, @JsonProperty(value="language") String language, @JsonProperty(value="verification_attempts") List<VerificationAttempt> verificationAttempts) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record FineTuning(@JsonProperty(value="is_allowed_to_fine_tune") Boolean isAllowedToFineTune, @JsonProperty(value="state") Map<String, String> state, @JsonProperty(value="verification_failures") List<String> verificationFailures, @JsonProperty(value="verification_attempts_count") Integer verificationAttemptsCount, @JsonProperty(value="manual_verification_requested") Boolean manualVerificationRequested, @JsonProperty(value="language") String language, @JsonProperty(value="progress") Map<String, Double> progress, @JsonProperty(value="message") Map<String, String> message, @JsonProperty(value="dataset_duration_seconds") Double datasetDurationSeconds, @JsonProperty(value="verification_attempts") List<VerificationAttempt> verificationAttempts, @JsonProperty(value="slice_ids") List<String> sliceIds, @JsonProperty(value="manual_verification") ManualVerification manualVerification, @JsonProperty(value="max_verification_attempts") Integer maxVerificationAttempts, @JsonProperty(value="next_max_verification_attempts_reset_unix_ms") Long nextMaxVerificationAttemptsResetUnixMs) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Sample(@JsonProperty(value="sample_id") String sampleId, @JsonProperty(value="file_name") String fileName, @JsonProperty(value="mime_type") String mimeType, @JsonProperty(value="size_bytes") Integer sizeBytes, @JsonProperty(value="hash") String hash) {
    }

    public static enum SafetyControlEnum {
        NONE("NONE"),
        BAN("BAN"),
        CAPTCHA("CAPTCHA"),
        CAPTCHA_AND_MODERATION("CAPTCHA_AND_MODERATION"),
        ENTERPRISE_BAN("ENTERPRISE_BAN"),
        ENTERPRISE_CAPTCHA("ENTERPRISE_CAPTCHA");

        public final String value;

        private SafetyControlEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }

    public static enum CategoryEnum {
        GENERATED("generated"),
        CLONED("cloned"),
        PREMADE("premade"),
        PROFESSIONAL("professional"),
        FAMOUS("famous"),
        HIGH_QUALITY("high_quality");

        public final String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

