/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.elevenlabs.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.NoopApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ElevenLabsApi {
    public static final String DEFAULT_BASE_URL = "https://api.elevenlabs.io";
    private final RestClient restClient;
    private final WebClient webClient;

    private ElevenLabsApi(String baseUrl, ApiKey apiKey, MultiValueMap<String, String> headers, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        Consumer<HttpHeaders> jsonContentHeaders = h -> {
            if (!(apiKey instanceof NoopApiKey)) {
                h.set("xi-api-key", apiKey.getValue());
            }
            h.addAll(headers);
            h.setContentType(MediaType.APPLICATION_JSON);
        };
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(jsonContentHeaders).defaultStatusHandler(responseErrorHandler).build();
        this.webClient = webClientBuilder.baseUrl(baseUrl).defaultHeaders(jsonContentHeaders).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public ResponseEntity<byte[]> textToSpeech(SpeechRequest requestBody, String voiceId, MultiValueMap<String, String> queryParameters) {
        Assert.notNull((Object)voiceId, (String)"voiceId must be provided. It cannot be null.");
        Assert.notNull((Object)requestBody, (String)"requestBody can not be null.");
        Assert.hasText((String)requestBody.text(), (String)"requestBody.text must be provided. It cannot be null or empty.");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromPath((String)"/v1/text-to-speech/{voice_id}").queryParams(queryParameters);
        return ((RestClient.RequestBodySpec)this.restClient.post().uri(uriBuilder.buildAndExpand(new Object[]{voiceId}).toUriString(), new Object[0])).body((Object)requestBody).retrieve().toEntity(byte[].class);
    }

    public Flux<ResponseEntity<byte[]>> textToSpeechStream(SpeechRequest requestBody, String voiceId, MultiValueMap<String, String> queryParameters) {
        Assert.notNull((Object)voiceId, (String)"voiceId must be provided for streaming. It cannot be null.");
        Assert.notNull((Object)requestBody, (String)"requestBody can not be null.");
        Assert.hasText((String)requestBody.text(), (String)"requestBody.text must be provided. It cannot be null or empty.");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromPath((String)"/v1/text-to-speech/{voice_id}/stream").queryParams(queryParameters);
        return ((WebClient.RequestBodySpec)this.webClient.post().uri(uriBuilder.buildAndExpand(new Object[]{voiceId}).toUriString(), new Object[0])).body((Publisher)Mono.just((Object)requestBody), SpeechRequest.class).accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM}).exchangeToFlux(clientResponse -> {
            HttpHeaders headers = clientResponse.headers().asHttpHeaders();
            return clientResponse.bodyToFlux(byte[].class).map(bytes -> ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(bytes));
        });
    }

    public static class Builder {
        private String baseUrl = "https://api.elevenlabs.io";
        private ApiKey apiKey;
        private MultiValueMap<String, String> headers = new LinkedMultiValueMap();
        private RestClient.Builder restClientBuilder = RestClient.builder();
        private WebClient.Builder webClientBuilder = WebClient.builder();
        private ResponseErrorHandler responseErrorHandler = RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER;

        public Builder baseUrl(String baseUrl) {
            Assert.hasText((String)baseUrl, (String)"baseUrl cannot be null or empty");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiKey(ApiKey apiKey) {
            Assert.notNull((Object)apiKey, (String)"apiKey cannot be null");
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiKey(String simpleApiKey) {
            Assert.notNull((Object)simpleApiKey, (String)"simpleApiKey cannot be null");
            this.apiKey = new SimpleApiKey(simpleApiKey);
            return this;
        }

        public Builder headers(MultiValueMap<String, String> headers) {
            Assert.notNull(headers, (String)"headers cannot be null");
            this.headers = headers;
            return this;
        }

        public Builder restClientBuilder(RestClient.Builder restClientBuilder) {
            Assert.notNull((Object)restClientBuilder, (String)"restClientBuilder cannot be null");
            this.restClientBuilder = restClientBuilder;
            return this;
        }

        public Builder webClientBuilder(WebClient.Builder webClientBuilder) {
            Assert.notNull((Object)webClientBuilder, (String)"webClientBuilder cannot be null");
            this.webClientBuilder = webClientBuilder;
            return this;
        }

        public Builder responseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            Assert.notNull((Object)responseErrorHandler, (String)"responseErrorHandler cannot be null");
            this.responseErrorHandler = responseErrorHandler;
            return this;
        }

        public ElevenLabsApi build() {
            Assert.notNull((Object)this.apiKey, (String)"apiKey must be set");
            return new ElevenLabsApi(this.baseUrl, this.apiKey, this.headers, this.restClientBuilder, this.webClientBuilder, this.responseErrorHandler);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record SpeechRequest(@JsonProperty(value="text") String text, @JsonProperty(value="model_id") String modelId, @JsonProperty(value="language_code") String languageCode, @JsonProperty(value="voice_settings") VoiceSettings voiceSettings, @JsonProperty(value="pronunciation_dictionary_locators") List<PronunciationDictionaryLocator> pronunciationDictionaryLocators, @JsonProperty(value="seed") Integer seed, @JsonProperty(value="previous_text") String previousText, @JsonProperty(value="next_text") String nextText, @JsonProperty(value="previous_request_ids") List<String> previousRequestIds, @JsonProperty(value="next_request_ids") List<String> nextRequestIds, @JsonProperty(value="apply_text_normalization") TextNormalizationMode applyTextNormalization, @JsonProperty(value="apply_language_text_normalization") Boolean applyLanguageTextNormalization) {
        public static Builder builder() {
            return new Builder();
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record VoiceSettings(@JsonProperty(value="stability") Double stability, @JsonProperty(value="similarity_boost") Double similarityBoost, @JsonProperty(value="style") Double style, @JsonProperty(value="use_speaker_boost") Boolean useSpeakerBoost, @JsonProperty(value="speed") Double speed) {
        }

        public static enum TextNormalizationMode {
            AUTO("auto"),
            ON("on"),
            OFF("off");

            public final String value;

            private TextNormalizationMode(String value) {
                this.value = value;
            }

            @JsonValue
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private String text;
            private String modelId;
            private String languageCode;
            private VoiceSettings voiceSettings;
            private List<PronunciationDictionaryLocator> pronunciationDictionaryLocators;
            private Integer seed;
            private String previousText;
            private String nextText;
            private List<String> previousRequestIds;
            private List<String> nextRequestIds;
            private TextNormalizationMode applyTextNormalization;
            private Boolean applyLanguageTextNormalization = false;

            public Builder text(String text) {
                this.text = text;
                return this;
            }

            public Builder modelId(String modelId) {
                this.modelId = modelId;
                return this;
            }

            public Builder languageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            public Builder voiceSettings(VoiceSettings voiceSettings) {
                this.voiceSettings = voiceSettings;
                return this;
            }

            public Builder pronunciationDictionaryLocators(List<PronunciationDictionaryLocator> pronunciationDictionaryLocators) {
                this.pronunciationDictionaryLocators = pronunciationDictionaryLocators;
                return this;
            }

            public Builder seed(Integer seed) {
                this.seed = seed;
                return this;
            }

            public Builder previousText(String previousText) {
                this.previousText = previousText;
                return this;
            }

            public Builder nextText(String nextText) {
                this.nextText = nextText;
                return this;
            }

            public Builder previousRequestIds(List<String> previousRequestIds) {
                this.previousRequestIds = previousRequestIds;
                return this;
            }

            public Builder nextRequestIds(List<String> nextRequestIds) {
                this.nextRequestIds = nextRequestIds;
                return this;
            }

            public Builder applyTextNormalization(TextNormalizationMode applyTextNormalization) {
                this.applyTextNormalization = applyTextNormalization;
                return this;
            }

            public Builder applyLanguageTextNormalization(Boolean applyLanguageTextNormalization) {
                this.applyLanguageTextNormalization = applyLanguageTextNormalization;
                return this;
            }

            public SpeechRequest build() {
                Assert.hasText((String)this.text, (String)"text must not be empty");
                return new SpeechRequest(this.text, this.modelId, this.languageCode, this.voiceSettings, this.pronunciationDictionaryLocators, this.seed, this.previousText, this.nextText, this.previousRequestIds, this.nextRequestIds, this.applyTextNormalization, this.applyLanguageTextNormalization);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record PronunciationDictionaryLocator(@JsonProperty(value="pronunciation_dictionary_id") String pronunciationDictionaryId, @JsonProperty(value="version_id") String versionId) {
        }
    }

    public static enum OutputFormat {
        MP3_22050_32("mp3_22050_32"),
        MP3_44100_32("mp3_44100_32"),
        MP3_44100_64("mp3_44100_64"),
        MP3_44100_96("mp3_44100_96"),
        MP3_44100_128("mp3_44100_128"),
        MP3_44100_192("mp3_44100_192"),
        PCM_8000("pcm_8000"),
        PCM_16000("pcm_16000"),
        PCM_22050("pcm_22050"),
        PCM_24000("pcm_24000"),
        PCM_44100("pcm_44100"),
        PCM_48000("pcm_48000"),
        ULAW_8000("ulaw_8000"),
        ALAW_8000("alaw_8000"),
        OPUS_48000_32("opus_48000_32"),
        OPUS_48000_64("opus_48000_64"),
        OPUS_48000_96("opus_48000_96"),
        OPUS_48000_128("opus_48000_128"),
        OPUS_48000_192("opus_48000_192");

        private final String value;

        private OutputFormat(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

