/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.mapping.DenseVectorSimilarity;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.elasticsearch.core.bulk.DeleteOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.Version;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import co.elastic.clients.util.ObjectBuilder;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.client.RestClient;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentMetadata;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.model.EmbeddingUtils;
import org.springframework.ai.observation.conventions.VectorStoreProvider;
import org.springframework.ai.observation.conventions.VectorStoreSimilarityMetric;
import org.springframework.ai.vectorstore.AbstractVectorStoreBuilder;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.elasticsearch.ElasticsearchAiSearchFilterExpressionConverter;
import org.springframework.ai.vectorstore.elasticsearch.ElasticsearchVectorStoreOptions;
import org.springframework.ai.vectorstore.elasticsearch.SimilarityFunction;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionConverter;
import org.springframework.ai.vectorstore.observation.AbstractObservationVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ElasticsearchVectorStore
extends AbstractObservationVectorStore
implements InitializingBean {
    private static final Map<SimilarityFunction, VectorStoreSimilarityMetric> SIMILARITY_TYPE_MAPPING = Map.of(SimilarityFunction.cosine, VectorStoreSimilarityMetric.COSINE, SimilarityFunction.l2_norm, VectorStoreSimilarityMetric.EUCLIDEAN, SimilarityFunction.dot_product, VectorStoreSimilarityMetric.DOT);
    private final ElasticsearchClient elasticsearchClient;
    private final ElasticsearchVectorStoreOptions options;
    private final FilterExpressionConverter filterExpressionConverter;
    private final boolean initializeSchema;

    protected ElasticsearchVectorStore(Builder builder) {
        super((AbstractVectorStoreBuilder)builder);
        Assert.notNull((Object)builder.restClient, (String)"RestClient must not be null");
        this.initializeSchema = builder.initializeSchema;
        this.options = builder.options;
        this.filterExpressionConverter = builder.filterExpressionConverter;
        String version = Version.VERSION == null ? "Unknown" : Version.VERSION.toString();
        this.elasticsearchClient = (ElasticsearchClient)new ElasticsearchClient((ElasticsearchTransport)new RestClientTransport(builder.restClient, (JsonpMapper)new JacksonJsonpMapper(new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)))).withTransportOptions(t -> t.addHeader("user-agent", "spring-ai elastic-java/" + version));
    }

    public void doAdd(List<Document> documents) {
        BulkRequest.Builder bulkRequestBuilder = new BulkRequest.Builder();
        List embeddings = this.embeddingModel.embed(documents, EmbeddingOptions.builder().build(), this.batchingStrategy);
        for (int i = 0; i < embeddings.size(); ++i) {
            Document document = documents.get(i);
            float[] embedding = (float[])embeddings.get(i);
            bulkRequestBuilder.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(this.options.getIndexName())).id(document.getId())).document(this.getDocument(document, embedding, this.options.getEmbeddingFieldName()))));
        }
        BulkResponse bulkRequest = this.bulkRequest(bulkRequestBuilder.build());
        if (bulkRequest.errors()) {
            List bulkResponseItems = bulkRequest.items();
            for (BulkResponseItem bulkResponseItem : bulkResponseItems) {
                if (bulkResponseItem.error() == null) continue;
                throw new IllegalStateException(bulkResponseItem.error().reason());
            }
        }
    }

    private Object getDocument(Document document, float[] embedding, String embeddingFieldName) {
        Assert.notNull((Object)document.getText(), (String)"document's text must not be null");
        return Map.of("id", document.getId(), "content", document.getText(), "metadata", document.getMetadata(), embeddingFieldName, embedding);
    }

    public void doDelete(List<String> idList) {
        BulkRequest.Builder bulkRequestBuilder = new BulkRequest.Builder();
        for (String id : idList) {
            bulkRequestBuilder.operations(op -> op.delete(idx -> (ObjectBuilder)((DeleteOperation.Builder)idx.index(this.options.getIndexName())).id(id)));
        }
        if (this.bulkRequest(bulkRequestBuilder.build()).errors()) {
            throw new IllegalStateException("Delete operation failed");
        }
    }

    public void doDelete(Filter.Expression filterExpression) {
        try {
            this.elasticsearchClient.deleteByQuery(d -> d.index(this.options.getIndexName(), new String[0]).query(q -> q.queryString(qs -> qs.query(this.getElasticsearchQueryString(filterExpression)))));
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to delete documents by filter", e);
        }
    }

    private BulkResponse bulkRequest(BulkRequest bulkRequest) {
        try {
            return this.elasticsearchClient.bulk(bulkRequest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Document> doSimilaritySearch(SearchRequest searchRequest) {
        Assert.notNull((Object)searchRequest, (String)"The search request must not be null.");
        try {
            float threshold = (float)searchRequest.getSimilarityThreshold();
            if (this.options.getSimilarity().equals((Object)SimilarityFunction.l2_norm)) {
                threshold = 1.0f - threshold;
            }
            float finalThreshold = threshold;
            float[] vectors = this.embeddingModel.embed(searchRequest.getQuery());
            SearchResponse res = this.elasticsearchClient.search(sr -> sr.index(this.options.getIndexName(), new String[0]).knn(knn -> knn.queryVector(EmbeddingUtils.toList((float[])vectors)).similarity(Float.valueOf(finalThreshold)).k(Integer.valueOf(searchRequest.getTopK())).field(this.options.getEmbeddingFieldName()).numCandidates(Integer.valueOf((int)(1.5 * (double)searchRequest.getTopK()))).filter(fl -> fl.queryString(qs -> qs.query(this.getElasticsearchQueryString(searchRequest.getFilterExpression()))))).size(Integer.valueOf(searchRequest.getTopK())), Document.class);
            return res.hits().hits().stream().map(this::toDocument).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getElasticsearchQueryString(Filter.Expression filterExpression) {
        return Objects.isNull(filterExpression) ? "*" : this.filterExpressionConverter.convertExpression(filterExpression);
    }

    private Document toDocument(Hit<Document> hit) {
        Document document = (Document)hit.source();
        Document.Builder documentBuilder = document.mutate();
        if (hit.score() != null) {
            documentBuilder.metadata(DocumentMetadata.DISTANCE.value(), (Object)(1.0 - this.normalizeSimilarityScore(hit.score())));
            documentBuilder.score(Double.valueOf(this.normalizeSimilarityScore(hit.score())));
        }
        return documentBuilder.build();
    }

    private double normalizeSimilarityScore(double score) {
        return switch (this.options.getSimilarity()) {
            case SimilarityFunction.l2_norm -> 1.0 - Math.sqrt(1.0 / score - 1.0);
            default -> 2.0 * score - 1.0;
        };
    }

    public boolean indexExists() {
        try {
            return this.elasticsearchClient.indices().exists(ex -> ex.index(this.options.getIndexName(), new String[0])).value();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createIndexMapping() {
        try {
            this.elasticsearchClient.indices().create(cr -> cr.index(this.options.getIndexName()).mappings(map -> map.properties(this.options.getEmbeddingFieldName(), p -> p.denseVector(dv -> dv.similarity(this.parseSimilarity(this.options.getSimilarity().toString())).dims(Integer.valueOf(this.options.getDimensions()))))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private DenseVectorSimilarity parseSimilarity(String similarity) {
        for (DenseVectorSimilarity sim : DenseVectorSimilarity.values()) {
            if (!sim.jsonValue().equalsIgnoreCase(similarity)) continue;
            return sim;
        }
        throw new IllegalArgumentException("Unsupported similarity: " + similarity);
    }

    public void afterPropertiesSet() {
        if (this.indexExists()) {
            return;
        }
        if (!this.initializeSchema) {
            throw new IllegalArgumentException("Index not found");
        }
        this.createIndexMapping();
    }

    public VectorStoreObservationContext.Builder createObservationContextBuilder(String operationName) {
        return VectorStoreObservationContext.builder((String)VectorStoreProvider.ELASTICSEARCH.value(), (String)operationName).collectionName(this.options.getIndexName()).dimensions(Integer.valueOf(this.embeddingModel.dimensions())).similarityMetric(this.getSimilarityMetric());
    }

    private String getSimilarityMetric() {
        if (!SIMILARITY_TYPE_MAPPING.containsKey((Object)this.options.getSimilarity())) {
            return this.options.getSimilarity().name();
        }
        return SIMILARITY_TYPE_MAPPING.get((Object)this.options.getSimilarity()).value();
    }

    public <T> Optional<T> getNativeClient() {
        ElasticsearchClient client = this.elasticsearchClient;
        return Optional.of(client);
    }

    public static Builder builder(RestClient restClient, EmbeddingModel embeddingModel) {
        return new Builder(restClient, embeddingModel);
    }

    public static class Builder
    extends AbstractVectorStoreBuilder<Builder> {
        private final RestClient restClient;
        private ElasticsearchVectorStoreOptions options = new ElasticsearchVectorStoreOptions();
        private boolean initializeSchema = false;
        private FilterExpressionConverter filterExpressionConverter = new ElasticsearchAiSearchFilterExpressionConverter();

        public Builder(RestClient restClient, EmbeddingModel embeddingModel) {
            super(embeddingModel);
            Assert.notNull((Object)restClient, (String)"RestClient must not be null");
            this.restClient = restClient;
        }

        public Builder options(ElasticsearchVectorStoreOptions options) {
            Assert.notNull((Object)options, (String)"options must not be null");
            this.options = options;
            return this;
        }

        public Builder initializeSchema(boolean initializeSchema) {
            this.initializeSchema = initializeSchema;
            return this;
        }

        public Builder filterExpressionConverter(FilterExpressionConverter converter) {
            Assert.notNull((Object)converter, (String)"filterExpressionConverter must not be null");
            this.filterExpressionConverter = converter;
            return this;
        }

        public ElasticsearchVectorStore build() {
            return new ElasticsearchVectorStore(this);
        }
    }
}

