/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.deepseek;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.content.Media;

public class DeepSeekAssistantMessage
extends AssistantMessage {
    private Boolean prefix;
    private String reasoningContent;

    @Deprecated
    public DeepSeekAssistantMessage(String content) {
        super(content);
    }

    @Deprecated
    public DeepSeekAssistantMessage(String content, String reasoningContent) {
        super(content);
        this.reasoningContent = reasoningContent;
    }

    @Deprecated
    public DeepSeekAssistantMessage(String content, Map<String, Object> properties) {
        super(content, properties);
    }

    @Deprecated
    public DeepSeekAssistantMessage(String content, Map<String, Object> properties, List<AssistantMessage.ToolCall> toolCalls) {
        super(content, properties, toolCalls);
    }

    @Deprecated
    public DeepSeekAssistantMessage(String content, String reasoningContent, Map<String, Object> properties, List<AssistantMessage.ToolCall> toolCalls) {
        this(content, reasoningContent, properties, toolCalls, List.of());
    }

    @Deprecated
    public DeepSeekAssistantMessage(String content, String reasoningContent, Map<String, Object> properties, List<AssistantMessage.ToolCall> toolCalls, List<Media> media) {
        this(content, reasoningContent, null, properties, toolCalls, media);
    }

    protected DeepSeekAssistantMessage(String content, String reasoningContent, Boolean prefix, Map<String, Object> properties, List<AssistantMessage.ToolCall> toolCalls, List<Media> media) {
        super(content, properties, toolCalls, media);
        this.reasoningContent = reasoningContent;
        this.prefix = prefix;
    }

    public static DeepSeekAssistantMessage prefixAssistantMessage(String content) {
        return DeepSeekAssistantMessage.prefixAssistantMessage(content, null);
    }

    public static DeepSeekAssistantMessage prefixAssistantMessage(String content, String reasoningContent) {
        return new Builder().content(content).reasoningContent(reasoningContent).build();
    }

    public Boolean getPrefix() {
        return this.prefix;
    }

    public void setPrefix(Boolean prefix) {
        this.prefix = prefix;
    }

    public String getReasoningContent() {
        return this.reasoningContent;
    }

    public void setReasoningContent(String reasoningContent) {
        this.reasoningContent = reasoningContent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeepSeekAssistantMessage)) {
            return false;
        }
        DeepSeekAssistantMessage that = (DeepSeekAssistantMessage)((Object)o);
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.reasoningContent, that.reasoningContent) && Objects.equals(this.prefix, that.prefix);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.prefix, this.reasoningContent);
    }

    public String toString() {
        return "DeepSeekAssistantMessage [messageType=" + String.valueOf(this.messageType) + ", toolCalls=" + String.valueOf(super.getToolCalls()) + ", textContent=" + this.textContent + ", reasoningContent=" + this.reasoningContent + ", prefix=" + this.prefix + ", metadata=" + String.valueOf(this.metadata) + "]";
    }

    public static final class Builder {
        private String content;
        private Map<String, Object> properties = Map.of();
        private List<AssistantMessage.ToolCall> toolCalls = List.of();
        private List<Media> media = List.of();
        private Boolean prefix;
        private String reasoningContent;

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public Builder toolCalls(List<AssistantMessage.ToolCall> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        public Builder media(List<Media> media) {
            this.media = media;
            return this;
        }

        public Builder prefix(Boolean prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder reasoningContent(String reasoningContent) {
            this.reasoningContent = reasoningContent;
            return this;
        }

        public DeepSeekAssistantMessage build() {
            return new DeepSeekAssistantMessage(this.content, this.reasoningContent, this.prefix, this.properties, this.toolCalls, this.media);
        }
    }
}

