/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.couchbase;

import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;

public class CouchbaseAiSearchFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    protected void doExpression(Filter.Expression expression, StringBuilder context) {
        this.convertOperand(expression.left(), context);
        context.append(this.getOperationSymbol(expression));
        if (expression.right() != null) {
            this.convertOperand(expression.right(), context);
        } else {
            context.append("NULL");
        }
    }

    private String getOperationSymbol(Filter.Expression exp) {
        return switch (exp.type()) {
            case Filter.ExpressionType.AND -> " AND ";
            case Filter.ExpressionType.OR -> " OR ";
            case Filter.ExpressionType.EQ -> " == ";
            case Filter.ExpressionType.NE -> " != ";
            case Filter.ExpressionType.LT -> " < ";
            case Filter.ExpressionType.LTE -> " <= ";
            case Filter.ExpressionType.GT -> " > ";
            case Filter.ExpressionType.GTE -> " >= ";
            case Filter.ExpressionType.IN -> " IN ";
            case Filter.ExpressionType.NIN -> " NOT IN ";
            default -> throw new RuntimeException("Not supported expression type: " + String.valueOf(exp.type()));
        };
    }

    protected void doKey(Filter.Key key, StringBuilder context) {
        context.append("metadata.");
        context.append(key.key());
    }

    protected void doStartGroup(Filter.Group group, StringBuilder context) {
        context.append("(");
    }

    protected void doEndGroup(Filter.Group group, StringBuilder context) {
        context.append(")");
    }
}

