/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.util.ConsistencyUtil;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.Scope;
import com.couchbase.client.java.manager.bucket.BucketSettings;
import com.couchbase.client.java.manager.collection.CollectionSpec;
import com.couchbase.client.java.manager.collection.ScopeSpec;
import com.couchbase.client.java.manager.query.CreatePrimaryQueryIndexOptions;
import com.couchbase.client.java.manager.search.SearchIndex;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.EmbeddingOptionsBuilder;
import org.springframework.ai.observation.conventions.VectorStoreProvider;
import org.springframework.ai.vectorstore.AbstractVectorStoreBuilder;
import org.springframework.ai.vectorstore.CouchbaseAiSearchFilterExpressionConverter;
import org.springframework.ai.vectorstore.CouchbaseIndexOptimization;
import org.springframework.ai.vectorstore.CouchbaseSimilarityFunction;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.observation.AbstractObservationVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import reactor.util.retry.RetrySpec;

public class CouchbaseSearchVectorStore
extends AbstractObservationVectorStore
implements InitializingBean,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(CouchbaseSearchVectorStore.class);
    private static final String DEFAULT_INDEX_NAME = "spring-ai-document-index";
    private static final String DEFAULT_COLLECTION_NAME = "_default";
    private static final String DEFAULT_SCOPE_NAME = "_default";
    private static final String DEFAULT_BUCKET_NAME = "default";
    private final EmbeddingModel embeddingModel;
    private final String collectionName;
    private final String scopeName;
    private final String bucketName;
    private final String vectorIndexName;
    private final Integer dimensions;
    private final CouchbaseSimilarityFunction similarityFunction;
    private final CouchbaseIndexOptimization indexOptimization;
    private final Cluster cluster;
    private final CouchbaseAiSearchFilterExpressionConverter filterExpressionConverter;
    private final boolean initializeSchema;
    private final com.couchbase.client.java.Collection collection;
    private final Scope scope;
    private final Bucket bucket;

    protected CouchbaseSearchVectorStore(Builder builder) {
        super((AbstractVectorStoreBuilder)builder);
        Objects.requireNonNull(builder.cluster, "CouchbaseCluster must not be null");
        Objects.requireNonNull(builder.embeddingModel, "embeddingModel must not be null");
        this.initializeSchema = builder.initializeSchema;
        this.embeddingModel = builder.embeddingModel;
        this.filterExpressionConverter = builder.filterExpressionConverter;
        this.cluster = builder.cluster;
        this.bucket = this.cluster.bucket(builder.bucketName);
        this.scope = this.bucket.scope(builder.scopeName);
        this.collection = this.scope.collection(builder.collectionName);
        this.vectorIndexName = builder.vectorIndexName;
        this.collectionName = builder.collectionName;
        this.bucketName = builder.bucketName;
        this.scopeName = builder.scopeName;
        this.dimensions = builder.dimensions;
        this.similarityFunction = builder.similarityFunction;
        this.indexOptimization = builder.indexOptimization;
    }

    public void afterPropertiesSet() {
        if (!this.initializeSchema) {
            return;
        }
        try {
            logger.info("Init Cluster Called");
            this.initCluster();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void doAdd(List<Document> documents) {
        logger.info("Trying Add");
        logger.info(this.bucketName);
        logger.info(this.scopeName);
        List embeddings = this.embeddingModel.embed(documents, EmbeddingOptionsBuilder.builder().build(), this.batchingStrategy);
        for (Document document : documents) {
            CouchbaseDocument cbDoc = new CouchbaseDocument(document.getId(), document.getText(), document.getMetadata(), (float[])embeddings.get(documents.indexOf(document)));
            this.collection.upsert(document.getId(), (Object)cbDoc);
        }
    }

    public void doDelete(List<String> idList) {
        for (String id : idList) {
            this.collection.remove(id);
        }
    }

    public void doDelete(Filter.Expression filterExpression) {
        Assert.notNull((Object)filterExpression, (String)"Filter expression must not be null");
        try {
            String nativeFilter = this.filterExpressionConverter.convertExpression(filterExpression);
            String sql = String.format("DELETE FROM %s WHERE %s", this.collection.name(), nativeFilter);
            this.scope.query(sql, QueryOptions.queryOptions().metrics(true));
        }
        catch (Exception e) {
            logger.error("Failed to delete documents by filter: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException("Failed to delete documents by filter", e);
        }
    }

    public List<Document> doSimilaritySearch(SearchRequest springAiRequest) {
        float[] embeddings = this.embeddingModel.embed(springAiRequest.getQuery());
        int topK = springAiRequest.getTopK();
        double similarityThreshold = springAiRequest.getSimilarityThreshold();
        Filter.Expression fe = springAiRequest.getFilterExpression();
        String nativeFilterExpression = fe != null ? " AND " + this.filterExpressionConverter.convertExpression(fe) : "";
        String statement = String.format("SELECT c.* FROM `%s` AS c\nWHERE SEARCH_SCORE() > %s AND SEARCH(`c`, {\"query\": {\"match_none\": {}}, \"knn\": [{\"field\": \"embedding\", \"k\": %s, \"vector\": %s }   ]    }, {\"index\": \"%s.%s.%s\"}   )\n%s\n", this.collectionName, similarityThreshold, topK, Arrays.toString(embeddings), this.bucketName, this.scopeName, this.vectorIndexName, nativeFilterExpression);
        QueryResult result = this.scope.query(statement, QueryOptions.queryOptions());
        return result.rowsAs(Document.class);
    }

    public <T> Optional<T> getNativeClient() {
        CouchbaseSearchVectorStore client = this;
        return Optional.of(client);
    }

    public VectorStoreObservationContext.Builder createObservationContextBuilder(String operationName) {
        return VectorStoreObservationContext.builder((String)VectorStoreProvider.COUCHBASE.value(), (String)operationName).collectionName(this.collection.name()).dimensions(Integer.valueOf(this.embeddingModel.dimensions()));
    }

    public static Builder builder(Cluster cluster, EmbeddingModel embeddingModel) {
        return new Builder(cluster, embeddingModel);
    }

    public void initCluster() throws InterruptedException {
        boolean indexExist;
        BucketSettings bs = (BucketSettings)this.cluster.buckets().getAllBuckets().get(this.bucketName);
        if (bs == null) {
            this.cluster.buckets().createBucket(BucketSettings.create((String)this.bucketName));
        }
        logger.info("Created bucket");
        Bucket b = this.cluster.bucket(this.bucketName);
        b.waitUntilReady(Duration.ofSeconds(20L));
        logger.info("Opened Bucket");
        boolean scopeExist = b.collections().getAllScopes().stream().anyMatch(sc -> sc.name().equals(this.scopeName));
        if (!scopeExist) {
            b.collections().createScope(this.scopeName);
        }
        ConsistencyUtil.waitUntilScopePresent((Core)this.cluster.core(), (String)this.bucketName, (String)this.scopeName);
        Scope s = b.scope(this.scopeName);
        boolean collectionExist = this.bucket.collections().getAllScopes().stream().map(ScopeSpec::collections).flatMap(Collection::stream).filter(it -> it.scopeName().equals(this.scopeName)).map(CollectionSpec::name).anyMatch(this.collectionName::equals);
        if (!collectionExist) {
            b.collections().createCollection(this.scopeName, this.collectionName);
            ConsistencyUtil.waitUntilCollectionPresent((Core)this.cluster.core(), (String)this.bucketName, (String)this.scopeName, (String)this.collectionName);
            com.couchbase.client.java.Collection c = s.collection(this.collectionName);
            Mono.empty().then(Mono.fromRunnable(() -> c.async().queryIndexes().createPrimaryIndex(CreatePrimaryQueryIndexOptions.createPrimaryQueryIndexOptions().ignoreIfExists(true)))).retryWhen((Retry)RetrySpec.backoff((long)3L, (Duration)Duration.ofMillis(1000L)));
        }
        if (!(indexExist = s.searchIndexes().getAllIndexes().stream().anyMatch(idx -> this.vectorIndexName.equals(idx.name())))) {
            String jsonIndexTemplate = "  {\n  \"type\": \"fulltext-index\",\n  \"name\": \"%s\",\n  \"sourceType\": \"gocbcore\",\n  \"sourceName\": \"%s\",\n  \"planParams\": {\n    \"maxPartitionsPerPIndex\": 1024,\n    \"indexPartitions\": 1\n  },\n  \"params\": {\n    \"doc_config\": {\n      \"docid_prefix_delim\": \"\",\n      \"docid_regexp\": \"\",\n      \"mode\": \"scope.collection.type_field\",\n      \"type_field\": \"type\"\n    },\n    \"mapping\": {\n      \"analysis\": {},\n      \"default_analyzer\": \"standard\",\n      \"default_datetime_parser\": \"dateTimeOptional\",\n      \"default_field\": \"_all\",\n      \"default_mapping\": {\n        \"dynamic\": false,\n        \"enabled\": false\n      },\n      \"default_type\": \"%s\",\n      \"docvalues_dynamic\": false,\n      \"index_dynamic\": false,\n      \"store_dynamic\": false,\n      \"type_field\": \"_type\",\n      \"types\": {\n        \"%s.%s\": {\n          \"dynamic\": false,\n          \"enabled\": true,\n          \"properties\": {\n            \"embedding\": {\n              \"dynamic\": false,\n              \"enabled\": true,\n              \"fields\": [\n                {\n                  \"dims\": %s,\n                  \"index\": true,\n                  \"name\": \"embedding\",\n                  \"similarity\": \"%s\",\n                  \"type\": \"vector\",\n                  \"vector_index_optimized_for\": \"%s\"\n                }\n              ]\n            },\n            \"content\": {\n              \"dynamic\": false,\n              \"enabled\": true,\n              \"fields\": [\n                {\n                  \"analyzer\": \"keyword\",\n                  \"docvalues\": true,\n                  \"include_in_all\": true,\n                  \"include_term_vectors\": true,\n                  \"index\": true,\n                  \"name\": \"text\",\n                  \"store\": true,\n                  \"type\": \"text\"\n                }\n              ]\n            }\n          }\n        }\n      }\n    },\n    \"store\": {\n      \"indexType\": \"scorch\",\n      \"segmentVersion\": 16\n    }\n  },\n  \"sourceParams\": {}\n}\n";
            String jsonIndexValue = String.format(jsonIndexTemplate, new Object[]{this.vectorIndexName, this.bucketName, this.collectionName, this.scopeName, this.collectionName, this.dimensions, this.similarityFunction, this.indexOptimization});
            SearchIndex si = SearchIndex.fromJson((String)jsonIndexValue);
            s.searchIndexes().upsertIndex(si);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.cluster != null) {
            this.cluster.close();
            logger.info("Connection with cluster closed");
        }
    }

    public static class Builder
    extends AbstractVectorStoreBuilder<Builder> {
        private String collectionName = "_default";
        private String scopeName = "_default";
        private String bucketName = "default";
        private String vectorIndexName = "spring-ai-document-index";
        private Integer dimensions = 1536;
        private CouchbaseSimilarityFunction similarityFunction = CouchbaseSimilarityFunction.dot_product;
        private CouchbaseIndexOptimization indexOptimization = CouchbaseIndexOptimization.recall;
        private final Cluster cluster;
        private final CouchbaseAiSearchFilterExpressionConverter filterExpressionConverter = new CouchbaseAiSearchFilterExpressionConverter();
        private boolean initializeSchema = false;

        private Builder(Cluster cluster, EmbeddingModel embeddingModel) {
            super(embeddingModel);
            Assert.notNull((Object)cluster, (String)"Cluster must not be null");
            this.cluster = cluster;
        }

        public Builder initializeSchema(boolean initializeSchema) {
            this.initializeSchema = initializeSchema;
            return this;
        }

        public Builder collectionName(String collectionName) {
            Assert.notNull((Object)collectionName, (String)"Collection Name must not be null");
            Assert.notNull((Object)collectionName, (String)"Collection Name must not be empty");
            this.collectionName = collectionName;
            return this;
        }

        public Builder scopeName(String scopeName) {
            Assert.notNull((Object)scopeName, (String)"Scope Name must not be null");
            Assert.notNull((Object)scopeName, (String)"Scope Name must not be empty");
            this.scopeName = scopeName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            Assert.notNull((Object)bucketName, (String)"Bucket Name must not be null");
            Assert.notNull((Object)bucketName, (String)"Bucket Name must not be empty");
            this.bucketName = bucketName;
            return this;
        }

        public Builder vectorIndexName(String vectorIndexName) {
            Assert.notNull((Object)vectorIndexName, (String)"Vector Index Name must not be null");
            Assert.notNull((Object)vectorIndexName, (String)"Vector Index Name must not be empty");
            this.vectorIndexName = vectorIndexName;
            return this;
        }

        public Builder dimensions(Integer dimensions) {
            Assert.notNull((Object)dimensions, (String)"Dimensions must not be null");
            Assert.notNull((Object)dimensions, (String)"Dimensions must not be empty");
            this.dimensions = dimensions;
            return this;
        }

        public Builder similarityFunction(CouchbaseSimilarityFunction similarityFunction) {
            Assert.notNull((Object)((Object)similarityFunction), (String)"Couchbase Similarity Function must not be null");
            Assert.notNull((Object)((Object)similarityFunction), (String)"Couchbase Similarity Function must not be empty");
            this.similarityFunction = similarityFunction;
            return this;
        }

        public Builder indexOptimization(CouchbaseIndexOptimization indexOptimization) {
            Assert.notNull((Object)((Object)indexOptimization), (String)"Index Optimization must not be null");
            Assert.notNull((Object)((Object)indexOptimization), (String)"Index Optimization must not be empty");
            this.indexOptimization = indexOptimization;
            return this;
        }

        public CouchbaseSearchVectorStore build() {
            return new CouchbaseSearchVectorStore(this);
        }
    }

    public record CouchbaseDocument(String id, String content, Map<String, Object> metadata, float[] embedding) {
    }
}

