/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client;

import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.util.Assert;

public record ChatClientRequest(Prompt prompt, Map<String, @Nullable Object> context) {
    public ChatClientRequest {
        Assert.notNull((Object)prompt, (String)"prompt cannot be null");
        Assert.notNull(context, (String)"context cannot be null");
        Assert.noNullElements(context.keySet(), (String)"context keys cannot be null");
    }

    public ChatClientRequest copy() {
        return new ChatClientRequest(this.prompt.copy(), new HashMap<String, Object>(this.context));
    }

    public Builder mutate() {
        return new Builder().prompt(this.prompt.copy()).context(new HashMap<String, Object>(this.context));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private @Nullable Prompt prompt;
        private final Map<String, @Nullable Object> context = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder prompt(Prompt prompt) {
            Assert.notNull((Object)prompt, (String)"prompt cannot be null");
            this.prompt = prompt;
            return this;
        }

        public Builder context(Map<String, ? extends @Nullable Object> context) {
            Assert.notNull(context, (String)"context cannot be null");
            this.context.putAll(context);
            return this;
        }

        public Builder context(String key, @Nullable Object value) {
            Assert.notNull((Object)key, (String)"key cannot be null");
            this.context.put(key, value);
            return this;
        }

        public ChatClientRequest build() {
            Assert.state((this.prompt != null ? 1 : 0) != 0, (String)"prompt cannot be null");
            return new ChatClientRequest(this.prompt, this.context);
        }
    }
}

