/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public record AdvisedResponse(@Nullable ChatResponse response, Map<String, Object> adviseContext) {
    public AdvisedResponse {
        Assert.notNull(adviseContext, (String)"adviseContext cannot be null");
        Assert.noNullElements(adviseContext.keySet(), (String)"adviseContext keys cannot be null");
        Assert.noNullElements(adviseContext.values(), (String)"adviseContext values cannot be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(AdvisedResponse advisedResponse) {
        Assert.notNull((Object)advisedResponse, (String)"advisedResponse cannot be null");
        return new Builder().response(advisedResponse.response).adviseContext(advisedResponse.adviseContext);
    }

    public AdvisedResponse updateContext(Function<Map<String, Object>, Map<String, Object>> contextTransform) {
        Assert.notNull(contextTransform, (String)"contextTransform cannot be null");
        return new AdvisedResponse(this.response, Collections.unmodifiableMap(contextTransform.apply(new HashMap<String, Object>(this.adviseContext))));
    }

    public static final class Builder {
        @Nullable
        private ChatResponse response;
        private Map<String, Object> adviseContext;

        private Builder() {
        }

        public Builder response(@Nullable ChatResponse response) {
            this.response = response;
            return this;
        }

        public Builder adviseContext(Map<String, Object> adviseContext) {
            this.adviseContext = adviseContext;
            return this;
        }

        public AdvisedResponse build() {
            return new AdvisedResponse(this.response, this.adviseContext);
        }
    }
}

