/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor;

import java.util.List;
import org.springframework.ai.chat.client.advisor.api.AdvisedRequest;
import org.springframework.ai.chat.client.advisor.api.AdvisedResponse;
import org.springframework.ai.chat.client.advisor.api.CallAroundAdvisor;
import org.springframework.ai.chat.client.advisor.api.CallAroundAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisor;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisorChain;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

public class SafeGuardAdvisor
implements CallAroundAdvisor,
StreamAroundAdvisor {
    private static final String DEFAULT_FAILURE_RESPONSE = "I'm unable to respond to that due to sensitive content. Could we rephrase or discuss something else?";
    private static final int DEFAULT_ORDER = 0;
    private final String failureResponse;
    private final List<String> sensitiveWords;
    private final int order;

    public SafeGuardAdvisor(List<String> sensitiveWords) {
        this(sensitiveWords, DEFAULT_FAILURE_RESPONSE, 0);
    }

    public SafeGuardAdvisor(List<String> sensitiveWords, String failureResponse, int order) {
        Assert.notNull(sensitiveWords, (String)"Sensitive words must not be null!");
        Assert.notNull((Object)failureResponse, (String)"Failure response must not be null!");
        this.sensitiveWords = sensitiveWords;
        this.failureResponse = failureResponse;
        this.order = order;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public AdvisedResponse aroundCall(AdvisedRequest advisedRequest, CallAroundAdvisorChain chain) {
        if (!CollectionUtils.isEmpty(this.sensitiveWords) && this.sensitiveWords.stream().anyMatch(w -> advisedRequest.userText().contains((CharSequence)w))) {
            return this.createFailureResponse(advisedRequest);
        }
        return chain.nextAroundCall(advisedRequest);
    }

    @Override
    public Flux<AdvisedResponse> aroundStream(AdvisedRequest advisedRequest, StreamAroundAdvisorChain chain) {
        if (!CollectionUtils.isEmpty(this.sensitiveWords) && this.sensitiveWords.stream().anyMatch(w -> advisedRequest.userText().contains((CharSequence)w))) {
            return Flux.just((Object)this.createFailureResponse(advisedRequest));
        }
        return chain.nextAroundStream(advisedRequest);
    }

    private AdvisedResponse createFailureResponse(AdvisedRequest advisedRequest) {
        return new AdvisedResponse(ChatResponse.builder().generations(List.of(new Generation(new AssistantMessage(this.failureResponse)))).build(), advisedRequest.adviseContext());
    }

    public int getOrder() {
        return this.order;
    }

    public static final class Builder {
        private List<String> sensitiveWords;
        private String failureResponse = "I'm unable to respond to that due to sensitive content. Could we rephrase or discuss something else?";
        private int order = 0;

        private Builder() {
        }

        public Builder sensitiveWords(List<String> sensitiveWords) {
            this.sensitiveWords = sensitiveWords;
            return this;
        }

        public Builder failureResponse(String failureResponse) {
            this.failureResponse = failureResponse;
            return this;
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public SafeGuardAdvisor build() {
            return new SafeGuardAdvisor(this.sensitiveWords, this.failureResponse, this.order);
        }
    }
}

