/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.ai.chat.client.advisor.AbstractChatMemoryAdvisor;
import org.springframework.ai.chat.client.advisor.api.AdvisedRequest;
import org.springframework.ai.chat.client.advisor.api.AdvisedResponse;
import org.springframework.ai.chat.client.advisor.api.CallAroundAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisorChain;
import org.springframework.ai.chat.memory.ChatMemory;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.model.MessageAggregator;
import reactor.core.publisher.Flux;

public class PromptChatMemoryAdvisor
extends AbstractChatMemoryAdvisor<ChatMemory> {
    private static final String DEFAULT_SYSTEM_TEXT_ADVISE = "\nUse the conversation memory from the MEMORY section to provide accurate answers.\n\n---------------------\nMEMORY:\n{memory}\n---------------------\n\n";
    private final String systemTextAdvise;

    public PromptChatMemoryAdvisor(ChatMemory chatMemory) {
        this(chatMemory, DEFAULT_SYSTEM_TEXT_ADVISE);
    }

    public PromptChatMemoryAdvisor(ChatMemory chatMemory, String systemTextAdvise) {
        super(chatMemory);
        this.systemTextAdvise = systemTextAdvise;
    }

    public PromptChatMemoryAdvisor(ChatMemory chatMemory, String defaultConversationId, int chatHistoryWindowSize, String systemTextAdvise) {
        this(chatMemory, defaultConversationId, chatHistoryWindowSize, systemTextAdvise, -2147482648);
    }

    public PromptChatMemoryAdvisor(ChatMemory chatMemory, String defaultConversationId, int chatHistoryWindowSize, String systemTextAdvise, int order) {
        super(chatMemory, defaultConversationId, chatHistoryWindowSize, true, order);
        this.systemTextAdvise = systemTextAdvise;
    }

    public static Builder builder(ChatMemory chatMemory) {
        return new Builder(chatMemory);
    }

    @Override
    public AdvisedResponse aroundCall(AdvisedRequest advisedRequest, CallAroundAdvisorChain chain) {
        advisedRequest = this.before(advisedRequest);
        AdvisedResponse advisedResponse = chain.nextAroundCall(advisedRequest);
        this.observeAfter(advisedResponse);
        return advisedResponse;
    }

    @Override
    public Flux<AdvisedResponse> aroundStream(AdvisedRequest advisedRequest, StreamAroundAdvisorChain chain) {
        Flux<AdvisedResponse> advisedResponses = this.doNextWithProtectFromBlockingBefore(advisedRequest, chain, this::before);
        return new MessageAggregator().aggregateAdvisedResponse(advisedResponses, this::observeAfter);
    }

    private AdvisedRequest before(AdvisedRequest request) {
        List<Message> memoryMessages = ((ChatMemory)this.getChatMemoryStore()).get(this.doGetConversationId(request.adviseContext()), this.doGetChatMemoryRetrieveSize(request.adviseContext()));
        String memory = memoryMessages != null ? memoryMessages.stream().filter(m -> m.getMessageType() == MessageType.USER || m.getMessageType() == MessageType.ASSISTANT).map(m -> String.valueOf(m.getMessageType()) + ":" + m.getText()).collect(Collectors.joining(System.lineSeparator())) : "";
        HashMap<String, Object> advisedSystemParams = new HashMap<String, Object>(request.systemParams());
        advisedSystemParams.put("memory", memory);
        String advisedSystemText = request.systemText() + System.lineSeparator() + this.systemTextAdvise;
        AdvisedRequest advisedRequest = AdvisedRequest.from(request).systemText(advisedSystemText).systemParams(advisedSystemParams).build();
        UserMessage userMessage = new UserMessage(request.userText(), request.media());
        ((ChatMemory)this.getChatMemoryStore()).add(this.doGetConversationId(request.adviseContext()), (Message)userMessage);
        return advisedRequest;
    }

    private void observeAfter(AdvisedResponse advisedResponse) {
        List<Message> assistantMessages = advisedResponse.response().getResults().stream().map(g -> g.getOutput()).toList();
        ((ChatMemory)this.getChatMemoryStore()).add(this.doGetConversationId(advisedResponse.adviseContext()), assistantMessages);
    }

    public static class Builder
    extends AbstractChatMemoryAdvisor.AbstractBuilder<ChatMemory> {
        private String systemTextAdvise = "\nUse the conversation memory from the MEMORY section to provide accurate answers.\n\n---------------------\nMEMORY:\n{memory}\n---------------------\n\n";

        protected Builder(ChatMemory chatMemory) {
            super(chatMemory);
        }

        public Builder systemTextAdvise(String systemTextAdvise) {
            this.systemTextAdvise = systemTextAdvise;
            return this;
        }

        public PromptChatMemoryAdvisor build() {
            return new PromptChatMemoryAdvisor((ChatMemory)this.chatMemory, this.conversationId, this.chatMemoryRetrieveSize, this.systemTextAdvise, this.order);
        }
    }
}

