/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chroma.vectorstore;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chroma.vectorstore.ChromaApi;
import org.springframework.ai.chroma.vectorstore.ChromaFilterExpressionConverter;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentMetadata;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.EmbeddingOptionsBuilder;
import org.springframework.ai.observation.conventions.VectorStoreProvider;
import org.springframework.ai.util.JacksonUtils;
import org.springframework.ai.vectorstore.AbstractVectorStoreBuilder;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionConverter;
import org.springframework.ai.vectorstore.observation.AbstractObservationVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ChromaVectorStore
extends AbstractObservationVectorStore
implements InitializingBean {
    public static final String DEFAULT_COLLECTION_NAME = "SpringAiCollection";
    private final ChromaApi chromaApi;
    private final String collectionName;
    private FilterExpressionConverter filterExpressionConverter;
    @Nullable
    private String collectionId;
    private final boolean initializeSchema;
    private final ObjectMapper objectMapper;
    private boolean initialized = false;
    private static final Logger logger = LoggerFactory.getLogger(ChromaVectorStore.class);

    protected ChromaVectorStore(Builder builder) {
        super((AbstractVectorStoreBuilder)builder);
        this.chromaApi = builder.chromaApi;
        this.collectionName = builder.collectionName;
        this.initializeSchema = builder.initializeSchema;
        this.filterExpressionConverter = builder.filterExpressionConverter;
        this.objectMapper = ((JsonMapper.Builder)JsonMapper.builder().addModules((Iterable)JacksonUtils.instantiateAvailableModules())).build();
        if (builder.initializeImmediately) {
            try {
                this.afterPropertiesSet();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to initialize ChromaVectorStore", e);
            }
        }
    }

    public static Builder builder(ChromaApi chromaApi, EmbeddingModel embeddingModel) {
        return new Builder(chromaApi, embeddingModel);
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.initialized) {
            ChromaApi.Collection collection = this.chromaApi.getCollection(this.collectionName);
            if (collection == null) {
                if (this.initializeSchema) {
                    collection = this.chromaApi.createCollection(new ChromaApi.CreateCollectionRequest(this.collectionName));
                } else {
                    throw new RuntimeException("Collection " + this.collectionName + " doesn't exist and won't be created as the initializeSchema is set to false.");
                }
            }
            if (collection != null) {
                this.collectionId = collection.id();
            }
            this.initialized = true;
        }
    }

    public void doAdd(@NonNull List<Document> documents) {
        Assert.notNull(documents, (String)"Documents must not be null");
        if (CollectionUtils.isEmpty(documents)) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<Map<String, Object>> metadatas = new ArrayList<Map<String, Object>>();
        ArrayList<String> contents = new ArrayList<String>();
        ArrayList<float[]> embeddings = new ArrayList<float[]>();
        List documentEmbeddings = this.embeddingModel.embed(documents, EmbeddingOptionsBuilder.builder().build(), this.batchingStrategy);
        for (Document document : documents) {
            ids.add(document.getId());
            metadatas.add(document.getMetadata());
            contents.add(document.getText());
            embeddings.add((float[])documentEmbeddings.get(documents.indexOf(document)));
        }
        this.chromaApi.upsertEmbeddings(this.collectionId, new ChromaApi.AddEmbeddingsRequest(ids, embeddings, metadatas, contents));
    }

    public void doDelete(List<String> idList) {
        Assert.notNull(idList, (String)"Document id list must not be null");
        this.chromaApi.deleteEmbeddings(this.collectionId, new ChromaApi.DeleteEmbeddingsRequest(idList));
    }

    protected void doDelete(Filter.Expression expression) {
        Assert.notNull((Object)expression, (String)"Filter expression must not be null");
        try {
            ChromaFilterExpressionConverter converter = new ChromaFilterExpressionConverter();
            String whereClauseStr = converter.convertExpression(expression);
            Map<String, Object> whereClause = this.chromaApi.where(whereClauseStr);
            logger.debug("Deleting with where clause: " + String.valueOf(whereClause));
            ChromaApi.DeleteEmbeddingsRequest deleteRequest = new ChromaApi.DeleteEmbeddingsRequest(null, whereClause);
            this.chromaApi.deleteEmbeddings(this.collectionId, deleteRequest);
        }
        catch (Exception e) {
            logger.error("Failed to delete documents by filter: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException("Failed to delete documents by filter", e);
        }
    }

    @NonNull
    public List<Document> doSimilaritySearch(@NonNull SearchRequest request) {
        String query = request.getQuery();
        Assert.notNull((Object)query, (String)"Query string must not be null");
        float[] embedding = this.embeddingModel.embed(query);
        Map<String, Object> where = request.getFilterExpression() != null ? this.jsonToMap(this.filterExpressionConverter.convertExpression(request.getFilterExpression())) : null;
        ChromaApi.QueryRequest queryRequest = new ChromaApi.QueryRequest(embedding, request.getTopK(), where);
        ChromaApi.QueryResponse queryResponse = this.chromaApi.queryCollection(this.collectionId, queryRequest);
        List<ChromaApi.Embedding> embeddings = this.chromaApi.toEmbeddingResponseList(queryResponse);
        ArrayList<Document> responseDocuments = new ArrayList<Document>();
        for (ChromaApi.Embedding chromaEmbedding : embeddings) {
            float distance = chromaEmbedding.distances().floatValue();
            if (!((double)(1.0f - distance) >= request.getSimilarityThreshold())) continue;
            String id = chromaEmbedding.id();
            String content = chromaEmbedding.document();
            Map<String, Object> metadata = chromaEmbedding.metadata();
            if (metadata == null) {
                metadata = new HashMap<String, Object>();
            }
            metadata.put(DocumentMetadata.DISTANCE.value(), Float.valueOf(distance));
            Document document = Document.builder().id(id).text(content).metadata(metadata).score(Double.valueOf(1.0 - (double)distance)).build();
            responseDocuments.add(document);
        }
        return responseDocuments;
    }

    private Map<String, Object> jsonToMap(String jsonText) {
        try {
            return (Map)this.objectMapper.readValue(jsonText, Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public VectorStoreObservationContext.Builder createObservationContextBuilder(String operationName) {
        return VectorStoreObservationContext.builder((String)VectorStoreProvider.CHROMA.value(), (String)operationName).dimensions(Integer.valueOf(this.embeddingModel.dimensions())).collectionName(this.collectionName + ":" + this.collectionId);
    }

    public static class Builder
    extends AbstractVectorStoreBuilder<Builder> {
        private final ChromaApi chromaApi;
        private String collectionName = "SpringAiCollection";
        private boolean initializeSchema = false;
        private FilterExpressionConverter filterExpressionConverter = new ChromaFilterExpressionConverter();
        private boolean initializeImmediately = false;

        private Builder(ChromaApi chromaApi, EmbeddingModel embeddingModel) {
            super(embeddingModel);
            Assert.notNull((Object)chromaApi, (String)"ChromaApi must not be null");
            this.chromaApi = chromaApi;
        }

        public Builder collectionName(String collectionName) {
            Assert.hasText((String)collectionName, (String)"collectionName must not be null or empty");
            this.collectionName = collectionName;
            return this;
        }

        public Builder initializeSchema(boolean initializeSchema) {
            this.initializeSchema = initializeSchema;
            return this;
        }

        public Builder filterExpressionConverter(FilterExpressionConverter converter) {
            Assert.notNull((Object)converter, (String)"filterExpressionConverter must not be null");
            this.filterExpressionConverter = converter;
            return this;
        }

        public Builder initializeImmediately(boolean initialize) {
            this.initializeImmediately = initialize;
            return this;
        }

        public ChromaVectorStore build() {
            return new ChromaVectorStore(this);
        }
    }
}

