/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.IndexMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.api.querybuilder.BuildableQuery;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.delete.DeleteSelection;
import com.datastax.oss.driver.api.querybuilder.insert.InsertInto;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableAddColumnEnd;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableStart;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentMetadata;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.EmbeddingOptionsBuilder;
import org.springframework.ai.model.EmbeddingUtils;
import org.springframework.ai.observation.conventions.VectorStoreProvider;
import org.springframework.ai.observation.conventions.VectorStoreSimilarityMetric;
import org.springframework.ai.vectorstore.AbstractVectorStoreBuilder;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.cassandra.CassandraFilterExpressionConverter;
import org.springframework.ai.vectorstore.cassandra.SchemaUtil;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionConverter;
import org.springframework.ai.vectorstore.observation.AbstractObservationVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContext;
import org.springframework.util.Assert;

public class CassandraVectorStore
extends AbstractObservationVectorStore
implements AutoCloseable {
    public static final String DEFAULT_KEYSPACE_NAME = "springframework";
    public static final String DEFAULT_TABLE_NAME = "ai_vector_store";
    public static final String DEFAULT_ID_NAME = "id";
    public static final String DEFAULT_INDEX_SUFFIX = "idx";
    public static final String DEFAULT_CONTENT_COLUMN_NAME = "content";
    public static final String DEFAULT_EMBEDDING_COLUMN_NAME = "embedding";
    public static final int DEFAULT_ADD_CONCURRENCY = 16;
    public static final String DRIVER_PROFILE_UPDATES = "spring-ai-updates";
    public static final String DRIVER_PROFILE_SEARCH = "spring-ai-search";
    private static final String QUERY_FORMAT = "select %s,%s,%s%s from %s.%s ? order by %s ann of ? limit ?";
    private static final Logger logger = LoggerFactory.getLogger(CassandraVectorStore.class);
    private static final Map<Similarity, VectorStoreSimilarityMetric> SIMILARITY_TYPE_MAPPING = Map.of(Similarity.COSINE, VectorStoreSimilarityMetric.COSINE, Similarity.EUCLIDEAN, VectorStoreSimilarityMetric.EUCLIDEAN, Similarity.DOT_PRODUCT, VectorStoreSimilarityMetric.DOT);
    private final CqlSession session;
    private final Schema schema;
    private final boolean initializeSchema;
    private final FilterExpressionConverter filterExpressionConverter;
    private final DocumentIdTranslator documentIdTranslator;
    private final PrimaryKeyTranslator primaryKeyTranslator;
    private final Executor executor;
    private final boolean closeSessionOnClose;
    private final ConcurrentMap<Set<String>, PreparedStatement> addStmts = new ConcurrentHashMap<Set<String>, PreparedStatement>();
    private final PreparedStatement deleteStmt;
    private final String similarityStmt;
    private final Similarity similarity;

    protected CassandraVectorStore(Builder builder) {
        super((AbstractVectorStoreBuilder)builder);
        Assert.notNull((Object)builder.session, (String)"Session must not be null");
        this.session = builder.session;
        this.schema = builder.buildSchema();
        this.initializeSchema = builder.initializeSchema;
        this.documentIdTranslator = builder.documentIdTranslator;
        this.primaryKeyTranslator = builder.primaryKeyTranslator;
        this.executor = Executors.newFixedThreadPool(builder.fixedThreadPoolExecutorSize);
        this.closeSessionOnClose = builder.closeSessionOnClose;
        this.ensureSchemaExists(this.embeddingModel.dimensions());
        this.prepareAddStatement(Set.of());
        this.deleteStmt = this.prepareDeleteStatement();
        TableMetadata cassandraMetadata = (TableMetadata)((KeyspaceMetadata)this.session.getMetadata().getKeyspace(this.schema.keyspace()).get()).getTable(this.schema.table()).get();
        this.similarity = this.getIndexSimilarity(cassandraMetadata);
        this.similarityStmt = this.similaritySearchStatement();
        this.filterExpressionConverter = builder.filterExpressionConverter != null ? builder.filterExpressionConverter : new CassandraFilterExpressionConverter(cassandraMetadata.getColumns().values());
    }

    public static Builder builder(EmbeddingModel embeddingModel) {
        return new Builder(embeddingModel);
    }

    private static Float[] toFloatArray(float[] embedding) {
        Float[] embeddingFloat = new Float[embedding.length];
        int i = 0;
        float[] fArray = embedding;
        int n = fArray.length;
        for (int j = 0; j < n; ++j) {
            Float d = Float.valueOf(fArray[j]);
            embeddingFloat[i++] = Float.valueOf(d.floatValue());
        }
        return embeddingFloat;
    }

    public void doAdd(List<Document> documents) {
        CompletableFuture[] futures = new CompletableFuture[documents.size()];
        List embeddings = this.embeddingModel.embed(documents, EmbeddingOptionsBuilder.builder().build(), this.batchingStrategy);
        int i = 0;
        for (Document d : documents) {
            futures[i++] = CompletableFuture.runAsync(() -> {
                List primaryKeyValues = (List)this.documentIdTranslator.apply(d.getId());
                BoundStatementBuilder builder = this.prepareAddStatement(d.getMetadata().keySet()).boundStatementBuilder(new Object[0]);
                for (int k = 0; k < primaryKeyValues.size(); ++k) {
                    SchemaColumn keyColumn = this.getPrimaryKeyColumn(k);
                    builder = (BoundStatementBuilder)builder.set(keyColumn.name(), primaryKeyValues.get(k), keyColumn.javaType());
                }
                builder = (BoundStatementBuilder)((BoundStatementBuilder)builder.setString(this.schema.content(), d.getText())).setVector(this.schema.embedding(), CqlVector.newInstance((List)EmbeddingUtils.toList((float[])((float[])embeddings.get(documents.indexOf(d))))), Float.class);
                for (SchemaColumn metadataColumn : this.schema.metadataColumns().stream().filter(mc -> d.getMetadata().containsKey(mc.name())).toList()) {
                    builder = (BoundStatementBuilder)builder.set(metadataColumn.name(), d.getMetadata().get(metadataColumn.name()), metadataColumn.javaType());
                }
                BoundStatement s = (BoundStatement)builder.build().setExecutionProfileName(DRIVER_PROFILE_UPDATES);
                this.session.execute((Statement)s);
            }, this.executor);
        }
        CompletableFuture.allOf(futures).join();
    }

    public void doDelete(List<String> idList) {
        CompletableFuture[] futures = new CompletableFuture[idList.size()];
        int i = 0;
        for (String id : idList) {
            List primaryKeyValues = (List)this.documentIdTranslator.apply(id);
            BoundStatement s = this.deleteStmt.bind(primaryKeyValues.toArray());
            futures[i++] = this.session.executeAsync((Statement)s).toCompletableFuture();
        }
        CompletableFuture.allOf(futures).join();
    }

    protected void doDelete(Filter.Expression filterExpression) {
        Assert.notNull((Object)filterExpression, (String)"Filter expression must not be null");
        try {
            SearchRequest searchRequest = SearchRequest.builder().query("").filterExpression(filterExpression).topK(1000).similarityThresholdAll().build();
            List matchingDocs = this.similaritySearch(searchRequest);
            if (!matchingDocs.isEmpty()) {
                List idsToDelete = matchingDocs.stream().map(Document::getId).collect(Collectors.toList());
                this.delete(idsToDelete);
                logger.debug("Deleted {} documents matching filter expression", (Object)idsToDelete.size());
            }
        }
        catch (Exception e) {
            logger.error("Failed to delete documents by filter", (Throwable)e);
            throw new IllegalStateException("Failed to delete documents by filter", e);
        }
    }

    public List<Document> doSimilaritySearch(SearchRequest request) {
        Row row;
        float score;
        String expression;
        Preconditions.checkArgument((request.getTopK() <= 1000 ? 1 : 0) != 0);
        Number[] embedding = CassandraVectorStore.toFloatArray(this.embeddingModel.embed(request.getQuery()));
        CqlVector cqlVector = CqlVector.newInstance((Number[])embedding);
        String whereClause = "";
        if (request.hasFilterExpression() && !(expression = this.filterExpressionConverter.convertExpression(request.getFilterExpression())).isBlank()) {
            whereClause = String.format("where %s", expression);
        }
        String query = String.format(this.similarityStmt, cqlVector, whereClause, cqlVector, request.getTopK());
        ArrayList<Document> documents = new ArrayList<Document>();
        logger.trace("Executing {}", (Object)query);
        SimpleStatement s = (SimpleStatement)SimpleStatement.newInstance((String)query).setExecutionProfileName(DRIVER_PROFILE_SEARCH);
        Iterator iterator = this.session.execute((Statement)s).iterator();
        while (iterator.hasNext() && !((double)(score = (row = (Row)iterator.next()).getFloat(0)) < request.getSimilarityThreshold())) {
            HashMap<String, Object> docFields = new HashMap<String, Object>();
            docFields.put(DocumentMetadata.DISTANCE.value(), Float.valueOf(1.0f - score));
            for (SchemaColumn metadata : this.schema.metadataColumns()) {
                Object value = row.get(metadata.name(), metadata.javaType());
                if (null == value) continue;
                docFields.put(metadata.name(), value);
            }
            Document doc = Document.builder().id(this.getDocumentId(row)).text(row.getString(this.schema.content())).metadata(docFields).score(Double.valueOf(score)).build();
            documents.add(doc);
        }
        return documents;
    }

    void checkSchemaValid() {
        this.checkSchemaValid(this.embeddingModel.dimensions());
    }

    private Similarity getIndexSimilarity(TableMetadata metadata) {
        return Similarity.valueOf(((IndexMetadata)metadata.getIndex(this.schema.index()).get()).getOptions().getOrDefault("similarity_function", "COSINE").toUpperCase());
    }

    private PreparedStatement prepareDeleteStatement() {
        DeleteSelection stmt = null;
        DeleteSelection stmtStart = QueryBuilder.deleteFrom((String)this.schema.keyspace(), (String)this.schema.table());
        for (SchemaColumn c : this.schema.partitionKeys()) {
            stmt = (Delete)(null != stmt ? stmt : stmtStart).whereColumn(c.name()).isEqualTo((Term)QueryBuilder.bindMarker((String)c.name()));
        }
        for (SchemaColumn c : this.schema.clusteringKeys()) {
            stmt = (Delete)stmt.whereColumn(c.name()).isEqualTo((Term)QueryBuilder.bindMarker((String)c.name()));
        }
        return this.session.prepare(stmt.build());
    }

    private PreparedStatement prepareAddStatement(Set<String> metadataFields) {
        HashSet<String> fieldsThatAreColumns = new HashSet<String>(this.schema.metadataColumns().stream().map(mc -> mc.name()).filter(mc -> metadataFields.contains(mc)).toList());
        return this.addStmts.computeIfAbsent(fieldsThatAreColumns, fields -> {
            InsertInto stmt = null;
            InsertInto stmtStart = QueryBuilder.insertInto((String)this.schema.keyspace(), (String)this.schema.table());
            for (SchemaColumn c : this.schema.partitionKeys()) {
                stmt = (null != stmt ? stmt : stmtStart).value(c.name(), (Term)QueryBuilder.bindMarker((String)c.name()));
            }
            for (SchemaColumn c : this.schema.clusteringKeys()) {
                stmt = stmt.value(c.name(), (Term)QueryBuilder.bindMarker((String)c.name()));
            }
            stmt = stmt.value(this.schema.content(), (Term)QueryBuilder.bindMarker((String)this.schema.content())).value(this.schema.embedding(), (Term)QueryBuilder.bindMarker((String)this.schema.embedding()));
            for (String metadataField : fields) {
                stmt = stmt.value(metadataField, (Term)QueryBuilder.bindMarker((String)metadataField));
            }
            return this.session.prepare(stmt.build());
        });
    }

    private String similaritySearchStatement() {
        StringBuilder ids = new StringBuilder();
        for (SchemaColumn m : this.schema.partitionKeys()) {
            ids.append(m.name()).append(',');
        }
        for (SchemaColumn m : this.schema.clusteringKeys()) {
            ids.append(m.name()).append(',');
        }
        ids.deleteCharAt(ids.length() - 1);
        String similarityFunction = "similarity_" + this.similarity.toString().toLowerCase() + '(' + this.schema.embedding() + ",?)";
        StringBuilder extraSelectFields = new StringBuilder();
        for (SchemaColumn m : this.schema.metadataColumns()) {
            extraSelectFields.append(',').append(m.name());
        }
        String query = String.format(QUERY_FORMAT, similarityFunction, ids.toString(), this.schema.content(), extraSelectFields.toString(), this.schema.keyspace(), this.schema.table(), this.schema.embedding());
        query = query.replace("?", "%s");
        logger.debug("preparing {}", (Object)query);
        return query;
    }

    private String getDocumentId(Row row) {
        ArrayList<Object> primaryKeyValues = new ArrayList<Object>();
        for (SchemaColumn m : this.schema.partitionKeys()) {
            primaryKeyValues.add(row.get(m.name(), m.javaType()));
        }
        for (SchemaColumn m : this.schema.clusteringKeys()) {
            primaryKeyValues.add(row.get(m.name(), m.javaType()));
        }
        return (String)this.primaryKeyTranslator.apply(primaryKeyValues);
    }

    public VectorStoreObservationContext.Builder createObservationContextBuilder(String operationName) {
        return VectorStoreObservationContext.builder((String)VectorStoreProvider.CASSANDRA.value(), (String)operationName).collectionName(this.schema.table()).dimensions(Integer.valueOf(this.embeddingModel.dimensions())).namespace(this.schema.keyspace()).similarityMetric(this.getSimilarityMetric());
    }

    private String getSimilarityMetric() {
        if (!SIMILARITY_TYPE_MAPPING.containsKey((Object)this.similarity)) {
            return this.similarity.name();
        }
        return SIMILARITY_TYPE_MAPPING.get((Object)this.similarity).value();
    }

    @Override
    public void close() throws Exception {
        if (this.closeSessionOnClose) {
            this.session.close();
        }
    }

    SchemaColumn getPrimaryKeyColumn(int index) {
        return index < this.schema.partitionKeys().size() ? this.schema.partitionKeys().get(index) : this.schema.clusteringKeys().get(index - this.schema.partitionKeys().size());
    }

    @VisibleForTesting
    static void dropKeyspace(Builder builder) {
        Preconditions.checkState((boolean)builder.keyspace.startsWith("test_"), (Object)"Only test keyspaces can be dropped");
        builder.session.execute((Statement)SchemaBuilder.dropKeyspace((String)builder.keyspace).ifExists().build());
    }

    void ensureSchemaExists(int vectorDimension) {
        if (this.initializeSchema) {
            SchemaUtil.ensureKeyspaceExists(this.session, this.schema.keyspace);
            this.ensureTableExists(vectorDimension);
            this.ensureTableColumnsExist(vectorDimension);
            this.ensureIndexesExists();
            SchemaUtil.checkSchemaAgreement(this.session);
        } else {
            this.checkSchemaValid(vectorDimension);
        }
    }

    void checkSchemaValid(int vectorDimension) {
        Preconditions.checkState((boolean)this.session.getMetadata().getKeyspace(this.schema.keyspace).isPresent(), (String)"keyspace %s does not exist", (Object)this.schema.keyspace);
        Preconditions.checkState((boolean)((KeyspaceMetadata)this.session.getMetadata().getKeyspace(this.schema.keyspace).get()).getTable(this.schema.table).isPresent(), (String)"table %s does not exist", (Object)this.schema.table);
        TableMetadata tableMetadata = (TableMetadata)((KeyspaceMetadata)this.session.getMetadata().getKeyspace(this.schema.keyspace).get()).getTable(this.schema.table).get();
        Preconditions.checkState((boolean)tableMetadata.getColumn(this.schema.content).isPresent(), (String)"column %s does not exist", (Object)this.schema.content);
        Preconditions.checkState((boolean)tableMetadata.getColumn(this.schema.embedding).isPresent(), (String)"column %s does not exist", (Object)this.schema.embedding);
        for (SchemaColumn m : this.schema.metadataColumns) {
            Optional column = tableMetadata.getColumn(m.name());
            Preconditions.checkState((boolean)column.isPresent(), (String)"column %s does not exist", (Object)m.name());
            Preconditions.checkArgument((boolean)((ColumnMetadata)column.get()).getType().equals(m.type()), (String)"Mismatching type on metadata column %s of %s vs %s", (Object)m.name(), (Object)((ColumnMetadata)column.get()).getType(), (Object)m.type());
            if (!m.indexed()) continue;
            Preconditions.checkState((boolean)tableMetadata.getIndexes().values().stream().anyMatch(i -> i.getTarget().equals(m.name())), (String)"index %s does not exist", (Object)m.name());
        }
    }

    private void ensureIndexesExists() {
        SimpleStatement indexStmt = SchemaBuilder.createIndex((String)this.schema.index).ifNotExists().custom("StorageAttachedIndex").onTable(this.schema.keyspace, this.schema.table).andColumn(this.schema.embedding).build();
        logger.debug("Executing {}", (Object)indexStmt.getQuery());
        this.session.execute((Statement)indexStmt);
        Stream.concat(this.schema.partitionKeys.stream(), Stream.concat(this.schema.clusteringKeys.stream(), this.schema.metadataColumns.stream())).filter(cs -> cs.indexed()).forEach(metadata -> {
            SimpleStatement indexStatement = SchemaBuilder.createIndex((String)String.format("%s_idx", metadata.name())).ifNotExists().custom("StorageAttachedIndex").onTable(this.schema.keyspace, this.schema.table).andColumn(metadata.name()).build();
            logger.debug("Executing {}", (Object)indexStatement.getQuery());
            this.session.execute((Statement)indexStatement);
        });
    }

    private void ensureTableExists(int vectorDimension) {
        if (((KeyspaceMetadata)this.session.getMetadata().getKeyspace(this.schema.keyspace).get()).getTable(this.schema.table).isEmpty()) {
            CreateTableStart createTable = null;
            CreateTableStart createTableStart = SchemaBuilder.createTable((String)this.schema.keyspace, (String)this.schema.table).ifNotExists();
            for (SchemaColumn partitionKey : this.schema.partitionKeys) {
                createTable = (null != createTable ? createTable : createTableStart).withPartitionKey(partitionKey.name, partitionKey.type);
            }
            for (SchemaColumn clusteringKey : this.schema.clusteringKeys) {
                createTable = createTable.withClusteringColumn(clusteringKey.name, clusteringKey.type);
            }
            createTable = createTable.withColumn(this.schema.content, DataTypes.TEXT);
            for (SchemaColumn metadata : this.schema.metadataColumns) {
                createTable = createTable.withColumn(metadata.name(), metadata.type());
            }
            StringBuilder tableStmt = new StringBuilder(createTable.asCql());
            tableStmt.setLength(tableStmt.length() - 1);
            tableStmt.append(',').append(this.schema.embedding).append(" vector<float,").append(vectorDimension).append(">)");
            logger.debug("Executing {}", (Object)tableStmt.toString());
            this.session.execute(tableStmt.toString());
        }
    }

    private void ensureTableColumnsExist(int vectorDimension) {
        TableMetadata tableMetadata = (TableMetadata)((KeyspaceMetadata)this.session.getMetadata().getKeyspace(this.schema.keyspace).get()).getTable(this.schema.table).get();
        HashSet<SchemaColumn> newColumns = new HashSet<SchemaColumn>();
        boolean addContent = tableMetadata.getColumn(this.schema.content).isEmpty();
        boolean addEmbedding = tableMetadata.getColumn(this.schema.embedding).isEmpty();
        for (SchemaColumn schemaColumn : this.schema.metadataColumns) {
            Optional column = tableMetadata.getColumn(schemaColumn.name());
            if (column.isPresent()) {
                Preconditions.checkArgument((boolean)((ColumnMetadata)column.get()).getType().equals(schemaColumn.type()), (String)"Cannot change type on metadata column %s from %s to %s", (Object)schemaColumn.name(), (Object)((ColumnMetadata)column.get()).getType(), (Object)schemaColumn.type());
                continue;
            }
            newColumns.add(schemaColumn);
        }
        if (!newColumns.isEmpty() || addContent || addEmbedding) {
            AlterTableStart alterTable = SchemaBuilder.alterTable((String)this.schema.keyspace, (String)this.schema.table);
            for (SchemaColumn metadata : newColumns) {
                alterTable = alterTable.addColumn(metadata.name(), metadata.type());
            }
            if (addContent) {
                alterTable = alterTable.addColumn(this.schema.content, DataTypes.TEXT);
            }
            if (addEmbedding) {
                StringBuilder stringBuilder = new StringBuilder(((BuildableQuery)alterTable).asCql());
                if (newColumns.isEmpty() && !addContent) {
                    stringBuilder.append(" ADD (");
                } else {
                    stringBuilder.setLength(stringBuilder.length() - 1);
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.schema.embedding).append(" vector<float,").append(vectorDimension).append(">)");
                logger.debug("Executing {}", (Object)stringBuilder.toString());
                this.session.execute(stringBuilder.toString());
            } else {
                SimpleStatement simpleStatement = ((AlterTableAddColumnEnd)alterTable).build();
                logger.debug("Executing {}", (Object)simpleStatement.getQuery());
                this.session.execute((Statement)simpleStatement);
            }
        }
    }

    public <T> Optional<T> getNativeClient() {
        CqlSession client = this.session;
        return Optional.of(client);
    }

    public static class Builder
    extends AbstractVectorStoreBuilder<Builder> {
        private CqlSession session;
        private CqlSessionBuilder sessionBuilder;
        private boolean closeSessionOnClose;
        private String keyspace = "springframework";
        private String table = "ai_vector_store";
        private List<SchemaColumn> partitionKeys = List.of(new SchemaColumn("id", DataTypes.TEXT));
        private List<SchemaColumn> clusteringKeys = List.of();
        private String indexName;
        private String contentColumnName = "content";
        private String embeddingColumnName = "embedding";
        private Set<SchemaColumn> metadataColumns = new HashSet<SchemaColumn>();
        private boolean initializeSchema = true;
        private int fixedThreadPoolExecutorSize = 16;
        private FilterExpressionConverter filterExpressionConverter;
        private DocumentIdTranslator documentIdTranslator = id -> List.of(id);
        private PrimaryKeyTranslator primaryKeyTranslator = primaryKeyColumns -> {
            if (primaryKeyColumns.isEmpty()) {
                return "test";
            }
            Preconditions.checkArgument((1 == primaryKeyColumns.size() ? 1 : 0) != 0);
            return (String)primaryKeyColumns.get(0);
        };

        private Builder(EmbeddingModel embeddingModel) {
            super(embeddingModel);
        }

        public Builder session(CqlSession session) {
            Assert.notNull((Object)session, (String)"Session must not be null");
            this.session = session;
            return this;
        }

        public Builder fixedThreadPoolExecutorSize(int threads) {
            Preconditions.checkArgument((0 < threads ? 1 : 0) != 0);
            this.fixedThreadPoolExecutorSize = threads;
            return this;
        }

        public Builder keyspace(String keyspace) {
            Assert.hasText((String)keyspace, (String)"Keyspace must not be null or empty");
            this.keyspace = keyspace;
            return this;
        }

        public Builder contactPoint(InetSocketAddress contactPoint) {
            Assert.state((this.session == null ? 1 : 0) != 0, (String)"Cannot call addContactPoint(..) when session is already set");
            if (this.sessionBuilder == null) {
                this.sessionBuilder = new CqlSessionBuilder();
            }
            this.sessionBuilder.addContactPoint(contactPoint);
            return this;
        }

        public Builder localDatacenter(String localDatacenter) {
            Assert.state((this.session == null ? 1 : 0) != 0, (String)"Cannot call withLocalDatacenter(..) when session is already set");
            if (this.sessionBuilder == null) {
                this.sessionBuilder = new CqlSessionBuilder();
            }
            this.sessionBuilder.withLocalDatacenter(localDatacenter);
            return this;
        }

        public Builder table(String table) {
            Assert.hasText((String)table, (String)"Table must not be null or empty");
            this.table = table;
            return this;
        }

        public Builder partitionKeys(List<SchemaColumn> partitionKeys) {
            Assert.notEmpty(partitionKeys, (String)"Partition keys must not be null or empty");
            this.partitionKeys = partitionKeys;
            return this;
        }

        public Builder clusteringKeys(List<SchemaColumn> clusteringKeys) {
            this.clusteringKeys = clusteringKeys != null ? clusteringKeys : List.of();
            return this;
        }

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder initializeSchema(boolean initializeSchema) {
            this.initializeSchema = initializeSchema;
            return this;
        }

        public Builder filterExpressionConverter(FilterExpressionConverter converter) {
            Assert.notNull((Object)converter, (String)"FilterExpressionConverter must not be null");
            this.filterExpressionConverter = converter;
            return this;
        }

        public Builder documentIdTranslator(DocumentIdTranslator translator) {
            Assert.notNull((Object)translator, (String)"DocumentIdTranslator must not be null");
            this.documentIdTranslator = translator;
            return this;
        }

        public Builder contentColumnName(String contentColumnName) {
            this.contentColumnName = contentColumnName;
            return this;
        }

        public Builder embeddingColumnName(String embeddingColumnName) {
            this.embeddingColumnName = embeddingColumnName;
            return this;
        }

        public Builder addMetadataColumns(SchemaColumn ... columns) {
            Builder builder = this;
            for (SchemaColumn f : columns) {
                builder = builder.addMetadataColumn(f);
            }
            return builder;
        }

        public Builder addMetadataColumns(List<SchemaColumn> columns) {
            Builder builder = this;
            this.metadataColumns.addAll(columns);
            return builder;
        }

        public Builder addMetadataColumn(SchemaColumn column) {
            Preconditions.checkArgument((boolean)this.metadataColumns.stream().noneMatch(sc -> sc.name().equals(column.name())), (String)"A metadata column with name %s has already been added", (Object)column.name());
            this.metadataColumns.add(column);
            return this;
        }

        public Builder primaryKeyTranslator(PrimaryKeyTranslator translator) {
            Assert.notNull((Object)translator, (String)"PrimaryKeyTranslator must not be null");
            this.primaryKeyTranslator = translator;
            return this;
        }

        Schema buildSchema() {
            if (this.indexName == null) {
                this.indexName = String.format("%s_%s_%s", this.table, this.embeddingColumnName, CassandraVectorStore.DEFAULT_INDEX_SUFFIX);
            }
            this.validateSchema();
            return new Schema(this.keyspace, this.table, this.partitionKeys, this.clusteringKeys, this.contentColumnName, this.embeddingColumnName, this.indexName, this.metadataColumns);
        }

        private void validateSchema() {
            for (SchemaColumn metadata : this.metadataColumns) {
                Assert.isTrue((!this.partitionKeys.stream().anyMatch(c -> c.name().equals(metadata.name())) ? 1 : 0) != 0, (String)("metadataColumn " + metadata.name() + " cannot have same name as a partition key"));
                Assert.isTrue((!this.clusteringKeys.stream().anyMatch(c -> c.name().equals(metadata.name())) ? 1 : 0) != 0, (String)("metadataColumn " + metadata.name() + " cannot have same name as a clustering key"));
                Assert.isTrue((!metadata.name().equals(this.contentColumnName) ? 1 : 0) != 0, (String)("metadataColumn " + metadata.name() + " cannot have same name as content column name"));
                Assert.isTrue((!metadata.name().equals(this.embeddingColumnName) ? 1 : 0) != 0, (String)("metadataColumn " + metadata.name() + " cannot have same name as embedding column name"));
            }
            int primaryKeyColumnsCount = this.partitionKeys.size() + this.clusteringKeys.size();
            String exampleId = (String)this.primaryKeyTranslator.apply(Collections.emptyList());
            List testIdTranslation = (List)this.documentIdTranslator.apply(exampleId);
            Assert.isTrue((testIdTranslation.size() == primaryKeyColumnsCount ? 1 : 0) != 0, (String)("documentIdTranslator results length " + testIdTranslation.size() + " doesn't match number of primary key columns " + primaryKeyColumnsCount));
            Assert.isTrue((boolean)exampleId.equals(this.primaryKeyTranslator.apply((List)this.documentIdTranslator.apply(exampleId))), (String)"primaryKeyTranslator is not an inverse function to documentIdTranslator");
        }

        public CassandraVectorStore build() {
            if (this.session == null && this.sessionBuilder != null) {
                this.session = (CqlSession)this.sessionBuilder.build();
                this.closeSessionOnClose = true;
            }
            Assert.notNull((Object)this.session, (String)"Either session must be set directly or configured via sessionBuilder");
            return new CassandraVectorStore(this);
        }
    }

    record Schema(String keyspace, String table, List<SchemaColumn> partitionKeys, List<SchemaColumn> clusteringKeys, String content, String embedding, String index, Set<SchemaColumn> metadataColumns) {
    }

    public static interface DocumentIdTranslator
    extends Function<String, List<Object>> {
    }

    public static interface PrimaryKeyTranslator
    extends Function<List<Object>, String> {
    }

    public static enum Similarity {
        COSINE,
        DOT_PRODUCT,
        EUCLIDEAN;

    }

    public record SchemaColumn(String name, DataType type, SchemaColumnTags[] tags) {
        public SchemaColumn(String name, DataType type) {
            this(name, type, new SchemaColumnTags[0]);
        }

        public GenericType<Object> javaType() {
            return CodecRegistry.DEFAULT.codecFor(this.type).getJavaType();
        }

        public boolean indexed() {
            for (SchemaColumnTags t : this.tags) {
                if (SchemaColumnTags.INDEXED != t) continue;
                return true;
            }
            return false;
        }
    }

    public static enum SchemaColumnTags {
        INDEXED;

    }
}

