/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.memory.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableAddColumnEnd;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.cassandra.SchemaUtil;

public final class CassandraChatMemoryConfig {
    public static final String DEFAULT_KEYSPACE_NAME = "springframework";
    public static final String DEFAULT_TABLE_NAME = "ai_chat_memory";
    public static final String DEFAULT_SESSION_ID_NAME = "session_id";
    public static final String DEFAULT_EXCHANGE_ID_NAME = "message_timestamp";
    public static final String DEFAULT_ASSISTANT_COLUMN_NAME = "assistant";
    public static final String DEFAULT_USER_COLUMN_NAME = "user";
    private static final Logger logger = LoggerFactory.getLogger(CassandraChatMemoryConfig.class);
    final CqlSession session;
    final Schema schema;
    final String assistantColumn;
    final String userColumn;
    final SessionIdToPrimaryKeysTranslator primaryKeyTranslator;
    private final Integer timeToLiveSeconds;
    private final boolean disallowSchemaChanges;

    private CassandraChatMemoryConfig(Builder builder) {
        this.session = builder.session;
        this.schema = new Schema(builder.keyspace, builder.table, builder.partitionKeys, builder.clusteringKeys);
        this.assistantColumn = builder.assistantColumn;
        this.userColumn = builder.userColumn;
        this.timeToLiveSeconds = builder.timeToLiveSeconds;
        this.disallowSchemaChanges = builder.disallowSchemaChanges;
        this.primaryKeyTranslator = builder.primaryKeyTranslator;
    }

    public static Builder builder() {
        return new Builder();
    }

    SchemaColumn getPrimaryKeyColumn(int index) {
        return index < this.schema.partitionKeys().size() ? this.schema.partitionKeys().get(index) : this.schema.clusteringKeys().get(index - this.schema.partitionKeys().size());
    }

    @VisibleForTesting
    void dropKeyspace() {
        Preconditions.checkState((boolean)this.schema.keyspace.startsWith("test_"), (Object)"Only test keyspaces can be dropped");
        this.session.execute((Statement)SchemaBuilder.dropKeyspace((String)this.schema.keyspace).ifExists().build());
    }

    void ensureSchemaExists() {
        if (!this.disallowSchemaChanges) {
            SchemaUtil.ensureKeyspaceExists(this.session, this.schema.keyspace);
            this.ensureTableExists();
            this.ensureTableColumnsExist();
            SchemaUtil.checkSchemaAgreement(this.session);
        } else {
            this.checkSchemaValid();
        }
    }

    void checkSchemaValid() {
        Preconditions.checkState((boolean)this.session.getMetadata().getKeyspace(this.schema.keyspace).isPresent(), (String)"keyspace %s does not exist", (Object)this.schema.keyspace);
        Preconditions.checkState((boolean)((KeyspaceMetadata)this.session.getMetadata().getKeyspace(this.schema.keyspace).get()).getTable(this.schema.table).isPresent(), (Object)"table %s does not exist");
        TableMetadata tableMetadata = (TableMetadata)((KeyspaceMetadata)this.session.getMetadata().getKeyspace(this.schema.keyspace).get()).getTable(this.schema.table).get();
        Preconditions.checkState((boolean)tableMetadata.getColumn(this.assistantColumn).isPresent(), (String)"column %s does not exist", (Object)this.assistantColumn);
        Preconditions.checkState((boolean)tableMetadata.getColumn(this.userColumn).isPresent(), (String)"column %s does not exist", (Object)this.userColumn);
    }

    private void ensureTableExists() {
        if (((KeyspaceMetadata)this.session.getMetadata().getKeyspace(this.schema.keyspace).get()).getTable(this.schema.table).isEmpty()) {
            CreateTableStart createTable = null;
            CreateTableStart createTableStart = SchemaBuilder.createTable((String)this.schema.keyspace, (String)this.schema.table).ifNotExists();
            for (SchemaColumn partitionKey : this.schema.partitionKeys) {
                createTable = (null != createTable ? createTable : createTableStart).withPartitionKey(partitionKey.name, partitionKey.type);
            }
            for (SchemaColumn clusteringKey : this.schema.clusteringKeys) {
                createTable = createTable.withClusteringColumn(clusteringKey.name, clusteringKey.type);
            }
            String lastClusteringColumn = this.schema.clusteringKeys.get(this.schema.clusteringKeys.size() - 1).name();
            CreateTableWithOptions createTableWithOptions = (CreateTableWithOptions)((CreateTableWithOptions)createTable.withColumn(this.userColumn, DataTypes.TEXT).withClusteringOrder(lastClusteringColumn, ClusteringOrder.DESC)).withOption("compaction", Map.of("class", "UnifiedCompactionStrategy"));
            if (null != this.timeToLiveSeconds) {
                createTableWithOptions = (CreateTableWithOptions)createTableWithOptions.withDefaultTimeToLiveSeconds(this.timeToLiveSeconds.intValue());
            }
            this.session.execute((Statement)createTableWithOptions.build());
        }
    }

    private void ensureTableColumnsExist() {
        TableMetadata tableMetadata = (TableMetadata)((KeyspaceMetadata)this.session.getMetadata().getKeyspace(this.schema.keyspace()).get()).getTable(this.schema.table()).get();
        boolean addAssistantColumn = tableMetadata.getColumn(this.assistantColumn).isEmpty();
        boolean addUserColumn = tableMetadata.getColumn(this.userColumn).isEmpty();
        if (addAssistantColumn || addUserColumn) {
            AlterTableStart alterTable = SchemaBuilder.alterTable((String)this.schema.keyspace(), (String)this.schema.table());
            if (addAssistantColumn) {
                alterTable = alterTable.addColumn(this.assistantColumn, DataTypes.TEXT);
            }
            if (addUserColumn) {
                alterTable = alterTable.addColumn(this.userColumn, DataTypes.TEXT);
            }
            SimpleStatement stmt = ((AlterTableAddColumnEnd)alterTable).build();
            logger.debug("Executing {}", (Object)stmt.getQuery());
            this.session.execute((Statement)stmt);
        }
    }

    public static final class Builder {
        private CqlSession session = null;
        private CqlSessionBuilder sessionBuilder = null;
        private String keyspace = "springframework";
        private String table = "ai_chat_memory";
        private List<SchemaColumn> partitionKeys = List.of(new SchemaColumn("session_id", DataTypes.TEXT));
        private List<SchemaColumn> clusteringKeys = List.of(new SchemaColumn("message_timestamp", DataTypes.TIMESTAMP));
        private String assistantColumn = "assistant";
        private String userColumn = "user";
        private Integer timeToLiveSeconds = null;
        private boolean disallowSchemaChanges = false;
        private SessionIdToPrimaryKeysTranslator primaryKeyTranslator = List::of;

        private Builder() {
        }

        public Builder withCqlSession(CqlSession session) {
            Preconditions.checkState((null == this.sessionBuilder ? 1 : 0) != 0, (Object)"Cannot call withContactPoint(..) or withLocalDatacenter(..) and this method");
            this.session = session;
            return this;
        }

        public Builder addContactPoint(InetSocketAddress contactPoint) {
            Preconditions.checkState((null == this.session ? 1 : 0) != 0, (Object)"Cannot call withCqlSession(..) and this method");
            if (null == this.sessionBuilder) {
                this.sessionBuilder = new CqlSessionBuilder();
            }
            this.sessionBuilder.addContactPoint(contactPoint);
            return this;
        }

        public Builder withLocalDatacenter(String localDC) {
            Preconditions.checkState((null == this.session ? 1 : 0) != 0, (Object)"Cannot call withCqlSession(..) and this method");
            if (null == this.sessionBuilder) {
                this.sessionBuilder = new CqlSessionBuilder();
            }
            this.sessionBuilder.withLocalDatacenter(localDC);
            return this;
        }

        public Builder withKeyspaceName(String keyspace) {
            this.keyspace = keyspace;
            return this;
        }

        public Builder withTableName(String table) {
            this.table = table;
            return this;
        }

        public Builder withPartitionKeys(List<SchemaColumn> partitionKeys) {
            Preconditions.checkArgument((!partitionKeys.isEmpty() ? 1 : 0) != 0);
            this.partitionKeys = partitionKeys;
            return this;
        }

        public Builder withClusteringKeys(List<SchemaColumn> clusteringKeys) {
            Preconditions.checkArgument((!clusteringKeys.isEmpty() ? 1 : 0) != 0);
            this.clusteringKeys = clusteringKeys;
            return this;
        }

        public Builder withAssistantColumnName(String name) {
            this.assistantColumn = name;
            return this;
        }

        public Builder withUserColumnName(String name) {
            this.userColumn = name;
            return this;
        }

        public Builder withTimeToLive(Duration timeToLive) {
            Preconditions.checkArgument((0L < timeToLive.getSeconds() ? 1 : 0) != 0);
            this.timeToLiveSeconds = (int)timeToLive.toSeconds();
            return this;
        }

        public Builder disallowSchemaChanges() {
            this.disallowSchemaChanges = true;
            return this;
        }

        public Builder withChatExchangeToPrimaryKeyTranslator(SessionIdToPrimaryKeysTranslator primaryKeyTranslator) {
            this.primaryKeyTranslator = primaryKeyTranslator;
            return this;
        }

        public CassandraChatMemoryConfig build() {
            int primaryKeysToBind;
            int primaryKeyColumns = this.partitionKeys.size() + this.clusteringKeys.size();
            Preconditions.checkArgument((primaryKeyColumns == (primaryKeysToBind = ((List)this.primaryKeyTranslator.apply(UUID.randomUUID().toString())).size()) + 1 ? 1 : 0) != 0, (Object)"The primaryKeyTranslator must always return one less element than the number of primary keys in total. The last clustering key remains undefined, expecting to be the timestamp for messages within sessionId. The sessionId can map to any primary key column (though it should map to a partition key column).");
            Preconditions.checkArgument((boolean)this.clusteringKeys.get(this.clusteringKeys.size() - 1).name().equals(CassandraChatMemoryConfig.DEFAULT_EXCHANGE_ID_NAME), (Object)"last clustering key must be the exchangeIdColumn");
            return new CassandraChatMemoryConfig(this);
        }
    }

    record Schema(String keyspace, String table, List<SchemaColumn> partitionKeys, List<SchemaColumn> clusteringKeys) {
    }

    public static interface SessionIdToPrimaryKeysTranslator
    extends Function<String, List<Object>> {
    }

    public record SchemaColumn(String name, DataType type) {
        public GenericType<Object> javaType() {
            return CodecRegistry.DEFAULT.codecFor(this.type).getJavaType();
        }
    }
}

