/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspace;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaUtil {
    private static final Logger logger = LoggerFactory.getLogger(SchemaUtil.class);

    private SchemaUtil() {
    }

    public static void checkSchemaAgreement(CqlSession session) throws IllegalStateException {
        if (!session.checkSchemaAgreement()) {
            logger.warn("Waiting for cluster schema agreement, sleeping 10s\u2026");
            try {
                Thread.sleep(Duration.ofSeconds(10L).toMillis());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(ex);
            }
            if (!session.checkSchemaAgreement()) {
                logger.error("no cluster schema agreement still, continuing, let's hope this works\u2026");
            }
        }
    }

    public static void ensureKeyspaceExists(CqlSession session, String keyspaceName) {
        if (session.getMetadata().getKeyspace(keyspaceName).isEmpty()) {
            SimpleStatement keyspaceStmt = ((CreateKeyspace)SchemaBuilder.createKeyspace((String)keyspaceName).ifNotExists().withSimpleStrategy(1)).build();
            logger.debug("Executing {}", (Object)keyspaceStmt.getQuery());
            session.execute((Statement)keyspaceStmt);
        }
    }
}

