/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamResponseHandler;

public abstract class AbstractBedrockApi<I, O, SO> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBedrockApi.class);
    public static final Sinks.EmitFailureHandler DEFAULT_EMIT_FAILURE_HANDLER = Sinks.EmitFailureHandler.busyLooping((Duration)Duration.ofSeconds(10L));
    private final String modelId;
    private final ObjectMapper objectMapper;
    private final Region region;
    private final BedrockRuntimeClient client;
    private final BedrockRuntimeAsyncClient clientStreaming;

    public AbstractBedrockApi(String modelId, String region) {
        this(modelId, (AwsCredentialsProvider)ProfileCredentialsProvider.builder().build(), region, ModelOptionsUtils.OBJECT_MAPPER, Duration.ofMinutes(5L));
    }

    public AbstractBedrockApi(String modelId, String region, Duration timeout) {
        this(modelId, (AwsCredentialsProvider)ProfileCredentialsProvider.builder().build(), region, ModelOptionsUtils.OBJECT_MAPPER, timeout);
    }

    public AbstractBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper) {
        this(modelId, credentialsProvider, region, objectMapper, Duration.ofMinutes(5L));
    }

    public AbstractBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper, Duration timeout) {
        this(modelId, credentialsProvider, Region.of((String)region), objectMapper, timeout);
    }

    public AbstractBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, Region region, ObjectMapper objectMapper, Duration timeout) {
        Assert.hasText((String)modelId, (String)"Model id must not be empty");
        Assert.notNull((Object)credentialsProvider, (String)"Credentials provider must not be null");
        Assert.notNull((Object)region, (String)"Region must not be empty");
        Assert.notNull((Object)objectMapper, (String)"Object mapper must not be null");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        this.modelId = modelId;
        this.objectMapper = objectMapper;
        this.region = region;
        this.client = (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().region(this.region)).credentialsProvider(credentialsProvider)).overrideConfiguration(c -> c.apiCallTimeout(timeout))).build();
        this.clientStreaming = (BedrockRuntimeAsyncClient)((BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)BedrockRuntimeAsyncClient.builder().region(this.region)).credentialsProvider(credentialsProvider)).overrideConfiguration(c -> c.apiCallTimeout(timeout))).build();
    }

    public String getModelId() {
        return this.modelId;
    }

    public Region getRegion() {
        return this.region;
    }

    protected O embedding(I request) {
        throw new UnsupportedOperationException("Embedding is not supported for this model: " + this.modelId);
    }

    protected O chatCompletion(I request) {
        throw new UnsupportedOperationException("Chat completion is not supported for this model: " + this.modelId);
    }

    protected Flux<SO> chatCompletionStream(I request) {
        throw new UnsupportedOperationException("Streaming chat completion is not supported for this model: " + this.modelId);
    }

    protected O internalInvocation(I request, Class<O> clazz) {
        SdkBytes body;
        try {
            body = SdkBytes.fromUtf8String((String)this.objectMapper.writeValueAsString(request));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid JSON format for the input request: " + String.valueOf(request), e);
        }
        InvokeModelRequest invokeRequest = (InvokeModelRequest)InvokeModelRequest.builder().modelId(this.modelId).body(body).build();
        InvokeModelResponse response = this.client.invokeModel(invokeRequest);
        String responseBody = response.body().asString(StandardCharsets.UTF_8);
        try {
            return (O)this.objectMapper.readValue(responseBody, clazz);
        }
        catch (JsonProcessingException | UncheckedIOException e) {
            throw new IllegalArgumentException("Invalid JSON format for the response: " + responseBody, e);
        }
    }

    protected Flux<SO> internalInvocationStream(I request, Class<SO> clazz) {
        SdkBytes body;
        Sinks.Many eventSink = Sinks.many().multicast().onBackpressureBuffer();
        try {
            body = SdkBytes.fromUtf8String((String)this.objectMapper.writeValueAsString(request));
        }
        catch (JsonProcessingException e) {
            eventSink.emitError((Throwable)e, DEFAULT_EMIT_FAILURE_HANDLER);
            return eventSink.asFlux();
        }
        InvokeModelWithResponseStreamRequest invokeRequest = (InvokeModelWithResponseStreamRequest)InvokeModelWithResponseStreamRequest.builder().modelId(this.modelId).body(body).build();
        InvokeModelWithResponseStreamResponseHandler.Visitor visitor = InvokeModelWithResponseStreamResponseHandler.Visitor.builder().onChunk(chunk -> {
            try {
                logger.debug("Received chunk: " + chunk.bytes().asString(StandardCharsets.UTF_8));
                Object response = this.objectMapper.readValue(chunk.bytes().asByteArray(), clazz);
                eventSink.emitNext(response, DEFAULT_EMIT_FAILURE_HANDLER);
            }
            catch (Exception e) {
                logger.error("Failed to unmarshall", (Throwable)e);
                eventSink.emitError((Throwable)e, DEFAULT_EMIT_FAILURE_HANDLER);
            }
        }).onDefault(event -> {
            logger.error("Unknown or unhandled event: " + event.toString());
            eventSink.emitError(new Throwable("Unknown or unhandled event: " + event.toString()), DEFAULT_EMIT_FAILURE_HANDLER);
        }).build();
        InvokeModelWithResponseStreamResponseHandler responseHandler = ((InvokeModelWithResponseStreamResponseHandler.Builder)((InvokeModelWithResponseStreamResponseHandler.Builder)((InvokeModelWithResponseStreamResponseHandler.Builder)InvokeModelWithResponseStreamResponseHandler.builder().onComplete(() -> {
            eventSink.emitComplete(DEFAULT_EMIT_FAILURE_HANDLER);
            logger.info("Completed streaming response.");
        })).onError(error -> {
            logger.error("\n\nError streaming response: " + error.getMessage());
            eventSink.emitError(error, DEFAULT_EMIT_FAILURE_HANDLER);
        })).onEventStream(stream -> stream.subscribe(e -> e.accept(visitor)))).build();
        this.clientStreaming.invokeModelWithResponseStream(invokeRequest, responseHandler);
        return eventSink.asFlux();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record AmazonBedrockInvocationMetrics(@JsonProperty(value="inputTokenCount") Long inputTokenCount, @JsonProperty(value="firstByteLatency") Long firstByteLatency, @JsonProperty(value="outputTokenCount") Long outputTokenCount, @JsonProperty(value="invocationLatency") Long invocationLatency) {
    }
}

