/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.titan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.ai.chat.prompt.ChatOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BedrockTitanChatOptions
implements ChatOptions {
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="topP")
    private Double topP;
    @JsonProperty(value="maxTokenCount")
    private Integer maxTokenCount;
    @JsonProperty(value="stopSequences")
    private List<String> stopSequences;

    public static Builder builder() {
        return new Builder();
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    @JsonIgnore
    public Integer getMaxTokens() {
        return this.getMaxTokenCount();
    }

    @JsonIgnore
    public void setMaxTokens(Integer maxTokens) {
        this.setMaxTokenCount(maxTokens);
    }

    public Integer getMaxTokenCount() {
        return this.maxTokenCount;
    }

    public void setMaxTokenCount(Integer maxTokenCount) {
        this.maxTokenCount = maxTokenCount;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    @JsonIgnore
    public String getModel() {
        return null;
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return null;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    public BedrockTitanChatOptions copy() {
        return BedrockTitanChatOptions.fromOptions(this);
    }

    public static BedrockTitanChatOptions fromOptions(BedrockTitanChatOptions fromOptions) {
        return BedrockTitanChatOptions.builder().withTemperature(fromOptions.getTemperature()).withTopP(fromOptions.getTopP()).withMaxTokenCount(fromOptions.getMaxTokenCount()).withStopSequences(fromOptions.getStopSequences()).build();
    }

    public static class Builder {
        private BedrockTitanChatOptions options = new BedrockTitanChatOptions();

        public Builder withTemperature(Double temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder withTopP(Double topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder withMaxTokenCount(Integer maxTokenCount) {
            this.options.maxTokenCount = maxTokenCount;
            return this;
        }

        public Builder withStopSequences(List<String> stopSequences) {
            this.options.stopSequences = stopSequences;
            return this;
        }

        public BedrockTitanChatOptions build() {
            return this.options;
        }
    }
}

