/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.llama.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import org.springframework.ai.bedrock.api.AbstractBedrockApi;
import org.springframework.ai.model.ChatModelDescription;
import reactor.core.publisher.Flux;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class LlamaChatBedrockApi
extends AbstractBedrockApi<LlamaChatRequest, LlamaChatResponse, LlamaChatResponse> {
    public LlamaChatBedrockApi(String modelId, String region) {
        super(modelId, region);
    }

    public LlamaChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper) {
        super(modelId, credentialsProvider, region, objectMapper);
    }

    public LlamaChatBedrockApi(String modelId, String region, Duration timeout) {
        super(modelId, region, timeout);
    }

    public LlamaChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper, Duration timeout) {
        super(modelId, credentialsProvider, region, objectMapper, timeout);
    }

    public LlamaChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, Region region, ObjectMapper objectMapper, Duration timeout) {
        super(modelId, credentialsProvider, region, objectMapper, timeout);
    }

    @Override
    public LlamaChatResponse chatCompletion(LlamaChatRequest request) {
        return this.internalInvocation(request, LlamaChatResponse.class);
    }

    @Override
    public Flux<LlamaChatResponse> chatCompletionStream(LlamaChatRequest request) {
        return this.internalInvocationStream(request, LlamaChatResponse.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record LlamaChatResponse(@JsonProperty(value="generation") String generation, @JsonProperty(value="prompt_token_count") Integer promptTokenCount, @JsonProperty(value="generation_token_count") Integer generationTokenCount, @JsonProperty(value="stop_reason") StopReason stopReason, @JsonProperty(value="amazon-bedrock-invocationMetrics") AbstractBedrockApi.AmazonBedrockInvocationMetrics amazonBedrockInvocationMetrics) {

        public static enum StopReason {
            STOP,
            LENGTH;

        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record LlamaChatRequest(@JsonProperty(value="prompt") String prompt, @JsonProperty(value="temperature") Double temperature, @JsonProperty(value="top_p") Double topP, @JsonProperty(value="max_gen_len") Integer maxGenLen) {
        public static Builder builder(String prompt) {
            return new Builder(prompt);
        }

        public static class Builder {
            private String prompt;
            private Double temperature;
            private Double topP;
            private Integer maxGenLen;

            public Builder(String prompt) {
                this.prompt = prompt;
            }

            public Builder withTemperature(Double temperature) {
                this.temperature = temperature;
                return this;
            }

            public Builder withTopP(Double topP) {
                this.topP = topP;
                return this;
            }

            public Builder withMaxGenLen(Integer maxGenLen) {
                this.maxGenLen = maxGenLen;
                return this;
            }

            public LlamaChatRequest build() {
                return new LlamaChatRequest(this.prompt, this.temperature, this.topP, this.maxGenLen);
            }
        }
    }

    public static enum LlamaChatModel implements ChatModelDescription
    {
        LLAMA2_13B_CHAT_V1("meta.llama2-13b-chat-v1"),
        LLAMA2_70B_CHAT_V1("meta.llama2-70b-chat-v1"),
        LLAMA3_8B_INSTRUCT_V1("meta.llama3-8b-instruct-v1:0"),
        LLAMA3_70B_INSTRUCT_V1("meta.llama3-70b-instruct-v1:0"),
        LLAMA3_1_8B_INSTRUCT_V1("meta.llama3-1-8b-instruct-v1:0"),
        LLAMA3_1_70B_INSTRUCT_V1("meta.llama3-1-70b-instruct-v1:0"),
        LLAMA3_1_405B_INSTRUCT_V1("meta.llama3-1-405b-instruct-v1:0"),
        LLAMA3_2_1B_INSTRUCT_V1("meta.llama3-2-1b-instruct-v1:0"),
        LLAMA3_2_3B_INSTRUCT_V1("meta.llama3-2-3b-instruct-v1:0"),
        LLAMA3_2_11B_INSTRUCT_V1("meta.llama3-2-11b-instruct-v1:0"),
        LLAMA3_2_90B_INSTRUCT_V1("meta.llama3-2-90b-instruct-v1:0");

        private final String id;

        public String id() {
            return this.id;
        }

        private LlamaChatModel(String value) {
            this.id = value;
        }

        public String getName() {
            return this.id;
        }
    }
}

