/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.llama;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.ai.chat.prompt.ChatOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BedrockLlamaChatOptions
implements ChatOptions {
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="max_gen_len")
    private Integer maxGenLen;

    public static Builder builder() {
        return new Builder();
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    @JsonIgnore
    public Integer getMaxTokens() {
        return this.getMaxGenLen();
    }

    @JsonIgnore
    public void setMaxTokens(Integer maxTokens) {
        this.setMaxGenLen(maxTokens);
    }

    public Integer getMaxGenLen() {
        return this.maxGenLen;
    }

    public void setMaxGenLen(Integer maxGenLen) {
        this.maxGenLen = maxGenLen;
    }

    @JsonIgnore
    public String getModel() {
        return null;
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return null;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return null;
    }

    @JsonIgnore
    public Integer getTopK() {
        return null;
    }

    public BedrockLlamaChatOptions copy() {
        return BedrockLlamaChatOptions.fromOptions(this);
    }

    public static BedrockLlamaChatOptions fromOptions(BedrockLlamaChatOptions fromOptions) {
        return BedrockLlamaChatOptions.builder().withTemperature(fromOptions.getTemperature()).withTopP(fromOptions.getTopP()).withMaxGenLen(fromOptions.getMaxGenLen()).build();
    }

    public static class Builder {
        private BedrockLlamaChatOptions options = new BedrockLlamaChatOptions();

        public Builder withTemperature(Double temperature) {
            this.options.setTemperature(temperature);
            return this;
        }

        public Builder withTopP(Double topP) {
            this.options.setTopP(topP);
            return this;
        }

        public Builder withMaxGenLen(Integer maxGenLen) {
            this.options.setMaxGenLen(maxGenLen);
            return this;
        }

        public BedrockLlamaChatOptions build() {
            return this.options;
        }
    }
}

