/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.llama;

import java.util.List;
import org.springframework.ai.bedrock.MessageToPromptConverter;
import org.springframework.ai.bedrock.llama.BedrockLlamaChatOptions;
import org.springframework.ai.bedrock.llama.api.LlamaChatBedrockApi;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.StreamingChatModel;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public class BedrockLlamaChatModel
implements ChatModel,
StreamingChatModel {
    private final LlamaChatBedrockApi chatApi;
    private final BedrockLlamaChatOptions defaultOptions;

    public BedrockLlamaChatModel(LlamaChatBedrockApi chatApi) {
        this(chatApi, BedrockLlamaChatOptions.builder().withTemperature(0.8).withTopP(0.9).withMaxGenLen(100).build());
    }

    public BedrockLlamaChatModel(LlamaChatBedrockApi chatApi, BedrockLlamaChatOptions options) {
        Assert.notNull((Object)chatApi, (String)"LlamaChatBedrockApi must not be null");
        Assert.notNull((Object)options, (String)"BedrockLlamaChatOptions must not be null");
        this.chatApi = chatApi;
        this.defaultOptions = options;
    }

    public ChatResponse call(Prompt prompt) {
        LlamaChatBedrockApi.LlamaChatRequest request = this.createRequest(prompt);
        LlamaChatBedrockApi.LlamaChatResponse response = this.chatApi.chatCompletion(request);
        return new ChatResponse(List.of(new Generation(response.generation()).withGenerationMetadata(ChatGenerationMetadata.from((String)response.stopReason().name(), (Object)this.extractUsage(response)))));
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        LlamaChatBedrockApi.LlamaChatRequest request = this.createRequest(prompt);
        Flux<LlamaChatBedrockApi.LlamaChatResponse> fluxResponse = this.chatApi.chatCompletionStream(request);
        return fluxResponse.map(response -> {
            String stopReason = response.stopReason() != null ? response.stopReason().name() : null;
            return new ChatResponse(List.of(new Generation(response.generation()).withGenerationMetadata(ChatGenerationMetadata.from((String)stopReason, (Object)this.extractUsage((LlamaChatBedrockApi.LlamaChatResponse)response)))));
        });
    }

    private Usage extractUsage(final LlamaChatBedrockApi.LlamaChatResponse response) {
        return new Usage(){

            public Long getPromptTokens() {
                return response.promptTokenCount().longValue();
            }

            public Long getGenerationTokens() {
                return response.generationTokenCount().longValue();
            }
        };
    }

    LlamaChatBedrockApi.LlamaChatRequest createRequest(Prompt prompt) {
        String promptValue = MessageToPromptConverter.create().toPrompt(prompt.getInstructions());
        LlamaChatBedrockApi.LlamaChatRequest request = LlamaChatBedrockApi.LlamaChatRequest.builder(promptValue).build();
        if (this.defaultOptions != null) {
            request = (LlamaChatBedrockApi.LlamaChatRequest)ModelOptionsUtils.merge((Object)request, (Object)this.defaultOptions, LlamaChatBedrockApi.LlamaChatRequest.class);
        }
        if (prompt.getOptions() != null) {
            BedrockLlamaChatOptions updatedRuntimeOptions = (BedrockLlamaChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, BedrockLlamaChatOptions.class);
            request = (LlamaChatBedrockApi.LlamaChatRequest)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)request, LlamaChatBedrockApi.LlamaChatRequest.class);
        }
        return request;
    }

    public ChatOptions getDefaultOptions() {
        return BedrockLlamaChatOptions.fromOptions(this.defaultOptions);
    }
}

