/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.jurassic2.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.List;
import org.springframework.ai.bedrock.api.AbstractBedrockApi;
import org.springframework.ai.model.ChatModelDescription;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class Ai21Jurassic2ChatBedrockApi
extends AbstractBedrockApi<Ai21Jurassic2ChatRequest, Ai21Jurassic2ChatResponse, Ai21Jurassic2ChatResponse> {
    public Ai21Jurassic2ChatBedrockApi(String modelId, String region) {
        super(modelId, region);
    }

    public Ai21Jurassic2ChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper) {
        super(modelId, credentialsProvider, region, objectMapper);
    }

    public Ai21Jurassic2ChatBedrockApi(String modelId, String region, Duration timeout) {
        super(modelId, region, timeout);
    }

    public Ai21Jurassic2ChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper, Duration timeout) {
        super(modelId, credentialsProvider, region, objectMapper, timeout);
    }

    public Ai21Jurassic2ChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, Region region, ObjectMapper objectMapper, Duration timeout) {
        super(modelId, credentialsProvider, region, objectMapper, timeout);
    }

    @Override
    public Ai21Jurassic2ChatResponse chatCompletion(Ai21Jurassic2ChatRequest request) {
        return this.internalInvocation(request, Ai21Jurassic2ChatResponse.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Ai21Jurassic2ChatResponse(@JsonProperty(value="id") String id, @JsonProperty(value="prompt") Prompt prompt, @JsonProperty(value="completions") List<Completion> completions, @JsonProperty(value="amazon-bedrock-invocationMetrics") AbstractBedrockApi.AmazonBedrockInvocationMetrics amazonBedrockInvocationMetrics) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Prompt(@JsonProperty(value="text") String text, @JsonProperty(value="tokens") List<Token> tokens) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record FinishReason(@JsonProperty(value="reason") String reason, @JsonProperty(value="length") String length, @JsonProperty(value="sequence") String sequence) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record TextRange(@JsonProperty(value="start") Integer start, @JsonProperty(value="end") Integer end) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record TopToken(@JsonProperty(value="token") String token, @JsonProperty(value="logprob") Float logprob) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record GeneratedToken(@JsonProperty(value="token") String token, @JsonProperty(value="logprob") Float logprob, @JsonProperty(value="raw_logprob") Float rawLogprob) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Token(@JsonProperty(value="generatedToken") GeneratedToken generatedToken, @JsonProperty(value="topTokens") List<TopToken> topTokens, @JsonProperty(value="textRange") TextRange textRange) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Completion(@JsonProperty(value="data") Prompt data, @JsonProperty(value="finishReason") FinishReason finishReason) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Ai21Jurassic2ChatRequest(@JsonProperty(value="prompt") String prompt, @JsonProperty(value="temperature") Double temperature, @JsonProperty(value="topP") Double topP, @JsonProperty(value="maxTokens") Integer maxTokens, @JsonProperty(value="stopSequences") List<String> stopSequences, @JsonProperty(value="countPenalty") IntegerScalePenalty countPenalty, @JsonProperty(value="presencePenalty") FloatScalePenalty presencePenalty, @JsonProperty(value="frequencyPenalty") IntegerScalePenalty frequencyPenalty) {
        public static Builder builder(String prompt) {
            return new Builder(prompt);
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record IntegerScalePenalty(@JsonProperty(value="scale") Integer scale, @JsonProperty(value="applyToWhitespaces") boolean applyToWhitespaces, @JsonProperty(value="applyToPunctuations") boolean applyToPunctuations, @JsonProperty(value="applyToNumbers") boolean applyToNumbers, @JsonProperty(value="applyToStopwords") boolean applyToStopwords, @JsonProperty(value="applyToEmojis") boolean applyToEmojis) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record FloatScalePenalty(@JsonProperty(value="scale") Float scale, @JsonProperty(value="applyToWhitespaces") boolean applyToWhitespaces, @JsonProperty(value="applyToPunctuations") boolean applyToPunctuations, @JsonProperty(value="applyToNumbers") boolean applyToNumbers, @JsonProperty(value="applyToStopwords") boolean applyToStopwords, @JsonProperty(value="applyToEmojis") boolean applyToEmojis) {
        }

        public static class Builder {
            private String prompt;
            private Double temperature;
            private Double topP;
            private Integer maxTokens;
            private List<String> stopSequences;
            private IntegerScalePenalty countPenalty;
            private FloatScalePenalty presencePenalty;
            private IntegerScalePenalty frequencyPenalty;

            public Builder(String prompt) {
                this.prompt = prompt;
            }

            public Builder withTemperature(Double temperature) {
                this.temperature = temperature;
                return this;
            }

            public Builder withTopP(Double topP) {
                this.topP = topP;
                return this;
            }

            public Builder withMaxTokens(Integer maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            public Builder withStopSequences(List<String> stopSequences) {
                this.stopSequences = stopSequences;
                return this;
            }

            public Builder withCountPenalty(IntegerScalePenalty countPenalty) {
                this.countPenalty = countPenalty;
                return this;
            }

            public Builder withPresencePenalty(FloatScalePenalty presencePenalty) {
                this.presencePenalty = presencePenalty;
                return this;
            }

            public Builder withFrequencyPenalty(IntegerScalePenalty frequencyPenalty) {
                this.frequencyPenalty = frequencyPenalty;
                return this;
            }

            public Ai21Jurassic2ChatRequest build() {
                return new Ai21Jurassic2ChatRequest(this.prompt, this.temperature, this.topP, this.maxTokens, this.stopSequences, this.countPenalty, this.presencePenalty, this.frequencyPenalty);
            }
        }
    }

    public static enum Ai21Jurassic2ChatModel implements ChatModelDescription
    {
        AI21_J2_MID_V1("ai21.j2-mid-v1"),
        AI21_J2_ULTRA_V1("ai21.j2-ultra-v1");

        private final String id;

        public String id() {
            return this.id;
        }

        private Ai21Jurassic2ChatModel(String value) {
            this.id = value;
        }

        public String getName() {
            return this.id;
        }
    }
}

