/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.jurassic2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.ai.chat.prompt.ChatOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BedrockAi21Jurassic2ChatOptions
implements ChatOptions {
    @JsonProperty(value="prompt")
    private String prompt;
    @JsonProperty(value="numResults")
    private Integer numResults;
    @JsonProperty(value="maxTokens")
    private Integer maxTokens;
    @JsonProperty(value="minTokens")
    private Integer minTokens;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="topP")
    private Double topP;
    @JsonProperty(value="topKReturn")
    private Integer topK;
    @JsonProperty(value="stopSequences")
    private List<String> stopSequences;
    @JsonProperty(value="frequencyPenalty")
    private Penalty frequencyPenaltyOptions;
    @JsonProperty(value="presencePenalty")
    private Penalty presencePenaltyOptions;
    @JsonProperty(value="countPenalty")
    private Penalty countPenaltyOptions;

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public Integer getNumResults() {
        return this.numResults;
    }

    public void setNumResults(Integer numResults) {
        this.numResults = numResults;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Integer getMinTokens() {
        return this.minTokens;
    }

    public void setMinTokens(Integer minTokens) {
        this.minTokens = minTokens;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return this.getFrequencyPenaltyOptions() != null ? this.getFrequencyPenaltyOptions().scale() : null;
    }

    @JsonIgnore
    public void setFrequencyPenalty(Double frequencyPenalty) {
        if (frequencyPenalty != null) {
            this.setFrequencyPenaltyOptions(Penalty.builder().scale(frequencyPenalty).build());
        }
    }

    public Penalty getFrequencyPenaltyOptions() {
        return this.frequencyPenaltyOptions;
    }

    public void setFrequencyPenaltyOptions(Penalty frequencyPenaltyOptions) {
        this.frequencyPenaltyOptions = frequencyPenaltyOptions;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return this.getPresencePenaltyOptions() != null ? this.getPresencePenaltyOptions().scale() : null;
    }

    @JsonIgnore
    public void setPresencePenalty(Double presencePenalty) {
        if (presencePenalty != null) {
            this.setPresencePenaltyOptions(Penalty.builder().scale(presencePenalty).build());
        }
    }

    public Penalty getPresencePenaltyOptions() {
        return this.presencePenaltyOptions;
    }

    public void setPresencePenaltyOptions(Penalty presencePenaltyOptions) {
        this.presencePenaltyOptions = presencePenaltyOptions;
    }

    public Penalty getCountPenaltyOptions() {
        return this.countPenaltyOptions;
    }

    public void setCountPenaltyOptions(Penalty countPenaltyOptions) {
        this.countPenaltyOptions = countPenaltyOptions;
    }

    @JsonIgnore
    public String getModel() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public BedrockAi21Jurassic2ChatOptions copy() {
        return BedrockAi21Jurassic2ChatOptions.fromOptions(this);
    }

    public static BedrockAi21Jurassic2ChatOptions fromOptions(BedrockAi21Jurassic2ChatOptions fromOptions) {
        return BedrockAi21Jurassic2ChatOptions.builder().withPrompt(fromOptions.getPrompt()).withNumResults(fromOptions.getNumResults()).withMaxTokens(fromOptions.getMaxTokens()).withMinTokens(fromOptions.getMinTokens()).withTemperature(fromOptions.getTemperature()).withTopP(fromOptions.getTopP()).withTopK(fromOptions.getTopK()).withStopSequences(fromOptions.getStopSequences()).withFrequencyPenaltyOptions(fromOptions.getFrequencyPenaltyOptions()).withPresencePenaltyOptions(fromOptions.getPresencePenaltyOptions()).withCountPenaltyOptions(fromOptions.getCountPenaltyOptions()).build();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Penalty(@JsonProperty(value="scale") Double scale, @JsonProperty(value="applyToNumbers") Boolean applyToNumbers, @JsonProperty(value="applyToPunctuations") Boolean applyToPunctuations, @JsonProperty(value="applyToStopwords") Boolean applyToStopwords, @JsonProperty(value="applyToWhitespaces") Boolean applyToWhitespaces, @JsonProperty(value="applyToEmojis") Boolean applyToEmojis) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Double scale;
            private Boolean applyToNumbers = true;
            private Boolean applyToPunctuations = true;
            private Boolean applyToStopwords = true;
            private Boolean applyToWhitespaces = true;
            private Boolean applyToEmojis = true;

            public Builder scale(Double scale) {
                this.scale = scale;
                return this;
            }

            public Builder applyToNumbers(Boolean applyToNumbers) {
                this.applyToNumbers = applyToNumbers;
                return this;
            }

            public Builder applyToPunctuations(Boolean applyToPunctuations) {
                this.applyToPunctuations = applyToPunctuations;
                return this;
            }

            public Builder applyToStopwords(Boolean applyToStopwords) {
                this.applyToStopwords = applyToStopwords;
                return this;
            }

            public Builder applyToWhitespaces(Boolean applyToWhitespaces) {
                this.applyToWhitespaces = applyToWhitespaces;
                return this;
            }

            public Builder applyToEmojis(Boolean applyToEmojis) {
                this.applyToEmojis = applyToEmojis;
                return this;
            }

            public Penalty build() {
                return new Penalty(this.scale, this.applyToNumbers, this.applyToPunctuations, this.applyToStopwords, this.applyToWhitespaces, this.applyToEmojis);
            }
        }
    }

    public static class Builder {
        private final BedrockAi21Jurassic2ChatOptions request = new BedrockAi21Jurassic2ChatOptions();

        public Builder withPrompt(String prompt) {
            this.request.setPrompt(prompt);
            return this;
        }

        public Builder withNumResults(Integer numResults) {
            this.request.setNumResults(numResults);
            return this;
        }

        public Builder withMaxTokens(Integer maxTokens) {
            this.request.setMaxTokens(maxTokens);
            return this;
        }

        public Builder withMinTokens(Integer minTokens) {
            this.request.setMinTokens(minTokens);
            return this;
        }

        public Builder withTemperature(Double temperature) {
            this.request.setTemperature(temperature);
            return this;
        }

        public Builder withTopP(Double topP) {
            this.request.setTopP(topP);
            return this;
        }

        public Builder withStopSequences(List<String> stopSequences) {
            this.request.setStopSequences(stopSequences);
            return this;
        }

        public Builder withTopK(Integer topKReturn) {
            this.request.setTopK(topKReturn);
            return this;
        }

        public Builder withFrequencyPenaltyOptions(Penalty frequencyPenalty) {
            this.request.setFrequencyPenaltyOptions(frequencyPenalty);
            return this;
        }

        public Builder withPresencePenaltyOptions(Penalty presencePenalty) {
            this.request.setPresencePenaltyOptions(presencePenalty);
            return this;
        }

        public Builder withCountPenaltyOptions(Penalty countPenalty) {
            this.request.setCountPenaltyOptions(countPenalty);
            return this;
        }

        public BedrockAi21Jurassic2ChatOptions build() {
            return this.request;
        }
    }
}

