/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.jurassic2;

import org.springframework.ai.bedrock.MessageToPromptConverter;
import org.springframework.ai.bedrock.jurassic2.BedrockAi21Jurassic2ChatOptions;
import org.springframework.ai.bedrock.jurassic2.api.Ai21Jurassic2ChatBedrockApi;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.util.Assert;

public class BedrockAi21Jurassic2ChatModel
implements ChatModel {
    private final Ai21Jurassic2ChatBedrockApi chatApi;
    private final BedrockAi21Jurassic2ChatOptions defaultOptions;

    public BedrockAi21Jurassic2ChatModel(Ai21Jurassic2ChatBedrockApi chatApi, BedrockAi21Jurassic2ChatOptions options) {
        Assert.notNull((Object)chatApi, (String)"Ai21Jurassic2ChatBedrockApi must not be null");
        Assert.notNull((Object)options, (String)"BedrockAi21Jurassic2ChatOptions must not be null");
        this.chatApi = chatApi;
        this.defaultOptions = options;
    }

    public BedrockAi21Jurassic2ChatModel(Ai21Jurassic2ChatBedrockApi chatApi) {
        this(chatApi, BedrockAi21Jurassic2ChatOptions.builder().withTemperature(0.8).withTopP(0.9).withMaxTokens(100).build());
    }

    public ChatResponse call(Prompt prompt) {
        Ai21Jurassic2ChatBedrockApi.Ai21Jurassic2ChatRequest request = this.createRequest(prompt);
        Ai21Jurassic2ChatBedrockApi.Ai21Jurassic2ChatResponse response = this.chatApi.chatCompletion(request);
        return new ChatResponse(response.completions().stream().map(completion -> new Generation(completion.data().text()).withGenerationMetadata(ChatGenerationMetadata.from((String)completion.finishReason().reason(), null))).toList());
    }

    private Ai21Jurassic2ChatBedrockApi.Ai21Jurassic2ChatRequest createRequest(Prompt prompt) {
        String promptValue = MessageToPromptConverter.create().toPrompt(prompt.getInstructions());
        Ai21Jurassic2ChatBedrockApi.Ai21Jurassic2ChatRequest request = Ai21Jurassic2ChatBedrockApi.Ai21Jurassic2ChatRequest.builder(promptValue).build();
        if (prompt.getOptions() != null) {
            BedrockAi21Jurassic2ChatOptions updatedRuntimeOptions = (BedrockAi21Jurassic2ChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, BedrockAi21Jurassic2ChatOptions.class);
            request = (Ai21Jurassic2ChatBedrockApi.Ai21Jurassic2ChatRequest)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)request, Ai21Jurassic2ChatBedrockApi.Ai21Jurassic2ChatRequest.class);
        }
        if (this.defaultOptions != null) {
            request = (Ai21Jurassic2ChatBedrockApi.Ai21Jurassic2ChatRequest)ModelOptionsUtils.merge((Object)request, (Object)this.defaultOptions, Ai21Jurassic2ChatBedrockApi.Ai21Jurassic2ChatRequest.class);
        }
        return request;
    }

    public static Builder builder(Ai21Jurassic2ChatBedrockApi chatApi) {
        return new Builder(chatApi);
    }

    public ChatOptions getDefaultOptions() {
        return BedrockAi21Jurassic2ChatOptions.fromOptions(this.defaultOptions);
    }

    public static class Builder {
        private final Ai21Jurassic2ChatBedrockApi chatApi;
        private BedrockAi21Jurassic2ChatOptions options;

        public Builder(Ai21Jurassic2ChatBedrockApi chatApi) {
            this.chatApi = chatApi;
        }

        public Builder withOptions(BedrockAi21Jurassic2ChatOptions options) {
            this.options = options;
            return this;
        }

        public BedrockAi21Jurassic2ChatModel build() {
            return new BedrockAi21Jurassic2ChatModel(this.chatApi, this.options != null ? this.options : BedrockAi21Jurassic2ChatOptions.builder().build());
        }
    }
}

