/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.cohere.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.List;
import org.springframework.ai.bedrock.api.AbstractBedrockApi;
import org.springframework.ai.model.ChatModelDescription;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class CohereChatBedrockApi
extends AbstractBedrockApi<CohereChatRequest, CohereChatResponse, CohereChatResponse.Generation> {
    public CohereChatBedrockApi(String modelId, String region) {
        super(modelId, region);
    }

    public CohereChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper) {
        super(modelId, credentialsProvider, region, objectMapper);
    }

    public CohereChatBedrockApi(String modelId, String region, Duration timeout) {
        super(modelId, region, timeout);
    }

    public CohereChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper, Duration timeout) {
        super(modelId, credentialsProvider, region, objectMapper, timeout);
    }

    public CohereChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, Region region, ObjectMapper objectMapper, Duration timeout) {
        super(modelId, credentialsProvider, region, objectMapper, timeout);
    }

    @Override
    public CohereChatResponse chatCompletion(CohereChatRequest request) {
        Assert.isTrue((!request.stream() ? 1 : 0) != 0, (String)"The request must be configured to return the complete response!");
        return this.internalInvocation(request, CohereChatResponse.class);
    }

    @Override
    public Flux<CohereChatResponse.Generation> chatCompletionStream(CohereChatRequest request) {
        Assert.isTrue((boolean)request.stream(), (String)"The request must be configured to stream the response!");
        return this.internalInvocationStream(request, CohereChatResponse.Generation.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record CohereChatRequest(@JsonProperty(value="prompt") String prompt, @JsonProperty(value="temperature") Double temperature, @JsonProperty(value="p") Double topP, @JsonProperty(value="k") Integer topK, @JsonProperty(value="max_tokens") Integer maxTokens, @JsonProperty(value="stop_sequences") List<String> stopSequences, @JsonProperty(value="return_likelihoods") ReturnLikelihoods returnLikelihoods, @JsonProperty(value="stream") boolean stream, @JsonProperty(value="num_generations") Integer numGenerations, @JsonProperty(value="logit_bias") LogitBias logitBias, @JsonProperty(value="truncate") Truncate truncate) {
        public static Builder builder(String prompt) {
            return new Builder(prompt);
        }

        public static enum ReturnLikelihoods {
            GENERATION,
            ALL,
            NONE;

        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record LogitBias(@JsonProperty(value="token") String token, @JsonProperty(value="bias") Float bias) {
        }

        public static enum Truncate {
            NONE,
            START,
            END;

        }

        public static class Builder {
            private final String prompt;
            private Double temperature;
            private Double topP;
            private Integer topK;
            private Integer maxTokens;
            private List<String> stopSequences;
            private ReturnLikelihoods returnLikelihoods;
            private boolean stream;
            private Integer numGenerations;
            private LogitBias logitBias;
            private Truncate truncate;

            public Builder(String prompt) {
                this.prompt = prompt;
            }

            public Builder withTemperature(Double temperature) {
                this.temperature = temperature;
                return this;
            }

            public Builder withTopP(Double topP) {
                this.topP = topP;
                return this;
            }

            public Builder withTopK(Integer topK) {
                this.topK = topK;
                return this;
            }

            public Builder withMaxTokens(Integer maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            public Builder withStopSequences(List<String> stopSequences) {
                this.stopSequences = stopSequences;
                return this;
            }

            public Builder withReturnLikelihoods(ReturnLikelihoods returnLikelihoods) {
                this.returnLikelihoods = returnLikelihoods;
                return this;
            }

            public Builder withStream(boolean stream) {
                this.stream = stream;
                return this;
            }

            public Builder withNumGenerations(Integer numGenerations) {
                this.numGenerations = numGenerations;
                return this;
            }

            public Builder withLogitBias(LogitBias logitBias) {
                this.logitBias = logitBias;
                return this;
            }

            public Builder withTruncate(Truncate truncate) {
                this.truncate = truncate;
                return this;
            }

            public CohereChatRequest build() {
                return new CohereChatRequest(this.prompt, this.temperature, this.topP, this.topK, this.maxTokens, this.stopSequences, this.returnLikelihoods, this.stream, this.numGenerations, this.logitBias, this.truncate);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record CohereChatResponse(@JsonProperty(value="id") String id, @JsonProperty(value="prompt") String prompt, @JsonProperty(value="generations") List<Generation> generations) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Generation(@JsonProperty(value="id") String id, @JsonProperty(value="event_type") String event_type, @JsonProperty(value="likelihood") Float likelihood, @JsonProperty(value="token_likelihoods") List<TokenLikelihood> tokenLikelihoods, @JsonProperty(value="finish_reason") FinishReason finishReason, @JsonProperty(value="is_finished") Boolean isFinished, @JsonProperty(value="text") String text, @JsonProperty(value="index") Integer index, @JsonProperty(value="amazon-bedrock-invocationMetrics") AbstractBedrockApi.AmazonBedrockInvocationMetrics amazonBedrockInvocationMetrics) {

            public static enum FinishReason {
                COMPLETE,
                MAX_TOKENS,
                ERROR,
                ERROR_TOXIC;

            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record TokenLikelihood(@JsonProperty(value="token") String token, @JsonProperty(value="likelihood") Float likelihood) {
            }
        }
    }

    public static enum CohereChatModel implements ChatModelDescription
    {
        COHERE_COMMAND_LIGHT_V14("cohere.command-light-text-v14"),
        COHERE_COMMAND_V14("cohere.command-text-v14");

        private final String id;

        public String id() {
            return this.id;
        }

        private CohereChatModel(String value) {
            this.id = value;
        }

        public String getName() {
            return this.id;
        }
    }
}

