/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.anthropic3;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.ai.chat.prompt.ChatOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Anthropic3ChatOptions
implements ChatOptions {
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="top_k")
    private Integer topK;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="stop_sequences")
    private List<String> stopSequences;
    @JsonProperty(value="anthropic_version")
    private String anthropicVersion;

    public static Builder builder() {
        return new Builder();
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    public String getAnthropicVersion() {
        return this.anthropicVersion;
    }

    public void setAnthropicVersion(String anthropicVersion) {
        this.anthropicVersion = anthropicVersion;
    }

    @JsonIgnore
    public String getModel() {
        return null;
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return null;
    }

    public Anthropic3ChatOptions copy() {
        return Anthropic3ChatOptions.fromOptions(this);
    }

    public static Anthropic3ChatOptions fromOptions(Anthropic3ChatOptions fromOptions) {
        return Anthropic3ChatOptions.builder().withTemperature(fromOptions.getTemperature()).withMaxTokens(fromOptions.getMaxTokens()).withTopK(fromOptions.getTopK()).withTopP(fromOptions.getTopP()).withStopSequences(fromOptions.getStopSequences()).withAnthropicVersion(fromOptions.getAnthropicVersion()).build();
    }

    public static class Builder {
        private final Anthropic3ChatOptions options = new Anthropic3ChatOptions();

        public Builder withTemperature(Double temperature) {
            this.options.setTemperature(temperature);
            return this;
        }

        public Builder withMaxTokens(Integer maxTokens) {
            this.options.setMaxTokens(maxTokens);
            return this;
        }

        public Builder withTopK(Integer topK) {
            this.options.setTopK(topK);
            return this;
        }

        public Builder withTopP(Double topP) {
            this.options.setTopP(topP);
            return this;
        }

        public Builder withStopSequences(List<String> stopSequences) {
            this.options.setStopSequences(stopSequences);
            return this;
        }

        public Builder withAnthropicVersion(String anthropicVersion) {
            this.options.setAnthropicVersion(anthropicVersion);
            return this;
        }

        public Anthropic3ChatOptions build() {
            return this.options;
        }
    }
}

