/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.anthropic.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.List;
import org.springframework.ai.bedrock.api.AbstractBedrockApi;
import org.springframework.ai.model.ChatModelDescription;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class AnthropicChatBedrockApi
extends AbstractBedrockApi<AnthropicChatRequest, AnthropicChatResponse, AnthropicChatResponse> {
    public static final String PROMPT_TEMPLATE = "\n\nHuman:%s\n\nAssistant:";
    public static final String DEFAULT_ANTHROPIC_VERSION = "bedrock-2023-05-31";

    public AnthropicChatBedrockApi(String modelId, String region) {
        super(modelId, region);
    }

    public AnthropicChatBedrockApi(String modelId, String region, Duration timeout) {
        super(modelId, region, timeout);
    }

    public AnthropicChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper) {
        super(modelId, credentialsProvider, region, objectMapper);
    }

    public AnthropicChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper, Duration timeout) {
        super(modelId, credentialsProvider, region, objectMapper, timeout);
    }

    public AnthropicChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, Region region, ObjectMapper objectMapper, Duration timeout) {
        super(modelId, credentialsProvider, region, objectMapper, timeout);
    }

    @Override
    public AnthropicChatResponse chatCompletion(AnthropicChatRequest anthropicRequest) {
        Assert.notNull((Object)anthropicRequest, (String)"'anthropicRequest' must not be null");
        return this.internalInvocation(anthropicRequest, AnthropicChatResponse.class);
    }

    @Override
    public Flux<AnthropicChatResponse> chatCompletionStream(AnthropicChatRequest anthropicRequest) {
        Assert.notNull((Object)anthropicRequest, (String)"'anthropicRequest' must not be null");
        return this.internalInvocationStream(anthropicRequest, AnthropicChatResponse.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record AnthropicChatResponse(@JsonProperty(value="type") String type, @JsonProperty(value="completion") String completion, @JsonProperty(value="stop_reason") String stopReason, @JsonProperty(value="stop") String stop, @JsonProperty(value="amazon-bedrock-invocationMetrics") AbstractBedrockApi.AmazonBedrockInvocationMetrics amazonBedrockInvocationMetrics) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record AnthropicChatRequest(@JsonProperty(value="prompt") String prompt, @JsonProperty(value="temperature") Double temperature, @JsonProperty(value="max_tokens_to_sample") Integer maxTokensToSample, @JsonProperty(value="top_k") Integer topK, @JsonProperty(value="top_p") Double topP, @JsonProperty(value="stop_sequences") List<String> stopSequences, @JsonProperty(value="anthropic_version") String anthropicVersion) {
        public static Builder builder(String prompt) {
            return new Builder(prompt);
        }

        public static class Builder {
            private final String prompt;
            private Double temperature;
            private Integer maxTokensToSample;
            private Integer topK;
            private Double topP;
            private List<String> stopSequences;
            private String anthropicVersion;

            private Builder(String prompt) {
                this.prompt = prompt;
            }

            public Builder withTemperature(Double temperature) {
                this.temperature = temperature;
                return this;
            }

            public Builder withMaxTokensToSample(Integer maxTokensToSample) {
                this.maxTokensToSample = maxTokensToSample;
                return this;
            }

            public Builder withTopK(Integer topK) {
                this.topK = topK;
                return this;
            }

            public Builder withTopP(Double tpoP) {
                this.topP = tpoP;
                return this;
            }

            public Builder withStopSequences(List<String> stopSequences) {
                this.stopSequences = stopSequences;
                return this;
            }

            public Builder withAnthropicVersion(String anthropicVersion) {
                this.anthropicVersion = anthropicVersion;
                return this;
            }

            public AnthropicChatRequest build() {
                return new AnthropicChatRequest(this.prompt, this.temperature, this.maxTokensToSample, this.topK, this.topP, this.stopSequences, this.anthropicVersion);
            }
        }
    }

    public static enum AnthropicChatModel implements ChatModelDescription
    {
        CLAUDE_INSTANT_V1("anthropic.claude-instant-v1"),
        CLAUDE_V2("anthropic.claude-v2"),
        CLAUDE_V21("anthropic.claude-v2:1");

        private final String id;

        public String id() {
            return this.id;
        }

        private AnthropicChatModel(String value) {
            this.id = value;
        }

        public String getName() {
            return this.id;
        }
    }
}

