/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.anthropic;

import java.util.List;
import org.springframework.ai.bedrock.MessageToPromptConverter;
import org.springframework.ai.bedrock.anthropic.AnthropicChatOptions;
import org.springframework.ai.bedrock.anthropic.api.AnthropicChatBedrockApi;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.StreamingChatModel;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptionsUtils;
import reactor.core.publisher.Flux;

public class BedrockAnthropicChatModel
implements ChatModel,
StreamingChatModel {
    private final AnthropicChatBedrockApi anthropicChatApi;
    private final AnthropicChatOptions defaultOptions;

    public BedrockAnthropicChatModel(AnthropicChatBedrockApi chatApi) {
        this(chatApi, AnthropicChatOptions.builder().withTemperature(0.8).withMaxTokensToSample(500).withTopK(10).withAnthropicVersion("bedrock-2023-05-31").build());
    }

    public BedrockAnthropicChatModel(AnthropicChatBedrockApi chatApi, AnthropicChatOptions options) {
        this.anthropicChatApi = chatApi;
        this.defaultOptions = options;
    }

    public ChatResponse call(Prompt prompt) {
        AnthropicChatBedrockApi.AnthropicChatRequest request = this.createRequest(prompt);
        AnthropicChatBedrockApi.AnthropicChatResponse response = this.anthropicChatApi.chatCompletion(request);
        return new ChatResponse(List.of(new Generation(response.completion())));
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        AnthropicChatBedrockApi.AnthropicChatRequest request = this.createRequest(prompt);
        Flux<AnthropicChatBedrockApi.AnthropicChatResponse> fluxResponse = this.anthropicChatApi.chatCompletionStream(request);
        return fluxResponse.map(response -> {
            String stopReason = response.stopReason() != null ? response.stopReason() : null;
            Generation generation = new Generation(response.completion());
            if (response.amazonBedrockInvocationMetrics() != null) {
                generation = generation.withGenerationMetadata(ChatGenerationMetadata.from((String)stopReason, (Object)response.amazonBedrockInvocationMetrics()));
            }
            return new ChatResponse(List.of(generation));
        });
    }

    AnthropicChatBedrockApi.AnthropicChatRequest createRequest(Prompt prompt) {
        String promptValue = MessageToPromptConverter.create("\n").toPrompt(prompt.getInstructions());
        AnthropicChatBedrockApi.AnthropicChatRequest request = AnthropicChatBedrockApi.AnthropicChatRequest.builder(promptValue).build();
        if (this.defaultOptions != null) {
            request = (AnthropicChatBedrockApi.AnthropicChatRequest)ModelOptionsUtils.merge((Object)request, (Object)this.defaultOptions, AnthropicChatBedrockApi.AnthropicChatRequest.class);
        }
        if (prompt.getOptions() != null) {
            AnthropicChatOptions updatedRuntimeOptions = (AnthropicChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, AnthropicChatOptions.class);
            request = (AnthropicChatBedrockApi.AnthropicChatRequest)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)request, AnthropicChatBedrockApi.AnthropicChatRequest.class);
        }
        return request;
    }

    public ChatOptions getDefaultOptions() {
        return AnthropicChatOptions.fromOptions(this.defaultOptions);
    }
}

