/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.anthropic;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.ai.chat.prompt.ChatOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AnthropicChatOptions
implements ChatOptions {
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="max_tokens_to_sample")
    private Integer maxTokensToSample;
    @JsonProperty(value="top_k")
    private Integer topK;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="stop_sequences")
    private List<String> stopSequences;
    @JsonProperty(value="anthropic_version")
    private String anthropicVersion;

    public static Builder builder() {
        return new Builder();
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    @JsonIgnore
    public Integer getMaxTokens() {
        return this.getMaxTokensToSample();
    }

    @JsonIgnore
    public void setMaxTokens(Integer maxTokens) {
        this.setMaxTokensToSample(maxTokens);
    }

    public Integer getMaxTokensToSample() {
        return this.maxTokensToSample;
    }

    public void setMaxTokensToSample(Integer maxTokensToSample) {
        this.maxTokensToSample = maxTokensToSample;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    public Double getTopP() {
        return this.topP;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    public String getAnthropicVersion() {
        return this.anthropicVersion;
    }

    public void setAnthropicVersion(String anthropicVersion) {
        this.anthropicVersion = anthropicVersion;
    }

    @JsonIgnore
    public String getModel() {
        return null;
    }

    @JsonIgnore
    public Double getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Double getPresencePenalty() {
        return null;
    }

    public AnthropicChatOptions copy() {
        return AnthropicChatOptions.fromOptions(this);
    }

    public static AnthropicChatOptions fromOptions(AnthropicChatOptions fromOptions) {
        return AnthropicChatOptions.builder().withTemperature(fromOptions.getTemperature()).withMaxTokensToSample(fromOptions.getMaxTokensToSample()).withTopK(fromOptions.getTopK()).withTopP(fromOptions.getTopP()).withStopSequences(fromOptions.getStopSequences()).withAnthropicVersion(fromOptions.getAnthropicVersion()).build();
    }

    public static class Builder {
        private final AnthropicChatOptions options = new AnthropicChatOptions();

        public Builder withTemperature(Double temperature) {
            this.options.setTemperature(temperature);
            return this;
        }

        public Builder withMaxTokensToSample(Integer maxTokensToSample) {
            this.options.setMaxTokensToSample(maxTokensToSample);
            return this;
        }

        public Builder withTopK(Integer topK) {
            this.options.setTopK(topK);
            return this;
        }

        public Builder withTopP(Double topP) {
            this.options.setTopP(topP);
            return this;
        }

        public Builder withStopSequences(List<String> stopSequences) {
            this.options.setStopSequences(stopSequences);
            return this;
        }

        public Builder withAnthropicVersion(String anthropicVersion) {
            this.options.setAnthropicVersion(anthropicVersion);
            return this;
        }

        public AnthropicChatOptions build() {
            return this.options;
        }
    }
}

