/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.titan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.bedrock.titan.BedrockTitanEmbeddingOptions;
import org.springframework.ai.bedrock.titan.api.TitanEmbeddingBedrockApi;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.util.Assert;

public class BedrockTitanEmbeddingModel
extends AbstractEmbeddingModel {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final TitanEmbeddingBedrockApi embeddingApi;
    private InputType inputType = InputType.TEXT;

    public BedrockTitanEmbeddingModel(TitanEmbeddingBedrockApi titanEmbeddingBedrockApi) {
        this.embeddingApi = titanEmbeddingBedrockApi;
    }

    public BedrockTitanEmbeddingModel withInputType(InputType inputType) {
        this.inputType = inputType;
        return this;
    }

    public List<Double> embed(Document document) {
        return this.embed(document.getContent());
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        Assert.notEmpty((Collection)request.getInstructions(), (String)"At least one text is required!");
        if (request.getInstructions().size() != 1) {
            this.logger.warn("Titan Embedding does not support batch embedding. Will make multiple API calls to embed(Document)");
        }
        ArrayList<List<Double>> embeddingList = new ArrayList<List<Double>>();
        for (String inputContent : request.getInstructions()) {
            TitanEmbeddingBedrockApi.TitanEmbeddingRequest apiRequest = this.createTitanEmbeddingRequest(inputContent, request.getOptions());
            TitanEmbeddingBedrockApi.TitanEmbeddingResponse response = this.embeddingApi.embedding(apiRequest);
            embeddingList.add(response.embedding());
        }
        AtomicInteger indexCounter = new AtomicInteger(0);
        List<Embedding> embeddings = embeddingList.stream().map(e -> new Embedding(e, Integer.valueOf(indexCounter.getAndIncrement()))).toList();
        return new EmbeddingResponse(embeddings);
    }

    private TitanEmbeddingBedrockApi.TitanEmbeddingRequest createTitanEmbeddingRequest(String inputContent, EmbeddingOptions requestOptions) {
        InputType inputType = this.inputType;
        if (requestOptions != null && requestOptions instanceof BedrockTitanEmbeddingOptions) {
            BedrockTitanEmbeddingOptions bedrockTitanEmbeddingOptions = (BedrockTitanEmbeddingOptions)requestOptions;
            inputType = bedrockTitanEmbeddingOptions.getInputType();
        }
        return inputType == InputType.IMAGE ? new TitanEmbeddingBedrockApi.TitanEmbeddingRequest.Builder().withInputImage(inputContent).build() : new TitanEmbeddingBedrockApi.TitanEmbeddingRequest.Builder().withInputText(inputContent).build();
    }

    public int dimensions() {
        if (this.inputType == InputType.IMAGE && this.embeddingDimensions.get() < 0) {
            this.embeddingDimensions.set(BedrockTitanEmbeddingModel.dimensions((EmbeddingModel)this, (String)this.embeddingApi.getModelId(), (String)"iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNk+A8AAQUBAScY42YAAAAASUVORK5CYII="));
        }
        return super.dimensions();
    }

    public static enum InputType {
        TEXT,
        IMAGE;

    }
}

