/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.titan;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.ai.chat.prompt.ChatOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BedrockTitanChatOptions
implements ChatOptions {
    @JsonProperty(value="temperature")
    private Float temperature;
    @JsonProperty(value="topP")
    private Float topP;
    @JsonProperty(value="maxTokenCount")
    private Integer maxTokenCount;
    @JsonProperty(value="stopSequences")
    private List<String> stopSequences;

    public static Builder builder() {
        return new Builder();
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public Float getTopP() {
        return this.topP;
    }

    public void setTopP(Float topP) {
        this.topP = topP;
    }

    public Integer getMaxTokenCount() {
        return this.maxTokenCount;
    }

    public void setMaxTokenCount(Integer maxTokenCount) {
        this.maxTokenCount = maxTokenCount;
    }

    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    public void setStopSequences(List<String> stopSequences) {
        this.stopSequences = stopSequences;
    }

    public Integer getTopK() {
        throw new UnsupportedOperationException("Bedrock Titan Chat does not support the 'TopK' option.");
    }

    public void setTopK(Integer topK) {
        throw new UnsupportedOperationException("Bedrock Titan Chat does not support the 'TopK' option.'");
    }

    public static BedrockTitanChatOptions fromOptions(BedrockTitanChatOptions fromOptions) {
        return BedrockTitanChatOptions.builder().withTemperature(fromOptions.getTemperature()).withTopP(fromOptions.getTopP()).withMaxTokenCount(fromOptions.getMaxTokenCount()).withStopSequences(fromOptions.getStopSequences()).build();
    }

    public static class Builder {
        private BedrockTitanChatOptions options = new BedrockTitanChatOptions();

        public Builder withTemperature(Float temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder withTopP(Float topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder withMaxTokenCount(Integer maxTokenCount) {
            this.options.maxTokenCount = maxTokenCount;
            return this;
        }

        public Builder withStopSequences(List<String> stopSequences) {
            this.options.stopSequences = stopSequences;
            return this;
        }

        public BedrockTitanChatOptions build() {
            return this.options;
        }
    }
}

